/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.DPair;
import jedas.DTriple;
import jedas.DTuple;
import jedas.Jedas;
import jedas.Segment;

public class BezierSegment
extends Segment
implements Cloneable {
    static final long serialVersionUID = 7092955984204935674L;
    protected DTuple begin;
    protected DTuple end;
    protected DTuple int1;
    protected DTuple int2;
    private boolean reversed = false;
    private double t;
    private double t2;
    private double t3;
    private double s;
    private double s2;
    private double s3;

    public BezierSegment(DTuple begin, DTuple int1, DTuple int2, DTuple end, long time) {
        super(time);
        this.begin = begin;
        this.int1 = int1;
        this.int2 = int2;
        this.end = end;
        this.tuple = begin.dim == 2 ? new DPair(0.0, 0.0) : (begin.dim == 3 ? new DTriple(0.0, 0.0, 0.0) : new DTuple(begin.dim));
    }

    public DTuple interpolate() {
        this.t = this.reversed ? 1.0 - (double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / (double)this.time : (double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / (double)this.time;
        this.t2 = this.t * this.t;
        this.t3 = this.t2 * this.t;
        this.s = 1.0 - this.t;
        this.s2 = this.s * this.s;
        this.s3 = this.s2 * this.s;
        int i = 0;
        while (i < this.begin.dim) {
            this.tuple.value[i] = this.s3 * this.begin.value[i] + 3.0 * this.s2 * this.t * this.int1.value[i] + 3.0 * this.s * this.t2 * this.int2.value[i] + this.t3 * this.end.value[i];
            ++i;
        }
        return this.tuple;
    }

    public void translate(DTuple diff) {
        if (diff.dim != this.begin.dim) {
            System.err.println("BezierSegment.translate(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < this.begin.dim) {
            int n = i;
            this.begin.value[n] = this.begin.value[n] + diff.value[i];
            int n2 = i;
            this.int1.value[n2] = this.int1.value[n2] + diff.value[i];
            int n3 = i;
            this.int2.value[n3] = this.int2.value[n3] + diff.value[i];
            int n4 = i;
            this.end.value[n4] = this.end.value[n4] + diff.value[i];
            ++i;
        }
    }

    public void scale(DTuple fact) {
        if (fact.dim != this.begin.dim) {
            System.err.println("BezierSegment.scale(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < this.begin.dim) {
            int n = i;
            this.begin.value[n] = this.begin.value[n] * fact.value[i];
            int n2 = i;
            this.int1.value[n2] = this.int1.value[n2] * fact.value[i];
            int n3 = i;
            this.int2.value[n3] = this.int2.value[n3] * fact.value[i];
            int n4 = i;
            this.end.value[n4] = this.end.value[n4] * fact.value[i];
            ++i;
        }
    }

    protected void reverse() {
        this.reversed = true;
    }

    public DTuple getBegin() {
        return this.begin;
    }

    public DTuple getInt1() {
        return this.int1;
    }

    public DTuple getInt2() {
        return this.int2;
    }

    public DTuple getEnd() {
        return this.end;
    }
}

