/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.VolatileImage;
import java.util.Vector;
import jedas.CompPanelProperties;
import jedas.Composite;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.Item;
import jedas.Jedas;
import jedas.Properties;
import jedas.ZoomScrollListener;
import jedas.io.Attribute;
import jedas.utils.Misc;

public class CompPanel
extends Composite
implements ComponentListener {
    static final long serialVersionUID = 8220670280253718095L;
    private static final int GRID_SIZE = 900;
    private static final int GRID_FLAG = 901;
    private static final int PANEL_SIZE = 902;
    private static final int BG_COLOR = 903;
    private static final int GRID_COLOR = 904;
    private static final int HOT_SPOT = 905;
    private static final int ZOOM = 906;
    private static RenderingHints renderingHints_antialaising_on = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static RenderingHints renderingHints_antialaising_off = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    transient DrawPanel drawPanel;
    DrawAttr drawAttr;
    private transient VolatileImage offScreen;
    private boolean showGrid = false;
    private DPair gridSize = null;
    private int width;
    private int height;
    private Color bgColor = Color.white;
    private Color gridColor = Color.lightGray;
    private boolean syssync = true;
    private boolean graphsync = true;
    private String panelName = "JEDAS Animation";
    private transient Thread mainThread;
    private transient Vector zoomListeners;
    private transient boolean isUpdating;
    private transient boolean needsUpdate;
    private int graphics_quality = 10;
    private boolean automaticQualityAdjustment = false;
    private int desiredFrameRate = 25;

    public CompPanel() {
        this.drawPanel = new DrawPanel(this);
        this.drawPanel.setBackground(this.bgColor);
        this.drawPanel.addComponentListener(this);
        this.drawAttr = new DrawAttr();
        this.zoomListeners = new Vector();
        this.createDoubleBuffer();
        this.setEnabled(true);
    }

    public void initOnPlay() {
        this.drawPanel = new DrawPanel(this);
        this.drawPanel.setBackground(this.bgColor);
        this.drawPanel.addComponentListener(this);
        this.createDoubleBuffer();
    }

    public void setGraphicsQuality(String quality, boolean autoAdjustment) {
        this.automaticQualityAdjustment = autoAdjustment;
        if (quality.equalsIgnoreCase("high")) {
            if (this.graphics_quality != 10) {
                this.graphics_quality = 10;
                this.adjustGraphicsQuality();
            }
            return;
        }
        if (quality.equalsIgnoreCase("low")) {
            if (this.graphics_quality != 0) {
                this.graphics_quality = 0;
                this.adjustGraphicsQuality();
            }
            return;
        }
    }

    private void adjustGraphicsQuality() {
        switch (this.graphics_quality) {
            case 0: {
                if (this.drawAttr.graphics == null) break;
                ((Graphics2D)this.drawAttr.graphics).setRenderingHints(renderingHints_antialaising_off);
                break;
            }
            case 10: {
                if (this.drawAttr.graphics == null) break;
                ((Graphics2D)this.drawAttr.graphics).setRenderingHints(renderingHints_antialaising_on);
            }
        }
    }

    public void autoAdjustGraphicsQuality(int frame_rate) {
        if (!this.automaticQualityAdjustment) {
            return;
        }
        if (frame_rate < this.desiredFrameRate - 5) {
            if (this.graphics_quality != 0) {
                this.graphics_quality = 0;
                this.adjustGraphicsQuality();
            }
            return;
        }
        if (frame_rate > this.desiredFrameRate + 5) {
            if (this.graphics_quality != 10) {
                this.graphics_quality = 10;
                this.adjustGraphicsQuality();
            }
            return;
        }
    }

    public void setDesiredFrameRate(int desiredFrameRate) {
        if (desiredFrameRate < 5) {
            desiredFrameRate = 5;
        }
        if (desiredFrameRate > 100) {
            desiredFrameRate = 100;
        }
        this.desiredFrameRate = desiredFrameRate;
    }

    public int getDesiredFrameRate() {
        return this.desiredFrameRate;
    }

    public Panel getDrawPanel() {
        return this.drawPanel;
    }

    public DrawAttr getDrawAttr() {
        return this.drawAttr;
    }

    public Composite getParent() {
        return null;
    }

    private void createDoubleBuffer() {
        if (Jedas.DEBUGMODE) {
            System.err.println("CompPanel::createDoubleBuffer()");
        }
        this.width = this.drawPanel.getSize().width;
        this.height = this.drawPanel.getSize().height;
        if (Jedas.DEBUGMODE) {
            System.err.println("Width=" + this.width + ", Height=" + this.height);
        }
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        this.offScreen = this.drawPanel.createVolatileImage(this.width, this.height);
        if (this.offScreen == null) {
            System.err.println("offScreen is null");
        }
        MediaTracker mt = new MediaTracker(this.drawPanel);
        mt.addImage(this.offScreen, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.offScreen == null) {
            System.err.println("createImage() in createDoubleBuffer() failed!");
            System.exit(1);
        }
        if (this.offScreen.getGraphics() == null) {
            System.err.println("offScreen.getGraphics() failed!");
        }
        this.drawAttr.setGraphics(this.offScreen.getGraphics());
        this.drawAttr.setDimension(this.drawPanel.getSize());
        this.adjustGraphicsQuality();
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.updateDrawAttr(this.drawAttr);
            tmp = this.getNextItem();
        }
    }

    public void setGridSize(DPair gridSize) {
        this.addAttributeToQueue(900, new Attribute(Jedas.getRecordTime(), gridSize));
        this.gridSize = gridSize != null ? gridSize : new DPair(0.1, 0.1);
    }

    public void setGrid(boolean b) {
        this.showGrid = b;
        this.markChanged();
        this.addAttributeToQueue(901, new Attribute(Jedas.getRecordTime(), new Boolean(b)));
    }

    public void setGridColor(Color c) {
        if (c == null) {
            return;
        }
        this.gridColor = Misc.cloneColor(c);
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(904, new Attribute(Misc.cloneColor(c)));
        }
    }

    public void setBackground(Color color) {
        this.addAttributeToQueue(903, new Attribute(color));
        this.drawPanel.setBackground(color);
        this.markChanged();
        this.bgColor = color;
    }

    public Vector getAllRealObjects() {
        Vector objs = new Vector();
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.addRealObjects(objs);
            tmp = this.getNextItem();
        }
        return objs;
    }

    public final Vector getAllObjects() {
        Vector objs = new Vector();
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.addAllObjects(objs);
            tmp = this.getNextItem();
        }
        return objs;
    }

    public void setPreferredSize(Dimension size) {
        this.drawPanel.setPreferredSize(size);
    }

    public synchronized void updatePanel() {
        Jedas.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateDisplay() {
        if (this.offScreen == null || this.drawAttr == null) {
            return;
        }
        if (this.drawAttr.graphics == null) {
            return;
        }
        CompPanel compPanel = this;
        synchronized (compPanel) {
            if (this.isUpdating) {
                if (Jedas.DEBUGMODE) {
                    System.err.println(this.getName() + " is already updating!");
                }
                return;
            }
            this.isUpdating = true;
        }
        try {
            CompPanel compPanel2 = this;
            synchronized (compPanel2) {
                if (!this.drawPanel.hasPainted()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.drawAttr.graphics.setColor(this.bgColor);
        this.drawAttr.graphics.fillRect(0, 0, this.width, this.height);
        if (this.showGrid) {
            this.drawGrid();
        }
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.superDraw();
            tmp = this.getNextItem();
        }
        this.drawPanel.doPaint(this.drawPanel.getGraphics());
        this.isUpdating = false;
    }

    private void drawGrid() {
        int x;
        if (this.gridSize == null) {
            this.gridSize = new DPair(0.1, 0.1);
        }
        this.drawAttr.graphics.setColor(this.gridColor);
        int y = this.drawAttr.getPosY(0.0);
        int gh = this.drawAttr.getHeight(1.0);
        double d = 0.0;
        while (d < 1.0) {
            x = this.drawAttr.getPosX(d);
            this.drawAttr.graphics.drawLine(x, y, x, gh + y);
            d += this.gridSize.value[1];
        }
        x = this.drawAttr.getPosX(0.0);
        int gw = this.drawAttr.getWidth(1.0);
        double d2 = 0.0;
        while (d2 < 1.0) {
            y = this.drawAttr.getPosY(d2);
            this.drawAttr.graphics.drawLine(x, y, gw + x, y);
            d2 += this.gridSize.value[0];
        }
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 900: {
                this.setGridSize((DPair)attr.value);
                break;
            }
            case 901: {
                this.setGrid((Boolean)attr.value);
                break;
            }
            case 904: {
                this.setGridColor((Color)attr.value);
                break;
            }
            case 902: {
                if (this.drawPanel == null) {
                    this.initOnPlay();
                }
                if (this.drawPanel == null) break;
                this.drawPanel.setSize((Dimension)attr.value);
                break;
            }
            case 903: {
                this.setBackground((Color)attr.value);
                break;
            }
            case 905: {
                this.setHotSpot((DPair)attr.value);
                break;
            }
            case 906: {
                this.setZoom((Double)attr.value);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        CompPanelProperties cpp = (CompPanelProperties)p;
        if (this.drawPanel == null) {
            this.initOnPlay();
        }
        this.setGrid(cpp.showGrid);
        this.setGridSize(cpp.gridSize);
        if (cpp.gridColor != null) {
            this.gridColor = Misc.cloneColor(cpp.gridColor);
        }
        this.setBackground(cpp.bgColor);
        this.setHotSpotTrans(Misc.cloneDPair(cpp.hotSpot));
        this.setZoomTrans(cpp.zoomFactor);
    }

    public Properties getProperties() {
        CompPanelProperties cpp = new CompPanelProperties();
        return this.getProperties(cpp);
    }

    public Properties getProperties(Properties p) {
        CompPanelProperties cpp = (CompPanelProperties)super.getProperties(p);
        cpp.dimension = this.drawPanel != null ? this.drawPanel.getSize() : null;
        if (Jedas.IO_DEBUGMODE) {
            System.out.print("CompPanel::getProperties() size of DrawPanel: ");
            if (cpp.dimension != null) {
                System.out.println(cpp.dimension.width + "x" + cpp.dimension.height);
            } else {
                System.out.println("<null>");
            }
        }
        cpp.showGrid = this.showGrid;
        cpp.gridSize = this.gridSize;
        cpp.bgColor = Misc.cloneColor(this.bgColor);
        cpp.gridColor = this.gridColor != null ? Misc.cloneColor(this.gridColor) : null;
        cpp.hotSpot = this.getHotSpot();
        cpp.zoomFactor = this.getZoom();
        return cpp;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setZoom(double newZoom) {
        this.setZoomTrans(newZoom);
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(906, new Attribute(new Double(newZoom)));
        }
    }

    protected void setZoomTrans(double newZoom) {
        this.getDrawAttr().setZoom(newZoom);
        this.propertiesChanged();
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.zoomNotify();
            tmp = this.getNextItem();
        }
        if (this.zoomListeners != null) {
            int i = 0;
            while (i < this.zoomListeners.size()) {
                ((ZoomScrollListener)this.zoomListeners.elementAt(i)).zoomChanged(newZoom);
                ++i;
            }
        }
    }

    public double getZoom() {
        return this.getDrawAttr().getZoom();
    }

    public void setHotSpot(DPair hotSpot) {
        this.setHotSpotTrans(hotSpot);
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(905, new Attribute(Misc.cloneDPair(hotSpot)));
        }
    }

    protected void setHotSpotTrans(DPair hotSpot) {
        this.getDrawAttr().setHotSpot(hotSpot);
        this.propertiesChanged();
        if (this.zoomListeners != null) {
            int i = 0;
            while (i < this.zoomListeners.size()) {
                ((ZoomScrollListener)this.zoomListeners.elementAt(i)).hotSpotChanged(hotSpot);
                ++i;
            }
        }
    }

    public DPair getHotSpot() {
        return this.getDrawAttr().getHotSpot();
    }

    public void addZoomScrollListener(ZoomScrollListener zsl) {
        this.zoomListeners.addElement(zsl);
    }

    public void removeZoomScrollListener(ZoomScrollListener zsl) {
        this.zoomListeners.removeElement(zsl);
    }

    protected void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    public void setEnabled(boolean b) {
        if (b) {
            Jedas.addCompPanel(this);
        } else {
            Jedas.removeCompPanel(this);
        }
    }

    public final void addAllItems(Vector objects) {
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.addAllItems(objects);
            tmp = this.getNextItem();
        }
    }

    public final void addAllChangedItems(Vector objects) {
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.addAllChangedItems(objects);
            tmp = this.getNextItem();
        }
    }

    public void componentResized(ComponentEvent e) {
        if (Jedas.DEBUGMODE) {
            System.err.println("CompPanel::componentResized()");
        }
        this.createDoubleBuffer();
        if (Jedas.getScheduler() != null) {
            if (!Jedas.getScheduler().isRunning()) {
                this.updatePanel();
            }
        } else {
            this.updatePanel();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    class DrawPanel
    extends Panel {
        private int frameCount = 0;
        private CompPanel parent;
        private RepaintThread repaintThread;
        private Graphics graphics;
        private boolean hasPainted = true;
        private Dimension preferredSize = new Dimension(400, 400);

        public DrawPanel(CompPanel parent) {
            this.parent = parent;
            this.repaintThread = new RepaintThread();
            this.repaintThread.start();
        }

        public void doPaint(Graphics g) {
            this.graphics = g;
            this.hasPainted = false;
            this.repaintThread.requestPaint();
        }

        public boolean hasPainted() {
            return this.hasPainted;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (CompPanel.this.offScreen != null && g != null) {
                g.drawImage(CompPanel.this.offScreen, 0, 0, this);
                if (CompPanel.this.syssync) {
                    this.getToolkit().sync();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint2(Graphics g) {
            this.paint(g);
            CompPanel compPanel = this.parent;
            synchronized (compPanel) {
                this.hasPainted = true;
                this.parent.notify();
            }
        }

        public void setPreferredSize(Dimension preferredSize) {
            this.preferredSize = preferredSize;
        }

        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        private class RepaintThread
        extends Thread {
            private RepaintThread() {
            }

            public void run() {
                DrawPanel.this.repaintThread = this;
                DrawPanel.this.paint2(DrawPanel.this.graphics);
            }

            public void requestPaint() {
                this.run();
            }
        }
    }
}

