/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jedas.ControlUnit;
import jedas.ControlUnitListener;
import jedas.FrameStatDisplay;
import jedas.Jedas;
import jedas.JedasApplication;
import jedas.Scheduler;
import jedas.SurveyorListener;
import jedas.utils.LightLabel;
import jedas.utils.SettingsPopup;
import jedas.utils.ToolButton;

public class ControlPanel
extends Panel
implements SurveyorListener,
FrameStatDisplay {
    protected static final int PLAY = 1;
    protected static final int PAUSE = 2;
    protected static final int STOP = 3;
    protected static final int RESET = 4;
    protected static final int QUIT = 5;
    private ControlUnit controlUnit;
    private ToolButton tbPlay;
    private ToolButton tbPause;
    private ToolButton tbReset;
    private ToolButton tbQuit;
    private Scrollbar speedControl;
    private LightLabel lbFrames;
    private LightLabel lbSpeed;
    private LightLabel lbRecTime;
    private SettingsPopup settingsPopup;
    private boolean resetting = false;

    public ControlPanel(JedasApplication runnable, Scheduler scheduler) {
        this.controlUnit = new ControlUnit(runnable, scheduler, this);
        scheduler.addFrameStatDisplay(this);
        this.setLayout(null);
        this.setSize(330, 60);
        this.setBackground(new Color(0xD5D5D5));
        String path = "images/";
        MyMouseAdapter ml = new MyMouseAdapter();
        Dimension dim = new Dimension(45, 27);
        Dimension pos = new Dimension(2, 2);
        this.tbPlay = new ToolButton(null, pos, dim, path + "play.gif", null, 1, false, ml);
        this.tbPlay.setDisabledImage(path + "playdis.gif");
        this.add(this.tbPlay);
        pos = new Dimension(52, 2);
        this.tbPause = new ToolButton(null, pos, dim, path + "pause.gif", null, 2, false, ml);
        this.tbPause.setDisabledImage(path + "pausedis.gif");
        this.add(this.tbPause);
        pos = new Dimension(102, 2);
        this.tbReset = new ToolButton(null, pos, dim, path + "reset.gif", null, 4, false, ml);
        this.tbReset.setDisabledImage(path + "resetdis.gif");
        this.add(this.tbReset);
        pos = new Dimension(172, 2);
        this.tbQuit = new ToolButton(null, pos, dim, path + "quit.gif", null, 5, false, ml);
        this.tbQuit.setDisabledImage(path + "quitdis.gif");
        this.add(this.tbQuit);
        if (Jedas.isApplet()) {
            this.tbQuit.setEnabled(false);
        }
        this.speedControl = new Scrollbar(0, 50, 30, 1, 330);
        this.speedControl.setSize(new Dimension(262, 12));
        this.speedControl.setLocation(5, 40);
        this.add(this.speedControl);
        this.speedControl.addAdjustmentListener(new SpeedChangeListener());
        this.lbFrames = new LightLabel("0.0 fps");
        this.lbFrames.setLocation(274, 5);
        this.lbFrames.setSize(60, 16);
        this.add(this.lbFrames);
        this.lbSpeed = new LightLabel("100%");
        this.lbSpeed.setLocation(274, 37);
        this.lbSpeed.setSize(60, 16);
        this.add(this.lbSpeed);
        this.lbRecTime = new LightLabel("0:00:00.000");
        this.lbRecTime.setLocation(274, 21);
        this.lbRecTime.setSize(130, 16);
        this.add(this.lbRecTime);
        Thread recRepaint = new Thread(){

            public void run() {
                while (true) {
                    if (Jedas.isRecording()) {
                        ControlPanel.this.lbRecTime.setText(ControlPanel.this.getTimeString(Jedas.getRecordTime()));
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
        };
        recRepaint.start();
        this.tbPlay.setEnabled(true);
        this.tbPause.setEnabled(false);
        this.tbReset.setEnabled(false);
        this.settingsPopup = new SettingsPopup();
        this.add(this.settingsPopup);
        this.addMouseListener(new MouseClickListener());
    }

    public void play() {
        if (!this.tbPlay.isEnabled()) {
            System.err.println("ControlPanel::play() not possible!");
            return;
        }
        this.tbPlay.setEnabled(false);
        this.tbPause.setEnabled(true);
        this.tbReset.setEnabled(false);
        this.controlUnit.play();
    }

    public void pause() {
        if (!this.tbPause.isEnabled()) {
            System.err.println("ControlPanel::pause() not possible!");
            return;
        }
        this.tbPlay.setEnabled(true);
        this.tbPause.setEnabled(false);
        this.tbReset.setEnabled(true);
        this.controlUnit.pause();
    }

    public void stop() {
        this.tbPlay.setEnabled(false);
        this.tbPause.setEnabled(false);
        this.tbReset.setEnabled(true);
        this.controlUnit.stop();
    }

    public void reset() {
        if (!this.tbReset.isEnabled()) {
            System.err.println("ControlPanel::reset() not possible!");
            return;
        }
        this.resetting = true;
        this.controlUnit.reset();
        this.tbPlay.setEnabled(true);
        this.tbPause.setEnabled(false);
        this.tbReset.setEnabled(false);
        this.resetting = false;
    }

    public void quit() {
        if (!this.tbQuit.isEnabled()) {
            System.err.println("ControlPanel::quit() not allowed!");
            return;
        }
        this.controlUnit.quit();
    }

    public void addControlUnitListener(ControlUnitListener cul) {
        this.controlUnit.addControlUnitListener(cul);
    }

    public void removeControlUnitListener(ControlUnitListener cul) {
        this.controlUnit.removeControlUnitListener(cul);
    }

    public void threadHasDied(Thread thread) {
        if (!this.resetting) {
            this.tbPlay.setEnabled(false);
            this.tbPause.setEnabled(false);
            this.tbReset.setEnabled(true);
        } else {
            this.resetting = false;
        }
    }

    public void enablePlay() {
        this.controlUnit.enablePlay();
        this.tbPlay.setEnabled(true);
    }

    public void displayFps(double fpsRate) {
        double fpsRound = (double)Math.round(fpsRate * 10.0) / 10.0;
        this.lbFrames.setText(fpsRound + " fps");
    }

    public Dimension getPreferredSize() {
        return new Dimension(360, 60);
    }

    private String make2(int number) {
        String tmp = "" + number;
        if (tmp.length() == 1) {
            return "0" + tmp;
        }
        return tmp;
    }

    private String make3(long number) {
        String tmp = "" + number;
        switch (tmp.length()) {
            case 1: {
                return "00" + tmp;
            }
            case 2: {
                return "0" + tmp;
            }
        }
        return tmp;
    }

    public String getTimeString(long timeStamp) {
        int seconds;
        int minutes;
        long span = timeStamp;
        int hours = (int)(span / 3600000L);
        if (hours > 0) {
            span %= (long)(hours * 3600000);
        }
        if ((minutes = (int)(span / 60000L)) > 0) {
            span %= (long)(minutes * 60000);
        }
        if ((seconds = (int)(span / 1000L)) > 0) {
            span %= (long)(seconds * 1000);
        }
        return hours + ":" + this.make2(minutes) + ":" + this.make2(seconds) + "." + this.make3(span);
    }

    private class MouseClickListener
    extends MouseAdapter {
        private MouseClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            this.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.mousePressed(e);
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ControlPanel.this.settingsPopup.initItems();
                ControlPanel.this.settingsPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        private ToolButton pressedButton_ = null;
        private boolean isInButton_ = false;

        MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void realMouseClicked(MouseEvent e) {
            int tag = ((ToolButton)e.getSource()).getTag();
            int subTag = ((ToolButton)e.getSource()).getSubTag();
            switch (tag) {
                case 1: {
                    if (Jedas.DEBUGMODE) {
                        System.err.println("ControlPanel::PLAY");
                    }
                    ControlPanel.this.play();
                    break;
                }
                case 2: {
                    if (Jedas.DEBUGMODE) {
                        System.err.println("ControlPanel::PAUSE");
                    }
                    ControlPanel.this.pause();
                    break;
                }
                case 3: {
                    if (Jedas.DEBUGMODE) {
                        System.err.println("ControlPanel::STOP");
                    }
                    ControlPanel.this.stop();
                    break;
                }
                case 4: {
                    if (Jedas.DEBUGMODE) {
                        System.err.println("ControlPanel::RESET");
                    }
                    ControlPanel.this.reset();
                    break;
                }
                case 5: {
                    if (Jedas.DEBUGMODE) {
                        System.err.println("ControlPanel::QUIT");
                    }
                    ControlPanel.this.quit();
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            this.pressedButton_ = (ToolButton)e.getSource();
            this.isInButton_ = true;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isInButton_) {
                this.realMouseClicked(e);
            }
            this.pressedButton_ = null;
        }

        public void mouseEntered(MouseEvent e) {
            if (this.pressedButton_ != null && (ToolButton)e.getSource() == this.pressedButton_) {
                this.isInButton_ = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.pressedButton_ != null && (ToolButton)e.getSource() == this.pressedButton_) {
                this.isInButton_ = false;
            }
        }
    }

    class SpeedChangeListener
    implements AdjustmentListener {
        SpeedChangeListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            ControlPanel.this.setEnabled(false);
            ControlPanel.this.lbSpeed.setText(2 * e.getValue() + "%");
            ControlPanel.this.controlUnit.setSpeed(2 * e.getValue());
            ControlPanel.this.setEnabled(true);
        }
    }
}

