/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.Serializable;

public class DTuple
implements Cloneable,
Serializable {
    static final long serialVersionUID = 3834845822590403902L;
    public int dim;
    public double[] value;

    public DTuple() {
        this.dim = -1;
    }

    public DTuple(int dim) {
        this.dim = dim;
        this.value = new double[dim];
    }

    public DTuple(double[] value) {
        this.dim = value.length;
        this.value = new double[this.dim];
        System.arraycopy(value, 0, this.value, 0, this.dim);
    }

    public boolean equals(Object obj) {
        if (((DTuple)obj).dim != this.dim) {
            return false;
        }
        int i = 0;
        while (i < this.dim) {
            if (((DTuple)obj).value[i] != this.value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        return new DTuple(this.value);
    }

    public double get(int i) {
        if (i < 0) {
            System.err.println("DTuple::get() Invalid dimension. Tuple not initialized.");
            return 0.0;
        }
        if (i >= this.dim) {
            System.err.println("DTuple::get() Index " + i + " out of range: " + this.dim);
            return 0.0;
        }
        return this.value[i];
    }

    public int getDim() {
        return this.dim;
    }

    public void set(int i, double value) {
        if (i < 0) {
            System.err.println("DTuple::set(int,double) Invalid dimenstion. Tuple not initialized.");
            return;
        }
        if (i >= this.dim) {
            System.err.println("DTuple::set(int,double) Index " + i + " out of range: " + this.dim);
            return;
        }
        this.value[i] = value;
    }

    public void setDim(int dim) {
        double[] tmp = new double[dim];
        int i = 0;
        while (i < (dim < this.dim ? dim : this.dim)) {
            tmp[i] = this.value[i];
            ++i;
        }
        this.dim = dim;
        this.value = tmp;
    }

    public String toString() {
        String str = super.toString();
        str = str + "(";
        int i = 0;
        while (i < this.dim - 1) {
            str = str + "" + this.value[i] + ",";
            ++i;
        }
        str = str + "" + this.value[this.dim - 1] + ")";
        return str;
    }
}

