/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.DPair;
import jedas.DTuple;
import jedas.Jedas;
import jedas.Segment;

public class EllipseSegment
extends Segment
implements Cloneable {
    static final long serialVersionUID = -5912787132338315275L;
    protected DTuple begin;
    protected DTuple end;
    private int sense;
    private double ampl;
    private double angle;
    private double back_ampl;
    private double dist;
    private double lambda;
    private boolean reversed = false;

    public EllipseSegment(DTuple begin, DTuple end, double ampl, int sense, long time) {
        super(time);
        if (begin.dim != 2) {
            System.err.println("EllipseSegment(): Only for 2-dim values!");
            return;
        }
        this.begin = begin;
        this.end = end;
        this.back_ampl = ampl;
        this.sense = sense;
        this.init();
        this.tuple = new DPair(0.0, 0.0);
    }

    private void init() {
        this.angle = Math.atan2(this.end.value[1] - this.begin.value[1], this.end.value[0] - this.begin.value[0]);
        this.dist = Math.sqrt((this.begin.value[0] - this.end.value[0]) * (this.begin.value[0] - this.end.value[0]) + (this.begin.value[1] - this.end.value[1]) * (this.begin.value[1] - this.end.value[1])) / 2.0;
        this.ampl = this.sense == 1 ? -2.0 * this.back_ampl : 2.0 * this.back_ampl;
    }

    public DTuple interpolate() {
        this.lambda = this.reversed ? Math.PI * ((double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / (double)this.time) : Math.PI * (1.0 - (double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / (double)this.time);
        double px = this.dist * (Math.cos(this.lambda) + 1.0);
        double py = this.dist * Math.sin(this.lambda) * this.ampl;
        this.tuple.value[0] = this.begin.value[0] + Math.cos(this.angle) * px - Math.sin(this.angle) * py;
        this.tuple.value[1] = this.begin.value[1] + Math.sin(this.angle) * px + Math.cos(this.angle) * py;
        return this.tuple;
    }

    public void translate(DTuple diff) {
        if (diff.dim != this.begin.dim) {
            System.err.println("EllipseSegment.translate(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < this.begin.dim) {
            int n = i;
            this.begin.value[n] = this.begin.value[n] + diff.value[i];
            int n2 = i;
            this.end.value[n2] = this.end.value[n2] + diff.value[i];
            ++i;
        }
        this.init();
    }

    public void scale(DTuple fact) {
        if (fact.dim != this.begin.dim) {
            System.err.println("EllipseSegment.scale(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < this.begin.dim) {
            int n = i;
            this.begin.value[n] = this.begin.value[n] * fact.value[i];
            int n2 = i;
            this.end.value[n2] = this.end.value[n2] * fact.value[i];
            ++i;
        }
        this.init();
    }

    protected void reverse() {
        this.reversed = true;
    }

    public DTuple getBegin() {
        return this.begin;
    }

    public DTuple getEnd() {
        return this.end;
    }

    public double getAmpl() {
        return this.ampl;
    }

    public double getSense() {
        return this.sense;
    }
}

