/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.FrameStatDisplay;

public class FrameStat {
    private final int REPORTFRAMES = 100;
    private final int REPORTTIME = 1000;
    private long reportframes;
    private long reporttime;
    private long unreportedframes;
    private long orig;
    private long start;
    private int frame;
    private FrameStatDisplay display;

    public FrameStat(FrameStatDisplay display) {
        this.display = display;
        this.init();
    }

    public void init() {
        this.reportframes = 100L;
        this.reporttime = 1000L;
        this.unreportedframes = 0L;
        this.start = this.orig = System.currentTimeMillis();
        this.frame = 0;
    }

    public void update() {
        ++this.frame;
        if (++this.unreportedframes >= this.reportframes) {
            this.unreportedframes = 0L;
            long end = System.currentTimeMillis();
            long rel = end - this.start;
            long tot = end - this.orig;
            double rate = -1.0;
            if (rel != 0L) {
                rate = (float)this.reportframes / ((float)rel / 1000.0f);
            }
            this.start = end;
            if (rel != 0L) {
                this.reportframes = this.reportframes * this.reporttime / rel;
            }
            if (rate >= 0.0) {
                this.display.displayFps(rate);
            }
        }
    }
}

