/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import jedas.DPair;
import jedas.GraphItem;
import jedas.GraphItemProperties;
import jedas.Obj;
import jedas.Properties;
import jedas.io.Attribute;
import jedas.utils.Misc;

public abstract class GraphObj
extends Obj
implements GraphItem {
    static final long serialVersionUID = -8627315900532442263L;
    private static final Color FILLCOLOR = Color.white;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int FIXED = 0;
    public static final int RELATIVE = 1;
    public static final int LINE = 0;
    public static final int CIRCLE = 1;
    static final int ATTR_FILLED = 600;
    static final int ATTR_FILLCOLOR = 601;
    private Color fillcolor;
    private boolean filled = false;
    private int lineStyle;
    private int lineType;
    private int absLineWidth;
    private double relLineWidth;

    public GraphObj(DPair pos, DPair size, Color color, Color fillcolor) {
        super(pos, size, color);
        this.fillcolor = fillcolor;
    }

    public GraphObj(DPair pos, DPair size, Color color, Color fillcolor, Color hlcolor) {
        super(pos, size, color, hlcolor);
        this.fillcolor = fillcolor;
    }

    public GraphObj(DPair pos, DPair size, Color color, Color fillColor, boolean filled) {
        this(pos, size, color, fillColor);
        this.filled = filled;
    }

    public void setLineType(int type) {
        this.lineType = type;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineWidth(int width) {
        this.absLineWidth = width;
    }

    public int getLineWidth() {
        return this.absLineWidth;
    }

    public void setRelLineWidth(double width) {
        this.relLineWidth = width;
    }

    public double getRelLineWidth() {
        return this.relLineWidth;
    }

    public void setLineStyle(int newStyle) {
        this.lineStyle = newStyle;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public final void setFillColor(Color color) {
        this.setFillColorTrans(color);
        Color newColor = null;
        if (color != null) {
            newColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        }
        this.markChanged();
        this.addAttributeToQueue(601, new Attribute(newColor));
    }

    public void setFillColorTrans(Color color) {
        this.fillcolor = color;
    }

    public Color getFillColor() {
        return this.fillcolor;
    }

    public void setFilled(boolean b) {
        this.filled = b;
        this.addAttributeToQueue(600, new Attribute(new Boolean(this.filled)));
        this.markChanged();
    }

    public void setFilledTrans(boolean b) {
        this.filled = b;
        this.markChanged();
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 600: {
                this.setFilled((Boolean)attr.value);
                break;
            }
            case 601: {
                Color c = (Color)attr.value;
                Color newC = new Color(c.getRed(), c.getGreen(), c.getBlue());
                this.setFillColor(newC);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        GraphItemProperties pop = (GraphItemProperties)p;
        this.setFilled(pop.filled);
        this.setFillColor(Misc.cloneColor(pop.fillColor));
    }

    public Properties getProperties() {
        GraphItemProperties gop = new GraphItemProperties();
        return this.getProperties(gop);
    }

    public Properties getProperties(Properties p) {
        GraphItemProperties gop = (GraphItemProperties)super.getProperties(p);
        gop.filled = this.isFilled();
        gop.fillColor = Misc.cloneColor(this.getFillColor());
        return gop;
    }
}

