/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jedas.AofClient;
import jedas.CompPanel;
import jedas.Recordable;
import jedas.Scheduler;
import jedas.io.JedasIOException;
import jedas.io.RecordPanel;
import jedas.io.Recorder;

public class Jedas {
    public static final String VERSION = "201";
    public static final String ARCHIVE = "jedas201.jar";
    public static final String ANNO_ARCH = "jedas201.jar";
    public static int XFIG_X_SCALE = 12;
    public static int XFIG_Y_SCALE = 12;
    public static int XFIG_DEPTH;
    public static final Color DEFAULT_BGCOLOR;
    public static long recordTime;
    public static long timeSync;
    private static long manualRecordTime_;
    private static boolean manualRecordTimeMode_;
    public static long drawSync;
    public static long playSync;
    public static boolean COMPRESS_OUTPUT;
    private static boolean appletMode;
    private static URL codebase;
    private static Applet applet;
    private static Frame mainFrame;
    private static Vector compositeList;
    private static Hashtable recTable;
    private static Hashtable compPanelTable;
    private static boolean recording;
    private static Recorder recorder;
    private static boolean normalMode;
    private static boolean playerMode;
    private static boolean reallyUpdateDisplay;
    private static long recordStartTime;
    public static int TRANSITION_DELAY;
    public static int MAX_ABS_TRANS;
    public static int MAX_TAS_CHANGES;
    public static int MAX_PAS_CHANGES;
    public static boolean DEBUGMODE;
    public static boolean IO_DEBUGMODE;
    private static Scheduler scheduler;
    private static AofClient aofClient;
    private static boolean aofMode;

    protected static final void setAppletMode(boolean b) {
        appletMode = b;
    }

    protected static final void setCodeBase(URL url) {
        codebase = url;
    }

    protected static final void setApplet(Applet a) {
        applet = a;
    }

    public static boolean isApplet() {
        return appletMode;
    }

    public static URL getCodeBase() {
        return codebase;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void updateDisplay() {
        if (scheduler != null) {
            scheduler.updateDisplay();
        } else {
            Enumeration compPanels = Jedas.compPanels();
            while (compPanels.hasMoreElements()) {
                CompPanel panel = (CompPanel)compPanels.nextElement();
                panel.updateDisplay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerRecordable(Recordable rec) {
        Hashtable hashtable = recTable;
        synchronized (hashtable) {
            recTable.put(new Long(rec.getID()), rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterRecordable(long recID) {
        Hashtable hashtable = recTable;
        synchronized (hashtable) {
            Recordable rec = (Recordable)recTable.remove(new Long(recID));
            if (rec == null && !Jedas.isPlayerMode()) {
                System.err.println("Jedas::unregisterRecordable() Recordable not in table!");
            }
        }
    }

    protected static Recordable findRecordable(long recID) {
        Recordable tmp = (Recordable)recTable.get(new Long(recID));
        if (tmp == null) {
            System.err.println("Jedas::findRecordable() Recordable not in table!");
        }
        return tmp;
    }

    public static Hashtable getRecordableTable() {
        return recTable;
    }

    public static boolean isRecording() {
        return recording;
    }

    protected static void setNormalMode(boolean b) {
        normalMode = b;
    }

    public static boolean isNormalMode() {
        return normalMode;
    }

    public static void setPlayerMode(boolean b) {
        if (b) {
            if (!Jedas.isNormalMode()) {
                playerMode = b;
            } else {
                System.err.println("Jedas::setPlayerMode() Cannot set playerMode manually!");
            }
        } else {
            playerMode = false;
        }
    }

    public static boolean isPlayerMode() {
        return playerMode;
    }

    public static boolean setRecording(boolean b) {
        boolean back = true;
        if (!recording && b) {
            RecordPanel rPanel = RecordPanel.getInstance();
            if (rPanel != null) {
                rPanel.setRecordEnabled(false);
            }
            recordStartTime = System.currentTimeMillis();
            if (Jedas.isAofMode()) {
                Jedas.aofClient.aofRecordTime = Jedas.getAofRecordTime();
            }
            try {
                recorder = new Recorder();
            }
            catch (JedasIOException e) {
                b = false;
                back = false;
                System.err.println("*** " + e.toString());
                e.printStackTrace();
            }
            if (Jedas.getRecorder() != null && Jedas.isAofMode()) {
                Jedas.getRecorder();
                if (Recorder.getFileName().equals("<none>")) {
                    Jedas.getRecorder();
                    Recorder.setFileName(Jedas.getAofFileName());
                }
            }
            recording = true;
            Jedas.getScheduler().syncSpeed();
            recorder.makePasEntry();
            recorder.makeTasEntry();
        } else if (recording && !b) {
            RecordPanel rPanel;
            recording = b;
            if (!recorder.saveAnimation()) {
                b = false;
                back = false;
            }
            if ((rPanel = RecordPanel.getInstance()) != null) {
                rPanel.setRecordEnabled(true);
            }
        }
        return back;
    }

    public static long getRecordTime() {
        if (!manualRecordTimeMode_) {
            return System.currentTimeMillis() - recordStartTime;
        }
        return manualRecordTime_;
    }

    public static void setManualRecordTimeMode(boolean b) {
        manualRecordTimeMode_ = b;
    }

    public static void setManualRecordTime(long recordTime) {
        manualRecordTime_ = recordTime;
    }

    protected static void setScheduler(Scheduler sched) {
        scheduler = sched;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static Recorder getRecorder() {
        return recorder;
    }

    public static void setApplicationMainFrame(Frame mainFrame) {
        Jedas.mainFrame = mainFrame;
    }

    public static Frame getApplicationMainFrame() {
        return mainFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCompPanel(CompPanel compPanel) {
        Hashtable hashtable = compPanelTable;
        synchronized (hashtable) {
            compPanelTable.put(new Long(compPanel.hashCode()), compPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean removeCompPanel(CompPanel compPanel) {
        Object o = null;
        Hashtable hashtable = compPanelTable;
        synchronized (hashtable) {
            o = compPanelTable.remove(new Long(compPanel.hashCode()));
        }
        return o != null;
    }

    public static Enumeration compPanels() {
        return compPanelTable.elements();
    }

    public static void setUpdateDisplay(boolean b) {
        reallyUpdateDisplay = b;
    }

    public static boolean isDisplayUpdated() {
        return reallyUpdateDisplay;
    }

    protected static void checkForAofwb() {
        if (aofClient != null) {
            return;
        }
        try {
            aofClient = new AofClient();
            aofMode = true;
        }
        catch (IOException e) {
            if (IO_DEBUGMODE) {
                System.err.println("*** " + e);
                e.printStackTrace();
            }
            aofClient = null;
            aofMode = false;
        }
    }

    public static boolean isAofMode() {
        return aofMode;
    }

    public static long getAofStartTime() {
        if (!Jedas.isAofMode()) {
            return -1L;
        }
        return Jedas.aofClient.aofRecordTime;
    }

    public static String getAofPlainName() {
        if (!Jedas.isAofMode()) {
            return "<none>";
        }
        return "" + Jedas.aofClient.plainName;
    }

    public static String getAofDocumentPath() {
        if (!Jedas.isAofMode()) {
            return "";
        }
        return "" + Jedas.aofClient.aofDocumentPath;
    }

    private static long getAofRecordTime() {
        if (!Jedas.isAofMode()) {
            return -1L;
        }
        try {
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAofRecordTime() Retrieving record time... ");
            }
            Jedas.aofClient.out.writeByte(48);
            Jedas.aofClient.out.flush();
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAofRecordTime() Waiting for answer...");
            }
            String back = Jedas.aofClient.in.readLine();
            long tmpTime = Long.parseLong(back);
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAofRecordTime() AOFwb record time: " + tmpTime);
            }
            return tmpTime;
        }
        catch (Exception e) {
            if (DEBUGMODE || IO_DEBUGMODE) {
                e.printStackTrace();
            }
            return -1L;
        }
    }

    private static String getAofPath() {
        if (!Jedas.isAofMode()) {
            return null;
        }
        try {
            Jedas.aofClient.out.writeByte(50);
            Jedas.aofClient.out.flush();
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAofPath(): Retrieving path");
            }
            String back = Jedas.aofClient.in.readLine();
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAofPath(): Path: " + back);
            }
            return back;
        }
        catch (Exception e) {
            if (DEBUGMODE || IO_DEBUGMODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void notifyAofOfJedasPlugin() {
        if (!Jedas.isAofMode()) {
            return;
        }
        try {
            Jedas.aofClient.out.writeByte(51);
            Jedas.aofClient.out.flush();
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private static String getAofFileName() {
        if (!Jedas.isAofMode()) {
            return "<none>";
        }
        try {
            String path;
            String back;
            Jedas.aofClient.out.writeByte(49);
            Jedas.aofClient.out.flush();
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAOFFileName(): Retrieving file name");
            }
            Jedas.aofClient.plainName = back = Jedas.aofClient.in.readLine();
            Jedas.aofClient.aofDocumentPath = path = Jedas.getAofPath();
            boolean exists = true;
            int number = 0;
            while (exists) {
                File jeaF = new File(path + back + "_" + number + ".jea");
                exists = jeaF.exists();
                if (!exists) continue;
                ++number;
            }
            if (IO_DEBUGMODE) {
                System.err.println("Jedas::getAOFFileName(): Suggested file name: " + path + back + "_" + number + ".jea");
            }
            return path + back + "_" + number + ".jea";
        }
        catch (Exception e) {
            if (DEBUGMODE || IO_DEBUGMODE) {
                e.printStackTrace();
            }
            return "<none>";
        }
    }

    static {
        DEFAULT_BGCOLOR = new Color(0xD5D5D5);
        manualRecordTimeMode_ = false;
        COMPRESS_OUTPUT = true;
        appletMode = false;
        codebase = null;
        applet = null;
        mainFrame = null;
        compositeList = new Vector();
        recTable = new Hashtable(100);
        compPanelTable = new Hashtable(10);
        recording = false;
        recorder = null;
        normalMode = false;
        playerMode = false;
        reallyUpdateDisplay = true;
        recordStartTime = 0L;
        TRANSITION_DELAY = 3000;
        MAX_ABS_TRANS = 50;
        MAX_TAS_CHANGES = 100;
        MAX_PAS_CHANGES = 100;
        DEBUGMODE = false;
        IO_DEBUGMODE = false;
        scheduler = null;
        aofClient = null;
        aofMode = false;
    }
}

