/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.DPair;
import jedas.DTuple;
import jedas.Jedas;
import jedas.Segment;

public class LineMoveSegment
extends Segment
implements Cloneable {
    static final long serialVersionUID = 8859068302679333345L;
    private DPair st_x;
    private DPair end_x;
    private DPair st_y;
    private DPair end_y;
    private boolean reversed = false;
    private double lambda;
    private double emlam;
    private DTuple tuple;

    public LineMoveSegment(DPair st_x, DPair end_x, DPair st_y, DPair end_y, long time) {
        super(time);
        this.st_x = st_x;
        this.end_x = end_x;
        this.st_y = st_y;
        this.end_y = end_y;
        this.tuple = new DPair(0.0, 0.0);
    }

    public DTuple interpolate() {
        this.lambda = this.reversed ? 1.0 - (double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / (double)this.time : (double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / (double)this.time;
        this.emlam = 1.0 - this.lambda;
        int i = 0;
        while (i < this.st_x.dim) {
            this.tuple.value[i] = this.emlam * this.emlam * this.st_x.value[i] + this.emlam * this.lambda * this.end_x.value[i] + this.emlam * this.lambda * this.st_y.value[i] + this.lambda * this.lambda * this.end_y.value[i];
            ++i;
        }
        return this.tuple;
    }

    public void translate(DTuple diff) {
        if (diff.dim != this.st_x.dim) {
            System.err.println("LineMoveSegment.translate(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < this.st_x.dim) {
            int n = i;
            this.st_x.value[n] = this.st_x.value[n] + diff.value[i];
            int n2 = i;
            this.end_x.value[n2] = this.end_x.value[n2] + diff.value[i];
            int n3 = i;
            this.st_y.value[n3] = this.st_y.value[n3] + diff.value[i];
            int n4 = i;
            this.end_y.value[n4] = this.end_y.value[n4] + diff.value[i];
            ++i;
        }
    }

    public void scale(DTuple fact) {
        if (fact.dim != this.st_x.dim) {
            System.err.println("LineMoveSegment.scale(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < this.st_x.dim) {
            int n = i;
            this.st_x.value[n] = this.st_x.value[n] * fact.value[i];
            int n2 = i;
            this.end_x.value[n2] = this.end_x.value[n2] * fact.value[i];
            int n3 = i;
            this.st_y.value[n3] = this.st_y.value[n3] * fact.value[i];
            int n4 = i;
            this.end_y.value[n4] = this.end_y.value[n4] * fact.value[i];
            ++i;
        }
    }

    protected void reverse() {
        this.reversed = true;
    }

    public DPair getSt_x() {
        return this.st_x;
    }

    public DPair getEnd_x() {
        return this.end_x;
    }

    public DPair getSt_y() {
        return this.st_y;
    }

    public DPair getEnd_y() {
        return this.end_y;
    }
}

