/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import jedas.BBox;
import jedas.CompPanel;
import jedas.Composite;
import jedas.DPair;
import jedas.DTuple;
import jedas.DrawAttr;
import jedas.IntBBox;
import jedas.Item;
import jedas.ItemProperties;
import jedas.Jedas;
import jedas.LibMsgOutput;
import jedas.Properties;
import jedas.RecordObject;
import jedas.io.Attribute;

public abstract class Obj
extends RecordObject
implements Item,
Serializable {
    static final long serialVersionUID = -7566849813734614219L;
    protected transient LibMsgOutput out = new LibMsgOutput(this);
    protected transient LibMsgOutput warn = new LibMsgOutput(this, 0);
    protected transient LibMsgOutput err = new LibMsgOutput(this, 1);
    private static final Color COLOR = Color.black;
    private static final Color HLCOLOR = Color.red;
    private static final boolean HLMODE = false;
    private static final boolean VISIBLE = true;
    private Composite parent;
    private Color color;
    private Color hlcolor;
    private BBox bbox = new BBox();
    protected transient DrawAttr drawAttr = null;
    private boolean bboxVisible = false;
    private transient boolean hasBeenDrawn = false;
    protected boolean visible;
    protected boolean hlmode;

    public Obj(DPair pos, DPair size) {
        this(pos, size, COLOR);
    }

    public Obj(DPair pos, DPair size, Color color) {
        this(pos, size, color, true);
    }

    public Obj(DPair pos, DPair size, Color color, boolean visible) {
        this(pos, size, color, HLCOLOR, false, visible);
    }

    public Obj(DPair pos, DPair size, Color color, Color hlcolor) {
        this(pos, size, color, hlcolor, false, true);
    }

    public Obj(DPair pos, DPair size, Color color, Color hlcolor, boolean hlmode, boolean visible) {
        this.hlmode = hlmode;
        this.visible = visible;
        this.setHighlightColor(hlcolor);
        this.setColorTrans(color);
        this.setPosTrans(pos);
        this.setSizeTrans(size);
    }

    public DrawAttr getDrawAttr() {
        return this.drawAttr;
    }

    public void setParent(Composite parent) {
        if (this.parent != parent) {
            this.markChanged();
        }
        this.parent = parent;
    }

    public Composite getParent() {
        return this.parent;
    }

    /*
     * Unable to fully structure code
     */
    public CompPanel getCompPanel() {
        tmp = this.getParent();
        if (tmp != null) ** GOTO lbl7
        System.err.println("Obj::getCompPanel(): Item  has no parent:");
        System.err.println("    " + tmp);
        return null;
lbl-1000:
        // 1 sources

        {
            tmp = tmp.getParent();
lbl7:
            // 2 sources

            ** while (!(tmp instanceof CompPanel) && tmp != null)
        }
lbl8:
        // 1 sources

        if (tmp == null) {
            System.err.println("Obj::getPanel(): Parent CompPanel not found!");
        }
        return (CompPanel)tmp;
    }

    public void addRealObjects(Vector objList) {
        objList.addElement(this);
    }

    public final void addAllObjects(Vector objList) {
        objList.addElement(this);
    }

    public final void addAllItems(Vector objects) {
        objects.addElement(this);
    }

    public final void addAllChangedItems(Vector objList) {
        if (this.hasChanged()) {
            objList.addElement(this);
        }
    }

    public final void setColor(Color color) {
        this.setColorTrans(color);
        Color newColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        this.addAttributeToQueue(3, new Attribute(newColor));
    }

    public void setColorTrans(Color color) {
        this.color = color;
        this.propertiesChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public final void setPos(DPair pos) {
        this.setPosTrans(pos);
        this.markChanged();
        if (Jedas.isRecording()) {
            if (pos != null) {
                this.addAttributeToQueue(1, new Attribute((DPair)pos.clone()));
            } else {
                this.addAttributeToQueue(1, new Attribute(null));
            }
        }
    }

    public final void setPos(DPair pos, long timeStamp) {
        this.setPosTrans(pos);
        this.markChanged();
        if (pos != null) {
            this.addAttributeToQueue(1, new Attribute(timeStamp, (DPair)pos.clone()));
        } else {
            this.addAttributeToQueue(1, new Attribute(timeStamp, null));
        }
    }

    public void setPosTrans(DPair pos) {
        this.bbox.setPos(pos);
        this.propertiesChanged();
    }

    public final void setPos(double x, double y) {
        this.setPosTrans(new DPair(x, y));
        this.markChanged();
        this.addAttributeToQueue(1, new Attribute(new DPair(x, y)));
    }

    public void setPosTrans(double x, double y) {
        this.bbox.setPos(new DPair(x, y));
        this.propertiesChanged();
    }

    public DPair getPos() {
        return this.bbox.getPos();
    }

    public final void setSize(DPair size) {
        this.setSizeTrans(size);
        if (size != null) {
            this.addAttributeToQueue(2, new Attribute((DPair)size.clone()));
        } else {
            this.addAttributeToQueue(2, new Attribute(null));
        }
        this.markChanged();
    }

    public void setSizeTrans(DPair size) {
        this.bbox.setSize(size);
        this.propertiesChanged();
    }

    public final void setSize(double xs, double ys) {
        this.setSizeTrans(xs, ys);
        this.addAttributeToQueue(2, new Attribute(new DPair(xs, ys)));
        this.markChanged();
    }

    public void setSizeTrans(double xs, double ys) {
        this.bbox.setSize(new DPair(xs, ys));
        this.propertiesChanged();
    }

    public DPair getSize() {
        return this.bbox.getSize();
    }

    public final void setGeometry(DPair[] pairList) {
        this.setGeometryTrans(pairList);
        this.markChanged();
        if (Jedas.isRecording()) {
            DPair[] newPL = new DPair[pairList.length];
            int i = 0;
            while (i < pairList.length) {
                newPL[i] = (DPair)pairList[i].clone();
                ++i;
            }
            this.addAttributeToQueue(4, new Attribute(newPL));
        }
    }

    public void setGeometryTrans(DPair[] pairList) {
        if (pairList.length != 2) {
            this.err.pstr("setGeometry", "Exactly two pairs required");
            return;
        }
        this.setPosTrans(pairList[0]);
        this.setSizeTrans(pairList[1]);
    }

    public DPair[] getGeometry() {
        DPair[] pairList = new DPair[]{this.getPos(), this.getSize()};
        return pairList;
    }

    public void setCustomTrans(int transType, DTuple value) {
    }

    public void scale(DPair factor) {
        DPair curS = this.getSize();
        curS.value[0] = curS.value[0] * factor.value[0];
        curS.value[1] = curS.value[1] * factor.value[1];
        this.setSize(curS);
    }

    public void setHighlightColor(Color color) {
        this.hlcolor = color;
    }

    public Color getHighlightColor() {
        return this.hlcolor;
    }

    public void highlight() {
        this.hlmode = !this.hlmode;
    }

    public void unhighlight() {
        this.hlmode = false;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        this.visible = b;
        this.markChanged();
        this.addAttributeToQueue(0, new Attribute(new Boolean(b)));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int statusChanged(int id) {
        return 0;
    }

    public BBox getBBox() {
        if (this.bbox == null) {
            this.bbox = new BBox(this.getPos(), this.getSize());
        }
        if (this.bbox.getPos() == null || this.bbox.getSize() == null) {
            this.bbox = new BBox(this.getPos(), this.getSize());
        }
        return this.bbox;
    }

    public void showBBox() {
        this.bboxVisible = true;
    }

    public void hideBBox() {
        this.bboxVisible = false;
    }

    public void draw() {
        if (this.bboxVisible) {
            if (this.drawAttr == null) {
                System.err.println("Obj::DrawAttr not found!");
                return;
            }
            if (this.drawAttr.graphics == null) {
                return;
            }
            BBox bbx = this.getBBox();
            int x = this.drawAttr.getPosX(bbx.pos.value[0]);
            int y = this.drawAttr.getPosY(bbx.pos.value[1]);
            int w = this.drawAttr.getWidth(bbx.size.value[0]);
            int h = this.drawAttr.getHeight(bbx.size.value[1]);
            this.drawAttr.graphics.setColor(Color.red);
            this.drawAttr.graphics.drawRect(x, y, w, h);
        }
    }

    public final void superDraw() {
        this.draw();
        this.hasBeenDrawn = true;
    }

    protected boolean recordStatus() {
        return this.hasBeenDrawn;
    }

    public void updateDrawAttr(DrawAttr drawAttr) {
        if (Jedas.DEBUGMODE) {
            System.err.println("Obj::updateDrawAttr()");
        }
        if (drawAttr == null) {
            System.err.println("Obj::drawAttr==null");
        }
        this.drawAttr = drawAttr;
    }

    public IntBBox getIntBBox() {
        return new IntBBox(this);
    }

    public String toString() {
        String tmp = this.getClass().getName();
        try {
            tmp = tmp + "@" + this.getPos() + ", size " + this.getSize();
        }
        catch (NullPointerException e) {
            tmp = tmp + " (not initialised)";
        }
        return tmp;
    }

    public void zoomNotify() {
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().deleteItem(this);
        } else {
            System.err.println("CompObj::removeFromParent() I don't have a parent!");
        }
    }

    public int getItemCount() {
        return 1;
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 0: {
                if (((Boolean)attr.value).booleanValue()) {
                    this.show();
                    break;
                }
                this.hide();
                break;
            }
            case 1: {
                if (attr.value != null) {
                    this.setPos((DPair)attr.value);
                    break;
                }
                this.setPos(null);
                break;
            }
            case 2: {
                if (attr.value == null) break;
                this.setSize((DPair)attr.value);
                break;
            }
            case 4: {
                if (attr.value == null) break;
                this.setGeometry((DPair[])attr.value);
                break;
            }
            case 3: {
                Color c = (Color)attr.value;
                Color newC = new Color(c.getRed(), c.getGreen(), c.getBlue());
                this.setColor(newC);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public Properties getProperties() {
        ItemProperties ip = new ItemProperties();
        return this.getProperties(ip);
    }

    public Properties getProperties(Properties p) {
        Color tmp;
        ItemProperties ip = (ItemProperties)super.getProperties(p);
        if (this.getPos() != null) {
            ip.pos = (DPair)this.getPos().clone();
        }
        if (this.getSize() != null) {
            ip.size = (DPair)this.getSize().clone();
        }
        if ((tmp = this.getColor()) != null) {
            ip.color = new Color(tmp.getRed(), tmp.getGreen(), tmp.getBlue());
        }
        ip.visible = this.isVisible();
        ip.parent = this.getParent();
        return ip;
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        ItemProperties ip = (ItemProperties)p;
        if (ip.pos != null) {
            this.setPos((DPair)ip.pos.clone());
        } else {
            this.setPos(null);
        }
        if (ip.size != null) {
            this.setSize((DPair)ip.size.clone());
        } else {
            this.setSize(null);
        }
        this.setParent(ip.parent);
        if (ip.color != null) {
            this.setColor(new Color(ip.color.getRed(), ip.color.getGreen(), ip.color.getBlue()));
        }
        this.setVisible(ip.visible);
    }

    protected void registerObject() {
    }

    protected void unregisterObject() {
    }

    public void writeXFigObject(PrintWriter xfig) {
        xfig.println("# " + this.getName());
    }
}

