/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Vector;
import jedas.DPair;
import jedas.GraphObj;
import jedas.Jedas;
import jedas.PlineObjProperties;
import jedas.Properties;
import jedas.io.Attribute;
import jedas.utils.Misc;

public class PlineObj
extends GraphObj {
    static final long serialVersionUID = 8950996326466331871L;
    private static final int ARROWRATIO = 15;
    private static final Color COLOR = Color.black;
    private static final Color HLCOLOR = Color.red;
    private static final Color ARROWFILLCOLOR = Color.white;
    public static final int NONE = 0;
    public static final int BEGIN = 1;
    public static final int END = 2;
    public static final int BOTH = 3;
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    public static final int FILLED = 2;
    protected Vector points;
    private int arrowmode;
    private int arrowstyle;
    private Color arrowfillcolor;
    private int arrowratio;
    static final int ATTR_POINTS = 700;
    static final int ATTR_ADD_POINT = 701;
    static final int ATTR_ARROWMODE = 702;
    static final int ATTR_ARROWSTYLE = 703;
    static final int ATTR_ARROWFILLCOLOR = 704;
    static final int ATTR_ARROWRATIO = 705;

    public PlineObj() {
        this(new Vector(), COLOR);
    }

    public PlineObj(Color color) {
        this(new Vector(), color, 0, 0, ARROWFILLCOLOR);
    }

    public PlineObj(Vector points) {
        this(points, COLOR);
    }

    public PlineObj(Vector points, Color color) {
        this(points, color, 0);
    }

    public PlineObj(Vector points, int arrowmode) {
        this(points, COLOR, arrowmode);
    }

    public PlineObj(Vector points, Color color, int arrowmode) {
        this(points, color, arrowmode, 0, ARROWFILLCOLOR);
    }

    public PlineObj(Vector points, int arrowmode, int arrowstyle) {
        this(points, COLOR, arrowmode, arrowstyle, ARROWFILLCOLOR);
    }

    public PlineObj(Vector points, int arrowmode, int arrowstyle, Color arrowfillcolor) {
        this(points, COLOR, arrowmode, arrowstyle, arrowfillcolor);
    }

    public PlineObj(Color color, int arrowmode, int arrowstyle, Color arrowfillcolor) {
        this(new Vector(), color, arrowmode, arrowstyle, arrowfillcolor);
    }

    public PlineObj(Vector points, Color color, int arrowmode, int arrowstyle, Color arrowfillcolor) {
        super(null, null, color, null, HLCOLOR);
        this.setPoints(points);
        this.arrowmode = arrowmode;
        this.arrowstyle = arrowstyle;
        this.arrowfillcolor = arrowfillcolor;
        this.arrowratio = 15;
    }

    public void setPoints(Vector points) {
        if (points == null) {
            return;
        }
        this.points = PlineObj.copyPoints(points);
        this.compute();
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(700, new Attribute(this.copyPoints()));
        }
    }

    public void addPoint(DPair point) {
        if (this.points == null) {
            this.points = new Vector();
        }
        this.points.addElement(point);
        this.compute();
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(701, true, new Attribute((DPair)point.clone()));
        }
    }

    public Vector getPoints() {
        return this.points;
    }

    public Vector copyPoints() {
        Vector<Object> cpPoints = new Vector<Object>();
        int i = 0;
        while (i < this.points.size()) {
            cpPoints.addElement(((DPair)this.points.elementAt(i)).clone());
            ++i;
        }
        return cpPoints;
    }

    static Vector copyPoints(Vector pts) {
        if (pts == null) {
            return null;
        }
        Vector<Object> cpPoints = new Vector<Object>();
        int i = 0;
        while (i < pts.size()) {
            cpPoints.addElement(((DPair)pts.elementAt(i)).clone());
            ++i;
        }
        return cpPoints;
    }

    public void setArrowMode(int mode) {
        this.arrowmode = mode;
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(702, new Attribute(new Integer(mode)));
        }
    }

    public int getArrowMode() {
        return this.arrowmode;
    }

    public void setArrowStyle(int style) {
        this.arrowstyle = style;
        this.markChanged();
        this.addAttributeToQueue(703, new Attribute(new Integer(style)));
    }

    public int getArrowStyle() {
        return this.arrowstyle;
    }

    public void setArrowFillColor(Color color) {
        this.arrowfillcolor = color;
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(704, new Attribute(Misc.cloneColor(color)));
        }
    }

    public Color getArrowFillColor() {
        return this.arrowfillcolor;
    }

    public void setArrowRatio(int ratio) {
        this.arrowratio = ratio;
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(705, new Attribute(new Integer(ratio)));
        }
    }

    public int getArrowLen() {
        return this.getArrowRatio();
    }

    public int getArrowRatio() {
        return this.arrowratio;
    }

    public void setPosTrans(DPair pos) {
        if (pos == null) {
            return;
        }
        double x = pos.value[0];
        double y = pos.value[1];
        DPair oldpos = this.getPos();
        if (oldpos != null) {
            double xoffset = x - oldpos.value[0];
            double yoffset = y - oldpos.value[1];
            int i = 0;
            while (i < this.points.size()) {
                DPair pair = (DPair)this.points.elementAt(i);
                pair.value[0] = pair.value[0] + xoffset;
                pair.value[1] = pair.value[1] + yoffset;
                ++i;
            }
        }
        super.setPosTrans(pos);
    }

    public void setPosTrans(double x, double y) {
        this.setPosTrans(new DPair(x, y));
    }

    public void setSizeTrans(DPair size) {
        if (size == null) {
            return;
        }
        double sx = size.value[0];
        double sy = size.value[1];
        DPair pos = this.getPos();
        DPair oldsize = this.getSize();
        if (oldsize == null || pos == null) {
            super.setSizeTrans(size);
            return;
        }
        int i = 0;
        while (i < this.points.size()) {
            DPair pair = (DPair)this.points.elementAt(i);
            if (oldsize.value[0] != 0.0) {
                pair.value[0] = pos.value[0] + (pair.value[0] - pos.value[0]) * sx / oldsize.value[0];
            }
            if (oldsize.value[1] != 0.0) {
                pair.value[1] = pos.value[1] + (pair.value[1] - pos.value[1]) * sy / oldsize.value[1];
            }
            ++i;
        }
        super.setSizeTrans(size);
    }

    public void setSizeTrans(double sx, double sy) {
        this.setSizeTrans(new DPair(sx, sy));
    }

    public void setGeometryTrans(DPair[] pairList) {
        int len = pairList.length;
        if (pairList.length != this.points.size()) {
            this.warn.pstr("setGeometry", "Wrong number of elements passed.");
            len = len < this.points.size() ? len : this.points.size();
        }
        int i = 0;
        while (i < len) {
            DPair pair = (DPair)this.points.elementAt(i);
            pair.value[0] = pairList[i].value[0];
            pair.value[1] = pairList[i].value[1];
            ++i;
        }
    }

    public DPair[] getGeometry() {
        if (this.points == null) {
            return null;
        }
        Object[] pairList = new DPair[this.points.size()];
        this.points.copyInto(pairList);
        return pairList;
    }

    public DPair getPos() {
        return super.getPos();
    }

    public DPair getSize() {
        return super.getSize();
    }

    private void compute() {
        DPair pair;
        if (this.points == null) {
            return;
        }
        double x = Double.MAX_VALUE;
        double y = Double.MAX_VALUE;
        double width = Double.MIN_VALUE;
        double height = Double.MIN_VALUE;
        int i = 0;
        while (i < this.points.size()) {
            pair = (DPair)this.points.elementAt(i);
            x = x < pair.value[0] ? x : pair.value[0];
            y = y < pair.value[1] ? y : pair.value[1];
            ++i;
        }
        super.setPosTrans(new DPair(x, y));
        int i2 = 0;
        while (i2 < this.points.size()) {
            pair = (DPair)this.points.elementAt(i2);
            width = width > pair.value[0] - x ? width : pair.value[0] - x;
            height = height > pair.value[1] - y ? height : pair.value[1] - y;
            ++i2;
        }
        super.setSizeTrans(new DPair(width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (!this.isVisible() || this.points == null) {
            return;
        }
        this.drawAttr = this.getParent().getDrawAttr();
        if (this.drawAttr == null) {
            System.err.println("PlineObj::draw(): drawAttr undefined!");
            return;
        }
        Graphics gr = this.drawAttr.graphics;
        if (gr == null) {
            System.out.println(this.getName() + "::draw() graphics == null");
            return;
        }
        Vector vector = this.points;
        synchronized (vector) {
            int[] xpoints = new int[this.points.size()];
            int[] ypoints = new int[this.points.size()];
            int i = 0;
            while (i < this.points.size()) {
                DPair pair = (DPair)this.points.elementAt(i);
                xpoints[i] = this.drawAttr.getPosX(pair.value[0]);
                ypoints[i] = this.drawAttr.getPosY(pair.value[1]);
                ++i;
            }
            gr.setColor(this.getColor());
            gr.drawPolyline(xpoints, ypoints, this.points.size());
            if (this.arrowmode != 0) {
                if ((this.arrowmode & 1) != 0) {
                    this.drawArrow(gr, this.drawAttr.getPosX(((DPair)this.points.elementAt((int)1)).value[0]), this.drawAttr.getPosY(((DPair)this.points.elementAt((int)1)).value[1]), this.drawAttr.getPosX(((DPair)this.points.elementAt((int)0)).value[0]), this.drawAttr.getPosY(((DPair)this.points.elementAt((int)0)).value[1]));
                }
                if ((this.arrowmode & 2) != 0) {
                    int size = this.points.size();
                    this.drawArrow(gr, this.drawAttr.getPosX(((DPair)this.points.elementAt((int)(size - 2))).value[0]), this.drawAttr.getPosY(((DPair)this.points.elementAt((int)(size - 2))).value[1]), this.drawAttr.getPosX(((DPair)this.points.elementAt((int)(size - 1))).value[0]), this.drawAttr.getPosY(((DPair)this.points.elementAt((int)(size - 1))).value[1]));
                }
            }
        }
        super.draw();
    }

    private void drawArrow(Graphics gr, int p1x, int p1y, int p2x, int p2y) {
        int[] vx = new int[3];
        int[] vy = new int[3];
        int xD = p2x - p1x;
        int yD = p2y - p1y;
        double len = Math.sqrt(xD * xD + yD * yD);
        if (len > 0.0) {
            int arrowSize = Math.min(Math.max((int)len / this.arrowratio, 5), 10);
            int xs = (int)((double)(xD * arrowSize) / len);
            int ys = (int)((double)(yD * arrowSize) / len);
            vx[0] = p2x;
            vy[0] = p2y;
            vx[1] = p2x + ys - xs;
            vy[1] = p2y - xs - ys;
            vx[2] = p2x - ys - xs;
            vy[2] = p2y + xs - ys;
            switch (this.arrowstyle) {
                case 0: {
                    gr.setColor(this.getColor());
                    gr.drawLine(vx[0], vy[0], vx[1], vy[1]);
                    gr.drawLine(vx[0], vy[0], vx[2], vy[2]);
                    break;
                }
                case 1: {
                    gr.setColor(this.getColor());
                    gr.fillPolygon(vx, vy, 3);
                    break;
                }
                case 2: {
                    gr.setColor(this.arrowfillcolor);
                    gr.fillPolygon(vx, vy, 3);
                    gr.setColor(this.getColor());
                    gr.drawPolygon(vx, vy, 3);
                    break;
                }
                default: {
                    this.err.pstr("drawArrow", "Unknown arrow style passed: " + this.arrowstyle);
                    return;
                }
            }
        }
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (!this.isVisible() || this.points == null) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("PlineObj::draw(): drawAttr undefined!");
            return;
        }
        xfig.println("# " + this.getName());
        xfig.print("2 1 0 1 ");
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        xfig.print("-1 " + Jedas.XFIG_DEPTH-- + " -1 -1 1 0 0 0 ");
        if ((this.getArrowMode() & 2) != 0) {
            xfig.print("1 ");
        } else {
            xfig.print("0 ");
        }
        if ((this.getArrowMode() & 1) != 0) {
            xfig.print("1 ");
        } else {
            xfig.print("0 ");
        }
        xfig.println(this.points.size());
        if ((this.getArrowMode() & 2) != 0) {
            xfig.println("     1 1 1 " + Jedas.XFIG_X_SCALE * 10 + " " + Jedas.XFIG_X_SCALE * 20 + " ");
        }
        if ((this.getArrowMode() & 1) != 0) {
            xfig.println("     1 1 1 " + Jedas.XFIG_X_SCALE * 10 + " " + Jedas.XFIG_X_SCALE * 20 + " ");
        }
        int i = 0;
        while (i < this.points.size()) {
            DPair tmp = (DPair)this.points.elementAt(i);
            int x = this.drawAttr.getPosX(tmp.value[0]) * Jedas.XFIG_X_SCALE;
            int y = this.drawAttr.getPosY(tmp.value[1]) * Jedas.XFIG_Y_SCALE;
            xfig.println(x + " " + y);
            ++i;
        }
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 700: {
                this.setPoints((Vector)attr.value);
                break;
            }
            case 701: {
                this.addPoint((DPair)((DPair)attr.value).clone());
                break;
            }
            case 702: {
                this.setArrowMode((Integer)attr.value);
                break;
            }
            case 703: {
                this.setArrowStyle((Integer)attr.value);
                break;
            }
            case 704: {
                this.setArrowFillColor((Color)attr.value);
                break;
            }
            case 705: {
                this.setArrowRatio((Integer)attr.value);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        PlineObjProperties pop = (PlineObjProperties)p;
        if (pop.pos != null) {
            super.setPos((DPair)pop.pos.clone());
        } else {
            super.setPos(null);
        }
        if (pop.size != null) {
            super.setSize((DPair)pop.size.clone());
        } else {
            super.setSize(null);
        }
        this.setVisible(pop.visible);
        if (pop.color != null) {
            this.setColor(Misc.cloneColor(pop.color));
        }
        if (pop.fillColor != null) {
            this.setFillColor(Misc.cloneColor(pop.fillColor));
        }
        this.setFilled(pop.filled);
        this.setPoints(pop.points);
        this.setArrowMode(pop.arrowmode);
        this.setArrowStyle(pop.arrowstyle);
        this.setArrowFillColor(pop.arrowfillcolor);
        this.setArrowRatio(pop.arrowratio);
        this.setParent(pop.parent);
    }

    public Properties getProperties() {
        PlineObjProperties pop = new PlineObjProperties();
        return this.getProperties(pop);
    }

    public Properties getProperties(Properties p) {
        PlineObjProperties pop = (PlineObjProperties)super.getProperties(p);
        if (this.getPoints() != null) {
            pop.points = this.copyPoints();
        }
        pop.arrowmode = this.arrowmode;
        pop.arrowstyle = this.arrowstyle;
        if (this.arrowfillcolor != null) {
            pop.arrowfillcolor = new Color(this.arrowfillcolor.getRed(), this.arrowfillcolor.getGreen(), this.arrowfillcolor.getBlue());
        }
        pop.arrowratio = this.arrowratio;
        return pop;
    }

    public String toString() {
        String tmp = this.getName();
        int i = 0;
        while (i < this.points.size()) {
            tmp = tmp + (DPair)this.points.elementAt(i);
            ++i;
        }
        return tmp;
    }
}

