/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.Serializable;
import jedas.Item;

public abstract class PriorityQueue
implements Cloneable,
Serializable {
    static final long serialVersionUID = -3232479496134080702L;
    int min = Integer.MAX_VALUE;
    int max = Integer.MIN_VALUE;

    public abstract void insert(Item var1, int var2);

    public void insertFirst(Item item) {
        if (this.getSize() > 0) {
            this.insert(item, this.min - 100);
        } else {
            this.insert(item, 0);
        }
    }

    public void insertLast(Item item) {
        if (this.getSize() > 0) {
            this.insert(item, this.max + 100);
        } else {
            this.insert(item, 0);
        }
    }

    public abstract void delete(Item var1);

    public abstract void decreaseKey(Item var1, int var2);

    public void raise(Item item) {
        this.delete(item);
        this.insertFirst(item);
    }

    public void lower(Item item) {
        this.delete(item);
        this.insertLast(item);
    }

    public abstract Item firstItem();

    public abstract Item nextItem();

    public abstract int getSize();

    public void dumpItems() {
        Item tmp = this.firstItem();
        int i = 0;
        while (tmp != null) {
            System.err.println(i + ": " + tmp.toString());
            ++i;
            tmp = this.nextItem();
        }
    }

    public void setMin(int newMin) {
        this.min = newMin;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int newMax) {
        this.max = newMax;
    }

    public int getMax() {
        return this.max;
    }

    public abstract Object clone();
}

