/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import jedas.DPair;
import jedas.GraphObj;
import jedas.Jedas;
import jedas.Properties;
import jedas.Rect3DObjProperties;
import jedas.utils.Misc;

public class Rect3DObj
extends GraphObj {
    static final long serialVersionUID = -2233351266773257819L;
    private static final Color COLOR = Color.black;
    private static final Color FILLCOLOR = Color.white;
    private static final Color HLCOLOR = Color.red;
    private static final boolean FILLED = false;
    private static final boolean RAISED = true;
    private boolean raised;
    static final int ATTR_RAISED = 800;

    public Rect3DObj() {
        this(COLOR);
    }

    public Rect3DObj(Color color) {
        this(new DPair(0.0, 0.0), new DPair(0.0, 0.0), color, FILLCOLOR, true, false);
    }

    public Rect3DObj(Color color, Color fillColor) {
        this(new DPair(0.0, 0.0), new DPair(0.0, 0.0), color, fillColor, true, true);
    }

    public Rect3DObj(DPair position, DPair size) {
        this(position, size, COLOR, FILLCOLOR, true, false);
    }

    public Rect3DObj(DPair position, DPair size, Color color, Color fillColor, boolean raised, boolean filled) {
        super(position, size, color, fillColor, HLCOLOR);
        this.setFilled(filled);
        this.raised = raised;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.drawAttr == null) {
            System.err.println("Rect3DObject::draw(): drawAttr undefined!");
            return;
        }
        Graphics gr = this.drawAttr.graphics;
        int x = this.drawAttr.getPosX(this.getPos().value[0]);
        int y = this.drawAttr.getPosY(this.getPos().value[1]);
        int w = this.drawAttr.getWidth(this.getSize().value[0]);
        int h = this.drawAttr.getHeight(this.getSize().value[1]);
        gr.setColor(this.getColor());
        if (this.isFilled()) {
            gr.fill3DRect(x, y, w, h, this.raised);
        } else {
            gr.draw3DRect(x, y, w, h, this.raised);
        }
        super.draw();
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (!this.visible) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("RectObj::draw(): drawAttr undefined!");
            return;
        }
        xfig.print("2 2 0 1 ");
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        if (this.isFilled()) {
            xfig.print(Misc.getXFigColor(this.getFillColor()) + " ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print(Jedas.XFIG_DEPTH-- + " -1 ");
        if (this.isFilled()) {
            xfig.print("20 ");
        } else {
            xfig.print("-1 ");
        }
        xfig.println("1.0 0 0 0 0 0 5");
        int x = this.drawAttr.getPosX(this.getPos().value[0]);
        int y = this.drawAttr.getPosY(this.getPos().value[1]);
        int w = this.drawAttr.getWidth(this.getSize().value[0]);
        int h = this.drawAttr.getHeight(this.getSize().value[1]);
        x *= Jedas.XFIG_X_SCALE;
        y *= Jedas.XFIG_Y_SCALE;
        h *= Jedas.XFIG_Y_SCALE;
        if ((w *= Jedas.XFIG_X_SCALE) < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        xfig.println(x + " " + y);
        xfig.println(x + w + " " + y);
        xfig.println(x + w + " " + (y + h));
        xfig.println(x + " " + (y + h));
        xfig.println(x + " " + y);
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        Rect3DObjProperties r3p = (Rect3DObjProperties)p;
        this.raised = r3p.raised;
    }

    public Properties getProperties() {
        Rect3DObjProperties r3p = new Rect3DObjProperties();
        return this.getProperties(r3p);
    }

    public Properties getProperties(Properties p) {
        Rect3DObjProperties r3p = (Rect3DObjProperties)super.getProperties(p);
        r3p.raised = this.raised;
        return r3p;
    }
}

