/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import jedas.DPair;
import jedas.GraphObj;
import jedas.Jedas;
import jedas.utils.Misc;

public class RectObj
extends GraphObj {
    static final long serialVersionUID = -6452765127245198169L;
    private static final double DEFX = 0.1;
    private static final double DEFY = 0.1;
    private static final double DEFWIDTH = 0.1;
    private static final double DEFHEIGHT = 0.1;
    private static final Color COLOR = Color.black;
    private static final Color FILLCOLOR = Color.white;
    private static final Color HLCOLOR = Color.red;
    private static final boolean FILLED = false;

    public RectObj() {
        this(COLOR);
    }

    public RectObj(Color color) {
        this(new DPair(0.1, 0.1), new DPair(0.1, 0.1), color, FILLCOLOR, false);
    }

    public RectObj(Color color, Color fillColor) {
        this(new DPair(0.1, 0.1), new DPair(0.1, 0.1), color, fillColor, true);
    }

    public RectObj(DPair position, DPair size) {
        this(position, size, COLOR, FILLCOLOR, false);
    }

    public RectObj(DPair position, DPair size, Color color, Color fillColor, boolean filled) {
        super(position, size, color, fillColor);
        this.setFilledTrans(filled);
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.drawAttr = this.getParent().getDrawAttr();
        if (this.drawAttr == null) {
            System.err.println("RectObj::draw(): drawAttr undefined!");
            return;
        }
        Graphics gr = this.drawAttr.graphics;
        int x = this.drawAttr.getPosX(this.getPos().value[0]);
        int y = this.drawAttr.getPosY(this.getPos().value[1]);
        int w = this.drawAttr.getWidth(this.getSize().value[0]);
        int h = this.drawAttr.getHeight(this.getSize().value[1]);
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (this.isFilled()) {
            gr.setColor(this.getFillColor());
            gr.fillRect(x, y, w, h);
        }
        gr.setColor(this.getColor());
        gr.drawRect(x, y, w, h);
        super.draw();
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (!this.visible) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("RectObj::draw(): drawAttr undefined!");
            return;
        }
        xfig.print("2 2 0 1 ");
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        if (this.isFilled()) {
            xfig.print(Misc.getXFigColor(this.getFillColor()) + " ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print(Jedas.XFIG_DEPTH-- + " -1 ");
        if (this.isFilled()) {
            xfig.print("20 ");
        } else {
            xfig.print("-1 ");
        }
        xfig.println("1.0 0 0 0 0 0 5");
        int x = this.drawAttr.getPosX(this.getPos().value[0]);
        int y = this.drawAttr.getPosY(this.getPos().value[1]);
        int w = this.drawAttr.getWidth(this.getSize().value[0]);
        int h = this.drawAttr.getHeight(this.getSize().value[1]);
        x *= Jedas.XFIG_X_SCALE;
        y *= Jedas.XFIG_Y_SCALE;
        h *= Jedas.XFIG_Y_SCALE;
        if ((w *= Jedas.XFIG_X_SCALE) < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        xfig.println(x + " " + y);
        xfig.println(x + w + " " + y);
        xfig.println(x + w + " " + (y + h));
        xfig.println(x + " " + (y + h));
        xfig.println(x + " " + y);
    }
}

