/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.Serializable;
import jedas.DTuple;
import jedas.Jedas;

public abstract class Segment
implements Cloneable,
Serializable {
    static final long serialVersionUID = 837628107895631985L;
    protected DTuple tuple;
    protected long time;
    protected long accTime;

    public Segment() {
    }

    public Segment(long time) {
        this();
        this.time = time;
        this.accTime = time;
    }

    public Segment(long time, long accTime) {
        this();
        this.time = time;
        this.accTime = accTime;
    }

    protected Object clone() {
        try {
            Object o = super.clone();
            return o;
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Segment.clone(): " + e);
            return null;
        }
    }

    public abstract DTuple interpolate();

    public final DTuple interpolate(long atTime) {
        long temp = Jedas.drawSync;
        Jedas.drawSync = atTime;
        DTuple rueck = this.interpolate();
        Jedas.drawSync = temp;
        return rueck;
    }

    public final DTuple interpolateFirst() {
        long temp = Jedas.drawSync;
        Jedas.drawSync = this.accTime - this.time;
        DTuple rueck = this.interpolate();
        Jedas.drawSync = temp;
        return rueck;
    }

    public final DTuple interpolateLast() {
        long temp = Jedas.drawSync;
        Jedas.drawSync = this.accTime;
        DTuple rueck = this.interpolate();
        Jedas.drawSync = temp;
        return rueck;
    }

    public abstract void translate(DTuple var1);

    public abstract void scale(DTuple var1);

    protected abstract void reverse();

    public DTuple getTuple() {
        return this.tuple;
    }

    public long getTime() {
        return this.time;
    }

    public long getAccTime() {
        return this.accTime;
    }

    public void setMinTime() {
        this.time = 1L;
        this.accTime = 1L;
    }
}

