/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Vector;
import jedas.BBox;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.Obj;
import jedas.utils.Misc;

public class TextListObj
extends Obj {
    static final long serialVersionUID = -4573412540297170518L;
    public static final double DEF_REL_FONT_SIZE = 0.04;
    public static int TAB_SPACE = 8;
    private String[] sListing = null;
    private boolean bBoxOk = false;
    private boolean fontOk = false;
    private double maxWidth = 0.0;
    private int rasterHeight = 0;
    private DPair topLeftPos = null;
    private double relFontSize = 0.04;
    private Font font = null;
    private Hashtable fontTable = new Hashtable();

    public TextListObj(String fileName) {
        this(TextListObj.slurpFile(fileName));
    }

    public TextListObj(String[] sListing) {
        this(new DPair(0.0, 0.0), sListing);
    }

    public TextListObj(DPair topLeftPos, String fileName) {
        this(topLeftPos, TextListObj.slurpFile(fileName));
    }

    public TextListObj(DPair topLeftPos, String[] sListing) {
        this(topLeftPos, 0.04, sListing);
    }

    public TextListObj(DPair topLeftPos, double relFontSize, String fileName) {
        this(topLeftPos, relFontSize, TextListObj.slurpFile(fileName));
    }

    public TextListObj(DPair topLeftPos, double relFontSize, String[] sListing) {
        super(topLeftPos, new DPair(0.0, 0.04));
        this.topLeftPos = Misc.cloneDPair(topLeftPos);
        this.sListing = sListing;
        this.relFontSize = relFontSize;
    }

    private static String[] slurpFile(String fileName) {
        LineNumberReader in;
        Vector<String> tmp = new Vector<String>();
        try {
            in = new LineNumberReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            String[] tmp2 = new String[]{"<file not found!>"};
            return tmp2;
        }
        try {
            String s = in.readLine();
            while (s != null) {
                tmp.addElement(TextListObj.replaceTabs(s));
                s = in.readLine();
            }
            Object[] tmp2 = new String[tmp.size()];
            tmp.copyInto(tmp2);
            return tmp2;
        }
        catch (IOException e) {
            String[] tmp2 = new String[]{"<ERROR>"};
            return tmp2;
        }
    }

    private static String replaceTabs(String s) {
        int indTab = 0;
        String t = "" + s;
        while ((indTab = t.indexOf(9, indTab)) >= 0) {
            t = t.substring(0, indTab) + TextListObj.whiteSpace(TAB_SPACE) + t.substring(indTab + 1, t.length());
        }
        return t;
    }

    private static String whiteSpace(int number) {
        String s = "";
        int i = 0;
        while (i < number) {
            s = s + " ";
            ++i;
        }
        return s;
    }

    public void setPosTrans(DPair newPos) {
        if (this.topLeftPos != null) {
            this.topLeftPos.set(newPos);
        } else {
            this.topLeftPos = Misc.cloneDPair(newPos);
        }
    }

    public void setSizeTrans(DPair newSize) {
        if (newSize != null) {
            this.relFontSize = newSize.value[1];
        }
    }

    public DPair getPos() {
        return Misc.cloneDPair(this.topLeftPos);
    }

    public DPair getSize() {
        return new DPair(this.maxWidth, this.relFontSize);
    }

    private void calcBBox() {
        if (this.getDrawAttr() == null) {
            return;
        }
        if (this.getDrawAttr().graphics == null) {
            return;
        }
        try {
            int mIndex = -1;
            int mLng = -1;
            int i = 0;
            while (i < this.sListing.length) {
                if (this.sListing[i].length() > mLng) {
                    mIndex = i;
                    mLng = this.sListing[i].length();
                }
                ++i;
            }
            FontMetrics fm = this.getDrawAttr().graphics.getFontMetrics(this.font);
            int iMaxWidth = fm.stringWidth(this.sListing[mIndex]);
            this.maxWidth = this.getDrawAttr().getRelWidth(iMaxWidth);
            this.bBoxOk = true;
        }
        catch (Exception e) {}
    }

    public BBox getBBox() {
        if (!this.bBoxOk) {
            this.calcBBox();
        }
        return new BBox(this.topLeftPos, new DPair(this.maxWidth, this.relFontSize * (double)this.sListing.length));
    }

    public void zoomNotify() {
        this.fontOk = false;
        this.bBoxOk = false;
    }

    private Font getFont(String fontName, int fontStyle, int fontSize) {
        String desc = fontName + "," + fontStyle + "," + fontSize;
        Object o = this.fontTable.get(desc);
        if (o != null) {
            return (Font)o;
        }
        Font f = new Font(fontName, fontStyle, fontSize);
        this.fontTable.put(desc, f);
        return f;
    }

    private void updateFont() {
        if (this.getDrawAttr() == null) {
            return;
        }
        try {
            this.font = this.getFont("Monospaced", 0, this.getDrawAttr().getHeight(this.relFontSize));
            this.fontOk = true;
        }
        catch (NullPointerException e) {
            this.fontOk = false;
        }
    }

    public void updateDrawAttr(DrawAttr drawAttr) {
        Dimension daSize;
        super.updateDrawAttr(drawAttr);
        this.updateFont();
        if (drawAttr != null && (daSize = drawAttr.getDimension()) != null) {
            this.rasterHeight = daSize.height;
        }
    }

    public void draw() {
        if (this.getDrawAttr() == null || this.rasterHeight == 0) {
            return;
        }
        if (!this.fontOk) {
            this.updateFont();
        }
        DrawAttr dA = this.getDrawAttr();
        Graphics gr = dA.graphics;
        if (gr == null || this.sListing == null) {
            return;
        }
        gr.setFont(this.font);
        gr.setColor(this.getColor());
        boolean stopDrawing = false;
        int fMax = dA.getHeight(this.relFontSize) + this.rasterHeight + 20;
        int i = 1;
        while (i <= this.sListing.length && !stopDrawing) {
            int drawX = dA.getPosX(this.topLeftPos.value[0]);
            int drawY = dA.getPosY(this.topLeftPos.value[1] + this.relFontSize * (double)i);
            if (drawY >= 0 && drawY <= this.rasterHeight) {
                gr.drawString(this.sListing[i - 1], drawX, drawY);
            } else if (drawY >= fMax) {
                stopDrawing = true;
            }
            ++i;
        }
        super.draw();
    }

    public String[] getTextList() {
        String[] tmp = new String[this.sListing.length];
        int i = 0;
        while (i < this.sListing.length) {
            tmp[i] = new String(this.sListing[i]);
            ++i;
        }
        return tmp;
    }
}

