/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Hashtable;
import jedas.BBox;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.GraphObj;
import jedas.Jedas;
import jedas.Properties;
import jedas.TextObjProperties;
import jedas.io.Attribute;
import jedas.utils.Misc;

public class TextObj
extends GraphObj {
    static final long serialVersionUID = -6578449293523151019L;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ITALICBOLD = 3;
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final String STDNAME = "SansSerif";
    public static final int STDSTYLE = 0;
    public static final int STDSIZE = 16;
    public static final Color STDCOLOR = Color.black;
    public static final int STDALIGN = 0;
    protected static Hashtable fontTable = new Hashtable();
    private static final int ATTR_TEXT = 500;
    private static final int ATTR_FONTSIZEMODE = 501;
    private static final int ATTR_ABS_FONTSIZE = 502;
    private static final int ATTR_REL_FONTSIZE = 503;
    private boolean fontSizeMode = true;
    private int fontSize = 12;
    private String fontName = "SansSerif";
    private int fontStyle = 0;
    private double relFontSize = 0.05;
    private transient double relFontWidth = 0.0;
    private transient double relFontGap = 0.0;
    private transient Font font;
    private String text = "";
    private DPair nominalPos = new DPair(0.0, 0.0);
    private DPair rueckPos = new DPair();
    private boolean fontUpToDate = false;
    private int align = 0;

    public TextObj() {
        this("");
    }

    public TextObj(String text) {
        this(text, 12, 0);
    }

    public TextObj(String text, DPair pos, int fontSize) {
        this(text, pos, fontSize, 0);
    }

    public TextObj(String text, int fontSize, int align) {
        this(text, new DPair(0.5, 0.5), fontSize, align);
    }

    public TextObj(String text, DPair pos, int fontSize, int align) {
        this(text, pos, fontSize, align, 0, STDCOLOR);
    }

    public TextObj(String text, double height, int align) {
        this(text, new DPair(0.5, 0.5), height, align);
    }

    public TextObj(String text, DPair pos, double height) {
        this(text, pos, height, 0);
    }

    public TextObj(String text, DPair pos, double height, int align) {
        this(text, pos, height, align, 0, STDCOLOR);
    }

    public TextObj(String text, DPair pos, int fontSize, int align, int fontStyle, Color color) {
        this(text, pos, 0.0, fontSize, align, true, STDNAME, fontStyle, color);
    }

    public TextObj(String text, DPair pos, double height, int align, int fontStyle, Color color) {
        this(text, pos, height, 0, align, false, STDNAME, fontStyle, color);
    }

    public TextObj(String text, DPair pos, double height, int fontSize, int align, boolean fontSizeMode, String fontName, int fontStyle, Color color) {
        super(pos, new DPair(0.0, height), color, color);
        this.text = text;
        this.align = align;
        this.relFontSize = height;
        this.fontSize = fontSize;
        this.fontSizeMode = fontSizeMode;
        this.fontName = fontName;
        this.fontStyle = fontStyle;
        this.nominalPos = (DPair)pos.clone();
        this.rueckPos = (DPair)pos.clone();
        super.setSizeTrans(new DPair(0.0, 0.0));
    }

    public void updateDrawAttr(DrawAttr drawAttr) {
        super.updateDrawAttr(drawAttr);
        this.updateFont();
        this.fontUpToDate = false;
    }

    public void setFontSize(int fontSize) {
        this.setFontSizeTrans(fontSize);
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(502, new Attribute(new Integer(fontSize)));
        }
    }

    public void setFontSizeTrans(int fontSize) {
        if (this.fontSize != fontSize) {
            this.propertiesChanged();
            this.fontSize = fontSize;
            this.updateFont();
        }
    }

    public void setFontSize(double fontSize) {
        this.setFontSizeTrans(fontSize);
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(502, new Attribute(new Double(fontSize)));
        }
    }

    public void setFontSizeTrans(double fontSize) {
        if (fontSize != this.relFontSize) {
            this.propertiesChanged();
            this.relFontSize = fontSize;
            this.updateFont();
        }
    }

    public void setFontSizeMode() {
        this.fontSizeMode = true;
        this.fontUpToDate = false;
        this.markChanged();
        this.addAttributeToQueue(501, new Attribute(new Boolean(true)));
    }

    public boolean getFontSizeMode() {
        return this.fontSizeMode;
    }

    public void setRelativeFontSizeMode() {
        this.fontSizeMode = false;
        this.fontUpToDate = false;
        this.markChanged();
        this.addAttributeToQueue(501, new Attribute(new Boolean(false)));
    }

    public void setSizeTrans(double sx, double sy) {
        if (this.fontSizeMode) {
            return;
        }
        this.setFontSizeTrans(sy);
    }

    public void setSizeTrans(DPair size) {
        if (size != null && !this.fontSizeMode) {
            this.setFontSizeTrans(size.value[1]);
        }
    }

    public void setPosTrans(DPair new_pos) {
        if (this.nominalPos == null) {
            this.nominalPos = new DPair(new_pos);
        } else {
            this.nominalPos.set(new_pos);
        }
    }

    public void setPosTrans(double x, double y) {
        this.setPosTrans(new DPair(x, y));
    }

    public void setText(String text) {
        this.text = text;
        this.calcBBox();
        this.addAttributeToQueue(500, new Attribute(text));
        this.markChanged();
    }

    public String getText() {
        return this.text;
    }

    private Font getFont(String fontName, int fontStyle, int fontSize) {
        String desc = fontName + "," + fontStyle + "," + fontSize;
        Object o = fontTable.get(desc);
        if (this.font != (Font)o) {
            this.fontUpToDate = false;
        }
        if (o != null) {
            return (Font)o;
        }
        Font f = new Font(fontName, fontStyle, fontSize);
        fontTable.put(desc, f);
        return f;
    }

    private void updateFont() {
        if (this.drawAttr == null || this.fontName == null) {
            return;
        }
        if (this.fontSizeMode) {
            this.font = this.getFont(this.fontName, this.fontStyle, this.fontSize);
        } else {
            try {
                this.fontSize = this.drawAttr.getHeight(this.relFontSize);
                this.font = this.getFont(this.fontName, this.fontStyle, this.fontSize);
            }
            catch (NullPointerException e) {}
        }
    }

    private void calcBBox() {
        if (this.font == null || this.drawAttr == null) {
            if (this.font == null) {
                System.err.println(this.getName() + "::calcBBox() font == null");
            }
            if (this.drawAttr == null) {
                System.err.println(this.getName() + "::calcBBox() drawAttr == null");
            }
            return;
        }
        if (this.drawAttr.graphics == null) {
            if (this.drawAttr.graphics == null) {
                System.err.println(this.getName() + "::calcBBox() drawAttr.graphics == null");
            }
            return;
        }
        FontMetrics fm = this.drawAttr.graphics.getFontMetrics(this.font);
        int stringWidth = fm.stringWidth(this.text);
        this.relFontWidth = this.drawAttr.getRelWidth(stringWidth);
        this.relFontGap = this.drawAttr.getRelHeight(fm.getDescent());
        if (this.fontSizeMode) {
            this.relFontSize = this.drawAttr.getRelHeight(this.fontSize);
        }
        super.setSizeTrans(new DPair(this.relFontWidth, this.relFontSize));
        this.fontUpToDate = true;
    }

    public void setFillColorTrans(Color color) {
        this.setColorTrans(color);
    }

    public DPair getPos() {
        return Misc.cloneDPair(this.nominalPos);
    }

    public DPair getUpperLeftPos() {
        if (!this.fontUpToDate) {
            this.calcBBox();
        }
        if (this.rueckPos == null) {
            this.rueckPos = new DPair(0.0, 0.0);
        }
        this.rueckPos.value[1] = this.nominalPos.value[1] - this.relFontSize + this.relFontGap;
        switch (this.align) {
            case 1: {
                this.rueckPos.value[0] = this.nominalPos.value[0];
                break;
            }
            case 2: {
                this.rueckPos.value[0] = this.nominalPos.value[0] - this.relFontWidth;
                break;
            }
            default: {
                this.rueckPos.value[0] = this.nominalPos.value[0] - this.relFontWidth / 2.0;
            }
        }
        return this.rueckPos;
    }

    public DPair getSize() {
        if (!this.fontUpToDate) {
            this.calcBBox();
        }
        return super.getSize();
    }

    public BBox getBBox() {
        return new BBox(this.getUpperLeftPos(), this.getSize());
    }

    public void draw() {
        this.drawAttr = this.getParent().getDrawAttr();
        if (this.drawAttr == null || !this.isVisible()) {
            System.out.println(this.getName() + "::drawattr==null || not visible");
            return;
        }
        Graphics gr = this.drawAttr.graphics;
        if (gr == null || this.text == null || this.nominalPos == null || this.font == null) {
            if (gr == null) {
                System.out.println(this.getName() + "::graphics==null");
            }
            if (this.text == null) {
                System.out.println(this.getName() + "::text==null");
            }
            if (this.nominalPos == null) {
                System.out.println(this.getName() + "::nominalPos==null");
            }
            if (this.font == null) {
                System.out.println(this.getName() + "::font==null");
            }
            return;
        }
        if (!this.fontUpToDate) {
            this.calcBBox();
        }
        gr.setFont(this.font);
        gr.setColor(this.getColor());
        switch (this.align) {
            case 1: {
                gr.drawString(this.text, this.drawAttr.getPosX(this.nominalPos.value[0]), this.drawAttr.getPosY(this.nominalPos.value[1]));
                break;
            }
            case 2: {
                gr.drawString(this.text, this.drawAttr.getPosX(this.nominalPos.value[0] - this.relFontWidth), this.drawAttr.getPosY(this.nominalPos.value[1]));
                break;
            }
            default: {
                gr.drawString(this.text, this.drawAttr.getPosX(this.nominalPos.value[0] - this.relFontWidth / 2.0), this.drawAttr.getPosY(this.nominalPos.value[1]));
            }
        }
        super.draw();
    }

    public void zoomNotify() {
        this.updateFont();
        this.fontUpToDate = false;
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 500: {
                this.setText((String)attr.value);
                break;
            }
            case 501: {
                boolean b = (Boolean)attr.value;
                if (b) {
                    this.setFontSizeMode();
                    break;
                }
                this.setRelativeFontSizeMode();
                break;
            }
            case 502: {
                this.setFontSize((Integer)attr.value);
                break;
            }
            case 503: {
                this.setFontSize((Double)attr.value);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        TextObjProperties top = (TextObjProperties)p;
        this.fontName = top.fontName;
        this.align = top.align;
        this.text = top.text;
        this.fontStyle = top.fontStyle;
        this.fontSize = top.fontSize;
        this.relFontSize = top.relFontSize;
        this.fontSizeMode = top.fontSizeMode;
        this.setParent(top.parent);
        this.updateFont();
        if (top.size != null) {
            super.setSizeTrans((DPair)top.size.clone());
        } else {
            super.setSizeTrans(null);
        }
        if (top.pos != null) {
            this.nominalPos = (DPair)top.pos.clone();
        } else {
            System.out.println(this.getName() + "::setProperties() top.pos==null");
            this.nominalPos = null;
        }
        if (top.color != null) {
            this.setColor(new Color(top.color.getRed(), top.color.getGreen(), top.color.getBlue()));
        }
        this.setVisible(top.visible);
    }

    public Properties getProperties() {
        TextObjProperties top = new TextObjProperties();
        return this.getProperties(top);
    }

    public Properties getProperties(Properties p) {
        TextObjProperties top = (TextObjProperties)super.getProperties(p);
        if (this.nominalPos != null) {
            top.pos = (DPair)this.nominalPos.clone();
        } else {
            top.pos = null;
            System.out.println(this.getName() + "::getProperties(): nominalPos==null");
        }
        top.fontSizeMode = this.fontSizeMode;
        top.fontSize = this.fontSize;
        top.fontName = this.fontName;
        top.fontStyle = this.fontStyle;
        top.relFontSize = this.relFontSize;
        top.text = this.text;
        top.align = this.align;
        return top;
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (this.drawAttr == null || !this.isVisible() || this.getText().equals("")) {
            return;
        }
        if (!this.fontUpToDate) {
            this.calcBBox();
        }
        if (this.text == null || this.nominalPos == null) {
            return;
        }
        xfig.println("# " + this.getName());
        xfig.print("4 ");
        switch (this.align) {
            case 1: {
                xfig.print("0 ");
                break;
            }
            case 0: {
                xfig.print("1 ");
                break;
            }
            case 2: {
                xfig.print("2 ");
            }
        }
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        xfig.print(Jedas.XFIG_DEPTH-- + " 0 ");
        xfig.print(this.getXFigFont() + " ");
        if (this.getFontSizeMode()) {
            xfig.print(this.fontSize + " ");
        } else {
            xfig.print(this.drawAttr.getHeight(this.relFontSize) + " ");
        }
        xfig.print("0 0 ");
        DPair tsize = this.getSize();
        int sx = Jedas.XFIG_X_SCALE * this.drawAttr.getWidth(tsize.value[0]);
        int sy = Jedas.XFIG_X_SCALE * this.drawAttr.getHeight(tsize.value[1]);
        xfig.print(sy + " " + sx + " ");
        int x = Jedas.XFIG_X_SCALE * this.drawAttr.getPosX(this.getPos().value[0]);
        int y = Jedas.XFIG_Y_SCALE * this.drawAttr.getPosY(this.getPos().value[1]);
        xfig.print(x + " " + y + " ");
        xfig.println(this.makeXFigString(this.getText()) + "\\001");
    }

    private String makeXFigString(String xfigt) {
        String temp = "";
        int i = 0;
        while (i < xfigt.length()) {
            if (xfigt.charAt(i) > '\u0080') {
                char c = xfigt.charAt(i);
                temp = temp + "\\" + Integer.toOctalString(c);
            } else {
                temp = temp + xfigt.charAt(i);
            }
            ++i;
        }
        return temp;
    }

    private String getXFigFont() {
        if (Jedas.DEBUGMODE) {
            System.err.println(this.getName() + " => " + this.fontName);
        }
        if (this.fontName.equals(STDNAME)) {
            return "4";
        }
        if (this.fontName.equals("MonoSpaced")) {
            return "5";
        }
        return "1";
    }

    public String toString() {
        return this.getName() + " \"" + this.getText() + "\"";
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public double getRelFontSize() {
        return this.relFontSize;
    }

    public int getAlign() {
        return this.align;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }
}

