/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.Timer;

public class TimerQueue
implements Runnable {
    Timer firstTimer;
    boolean running;
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    private static TimerQueue sharedInst = null;
    static /* synthetic */ Class class$jedas$TimerQueue;

    public TimerQueue() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Class clazz = class$jedas$TimerQueue == null ? (class$jedas$TimerQueue = TimerQueue.class$("jedas.TimerQueue")) : class$jedas$TimerQueue;
        synchronized (clazz) {
            if (sharedInst == null) {
                sharedInst = new TimerQueue();
            }
            return sharedInst;
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        Thread timerThread = new Thread((Runnable)this, "JEDAS-TimerQueue");
        try {
            timerThread.setDaemon(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        timerThread.start();
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long expirationTime) {
        if (timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            if (nextTimer.expirationTime > expirationTime) break;
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            previousTimer.nextTimer = timer;
        }
        timer.expirationTime = expirationTime;
        timer.nextTimer = nextTimer;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        boolean found = false;
        while (nextTimer != null) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            previousTimer.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.expirationTime - currentTime;
            if (timeToWait <= 0L) {
                try {
                    timer.post();
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                this.removeTimer(timer);
                if (timer.isRepeats()) {
                    this.addTimer(timer, currentTime + (long)timer.getDelay());
                }
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        while (true) {
            while (true) {
                if (!this.running) {
                    return;
                }
                timeToWait = this.postExpiredTimers();
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            break;
        }
        catch (ThreadDeath td) {
            this.running = false;
            timer = this.firstTimer;
            ** while (timer != null)
        }
lbl-1000:
        // 1 sources

        {
            timer.eventQueued = false;
            timer = timer.nextTimer;
            continue;
        }
lbl20:
        // 1 sources

        throw td;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TimerQueue (");
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            buf.append(nextTimer.toString());
            nextTimer = nextTimer.nextTimer;
            if (nextTimer == null) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

