/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.io.Serializable;
import jedas.DPair;
import jedas.DTuple;
import jedas.GraphItem;
import jedas.Item;
import jedas.Jedas;
import jedas.JedasError;
import jedas.LibMsgOutput;
import jedas.Path;
import jedas.Recordable;
import jedas.Segment;
import jedas.TransEvDispatcher;
import jedas.TransHandler;
import jedas.TransStub;

public class Trans
implements Serializable,
TransStub {
    static final long serialVersionUID = -3387882801697854042L;
    protected transient LibMsgOutput out = new LibMsgOutput(this);
    protected transient LibMsgOutput warn = new LibMsgOutput(this, 0);
    protected transient LibMsgOutput err = new LibMsgOutput(this, 1);
    public static final int MOVE = 2;
    public static final int RESIZE = 4;
    public static final int NOTHING = 5;
    public static final int FILLCOLORCHANGE = 6;
    public static final int GEOMETRY = 7;
    public static final int COLORCHANGE = 8;
    public static final int CUSTOM = 9;
    public static final boolean LOOP = false;
    public static final int LOOPCOUNT = 0;
    public static final int MODIFIER = 2;
    public static final boolean SYNCEVENTDISPATCH = false;
    private Item obj;
    private long objID;
    private Path path = null;
    private Path[] pathList = null;
    private int modifier;
    private int subType = 0;
    private transient int currentFrame;
    private transient int currentLoop;
    private transient TransHandler transHandler = null;
    private boolean loop;
    private boolean syncEventDispatch;
    private int loopCount;
    private Object clientData;
    private long recordingTime = -1L;
    private long recordTimeSync = -1L;
    protected long firstSync = -1L;
    protected transient boolean lastSync;
    private Segment segmentPointer = null;
    private Segment[] segmentPtrList = null;
    private static TransEvDispatcher dispatcher = null;

    public Trans() {
        this(null, (Path)null, 2);
    }

    public Trans(Item obj, Path path, int modifier) {
        this(obj, path, modifier, false);
    }

    public Trans(Item obj, Path path, int modifier, TransHandler transHandler) {
        this(obj, path, modifier, transHandler, null);
    }

    public Trans(Item obj, Path path, int modifier, TransHandler transHandler, boolean syncEventDispatch) {
        this(obj, path, modifier, transHandler, null, syncEventDispatch);
    }

    public Trans(Item obj, Path path, int modifier, boolean loop) {
        this(obj, path, modifier, loop, 0);
    }

    public Trans(Item obj, Path path, int modifier, TransHandler transHandler, Object clientData) {
        this(obj, path, modifier, false, 0, transHandler, clientData);
    }

    public Trans(Item obj, Path path, int modifier, TransHandler transHandler, Object clientData, boolean syncEventDispatch) {
        this(obj, path, modifier, false, 0, transHandler, clientData, syncEventDispatch);
    }

    public Trans(Item obj, Path path, int modifier, boolean loop, int loopCount) {
        this(obj, path, modifier, loop, loopCount, null, null);
    }

    public Trans(Item obj, Path path, int modifier, boolean loop, int loopCount, TransHandler transHandler, Object clientData) {
        this(obj, path, modifier, loop, loopCount, transHandler, clientData, false);
    }

    public Trans(Item obj, Path path, int modifier, int subType) {
        this(obj, path, modifier, subType, false);
    }

    public Trans(Item obj, Path path, int modifier, int subType, boolean loop) {
        this(obj, path, modifier, subType, loop, 0);
    }

    public Trans(Item obj, Path path, int modifier, int subType, boolean loop, int loopCount) {
        this(obj, path, modifier, subType, loop, loopCount, null, null, false);
    }

    public Trans(Item obj, Path path, int modifier, int subType, TransHandler transHandler) {
        this(obj, path, modifier, subType, false, transHandler);
    }

    public Trans(Item obj, Path path, int modifier, int subType, boolean loop, TransHandler transHandler) {
        this(obj, path, modifier, subType, loop, 0, transHandler, null, false);
    }

    public Trans(Item obj, Path path, int modifier, int subType, boolean loop, int loopCount, TransHandler transHandler, Object clientData, boolean syncEventDispatch) {
        this(obj, path, modifier, loop, loopCount, transHandler, clientData, syncEventDispatch);
        this.subType = subType;
        if (modifier != 9) {
            throw new JedasError("Wrong Trans constructor used: Use this only with `CUSTOM' modifier! Please consult documentation!");
        }
    }

    public Trans(Item obj, Path path, int modifier, boolean loop, int loopCount, TransHandler transHandler, Object clientData, boolean syncEventDispatch) {
        if (dispatcher == null) {
            dispatcher = new TransEvDispatcher();
        }
        if (path == null) {
            this.warn.pstr("Trans(..)", "No parameter path passed");
            return;
        }
        if (modifier == 7) {
            this.pathList = new Path[1];
            this.pathList[0] = path;
        }
        this.obj = obj;
        if (obj != null) {
            this.objID = obj.getID();
        }
        this.path = path;
        this.modifier = modifier;
        this.loop = loop;
        this.loopCount = loopCount;
        this.setTransHandler(transHandler);
        this.setClientData(clientData);
        this.syncEventDispatch = syncEventDispatch;
        this.reset();
    }

    public Trans(Item obj, Path[] pathList, int modifier) {
        this(obj, pathList, modifier, false);
    }

    public Trans(Item obj, Path[] pathList, int modifier, TransHandler transHandler) {
        this(obj, pathList, modifier, transHandler, null);
    }

    public Trans(Item obj, Path[] pathList, int modifier, TransHandler transHandler, boolean syncEventDispatch) {
        this(obj, pathList, modifier, transHandler, null, syncEventDispatch);
    }

    public Trans(Item obj, Path[] pathList, int modifier, boolean loop) {
        this(obj, pathList, modifier, loop, 0);
    }

    public Trans(Item obj, Path[] pathList, int modifier, TransHandler transHandler, Object clientData) {
        this(obj, pathList, modifier, false, 0, transHandler, clientData);
    }

    public Trans(Item obj, Path[] pathList, int modifier, TransHandler transHandler, Object clientData, boolean syncEventDispatch) {
        this(obj, pathList, modifier, false, 0, transHandler, clientData, syncEventDispatch);
    }

    public Trans(Item obj, Path[] pathList, int modifier, boolean loop, int loopCount) {
        this(obj, pathList, modifier, loop, loopCount, null, null);
    }

    public Trans(Item obj, Path[] pathList, int modifier, boolean loop, int loopCount, TransHandler transHandler, Object clientData) {
        this(obj, pathList, modifier, loop, loopCount, transHandler, clientData, false);
    }

    public Trans(Item obj, Path[] pathList, int modifier, boolean loop, int loopCount, TransHandler transHandler, Object clientData, boolean syncEventDispatch) {
        if (dispatcher == null) {
            dispatcher = new TransEvDispatcher();
        }
        if (pathList == null) {
            this.warn.pstr("Trans(..)", "No parameter pathList passed.");
            return;
        }
        if (pathList.length < 1) {
            this.warn.pstr("Trans(..)", "pathList has length 0.");
            return;
        }
        long len = pathList[0].getAnimLengthMs();
        int i = 1;
        while (i < pathList.length) {
            if (pathList[i].getAnimLengthMs() != len) {
                this.warn.pstr("Trans(..)", "Pathes have different length.");
                return;
            }
            ++i;
        }
        if (pathList.length > 1) {
            switch (modifier) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    this.warn.pstr("Trans(...)", "Selected mode doesn't support multiple pathes.");
                    this.path = pathList[0];
                }
            }
        }
        this.obj = obj;
        if (obj != null) {
            this.objID = obj.getID();
        }
        this.pathList = pathList;
        this.modifier = modifier;
        this.loop = loop;
        this.loopCount = loopCount;
        this.setTransHandler(transHandler);
        this.setClientData(clientData);
        this.syncEventDispatch = syncEventDispatch;
        this.reset();
    }

    public synchronized void reset() {
        this.currentFrame = 0;
        this.currentLoop = 0;
        this.firstSync = -1L;
        this.lastSync = false;
        this.segmentPointer = null;
        this.segmentPtrList = null;
    }

    private synchronized DTuple getNext() {
        if (this.segmentPointer == null) {
            this.segmentPointer = this.path.getFirstSegment();
        }
        while (this.segmentPointer.accTime < Jedas.drawSync) {
            this.segmentPointer = this.path.getNextSegment();
            if (this.segmentPointer == null) break;
        }
        if (this.segmentPointer == null) {
            if (this.loop) {
                this.segmentPointer = this.path.getFirstSegment();
                ++this.currentLoop;
                this.firstSync += this.path.getAnimLengthMs();
                Jedas.drawSync -= this.path.getAnimLengthMs();
            } else if (!this.lastSync) {
                this.lastSync = true;
                return this.path.getLastSegment().interpolateLast();
            }
            if (this.transHandler != null) {
                this.out.pobj("getNext", "syncEventDispatch", this.syncEventDispatch);
                if (this.syncEventDispatch) {
                    this.dispatchEvent();
                } else {
                    dispatcher.postEvent(this);
                }
            }
        }
        if (this.segmentPointer == null) {
            this.obj.markChanged();
            return null;
        }
        return this.segmentPointer.interpolate();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized DTuple[] getNextList() {
        if (this.segmentPtrList == null) {
            this.segmentPtrList = new Segment[this.pathList.length];
        }
        if (this.segmentPtrList[0] == null) {
            i = 0;
            while (i < this.pathList.length) {
                this.segmentPtrList[i] = this.pathList[i].getFirstSegment();
                ++i;
            }
        }
        i = 0;
        ** GOTO lbl17
        {
            this.segmentPtrList[i] = this.pathList[i].getNextSegment();
            if (this.segmentPtrList[i] == null) ** GOTO lbl15
            do {
                if (this.segmentPtrList[i].accTime < Jedas.drawSync) continue block1;
lbl15:
                // 2 sources

                if (this.segmentPtrList[0] == null) break block1;
                ++i;
lbl17:
                // 2 sources

            } while (i < this.pathList.length);
        }
        if (this.segmentPtrList[0] == null) {
            if (this.loop) {
                i = 0;
                while (i < this.pathList.length) {
                    this.segmentPtrList[i] = this.pathList[i].getFirstSegment();
                    ++i;
                }
                ++this.currentLoop;
                this.firstSync += this.pathList[0].getAnimLengthMs();
                Jedas.drawSync -= this.pathList[0].getAnimLengthMs();
            } else if (!this.lastSync) {
                this.lastSync = true;
                lastTuple = new DTuple[this.pathList.length];
                i = 0;
                while (i < this.pathList.length) {
                    lastTuple[i] = this.pathList[i].getLastSegment().interpolateLast();
                    ++i;
                }
                return lastTuple;
            }
            if (this.transHandler != null) {
                this.out.pobj("getNext", "syncEventDispatch", this.syncEventDispatch);
                if (this.syncEventDispatch) {
                    this.dispatchEvent();
                } else {
                    Trans.dispatcher.postEvent(this);
                }
            }
        }
        if (this.segmentPtrList[0] == null && !this.loop) {
            this.obj.markChanged();
            return null;
        }
        tuplelist = new DTuple[this.pathList.length];
        i = 0;
        while (i < this.pathList.length) {
            tuplelist[i] = this.segmentPtrList[i].interpolate();
            ++i;
        }
        return tuplelist;
    }

    public void dispatchEvent() {
        this.transHandler.transFinished(this, this.currentLoop >= this.loopCount, this.clientData);
    }

    public void setTransHandler(TransHandler transHandler) {
        this.reset();
        this.transHandler = transHandler;
    }

    public void setClientData(Object clientData) {
        this.reset();
        this.clientData = clientData;
    }

    public Item getObj() {
        return this.obj;
    }

    public Recordable getRecordable() {
        return this.obj;
    }

    public int getModifier() {
        return this.modifier;
    }

    public Object getClientData() {
        return this.clientData;
    }

    public boolean process() {
        if (this.obj == null) {
            this.fetchObject();
        }
        if (this.firstSync == -1L) {
            this.recordTimeSync = this.firstSync = Jedas.timeSync;
            if (Jedas.DEBUGMODE) {
                System.out.println("Trans::(" + this.getObj() + ") first sync@" + this.firstSync);
            }
        }
        Jedas.drawSync = Jedas.timeSync - this.firstSync;
        if (this.getModifier() != 5) {
            this.obj.propertiesChanged();
        }
        switch (this.getModifier()) {
            case 2: {
                DTuple tuple = this.getNext();
                if (tuple != null) {
                    this.obj.setPosTrans((DPair)tuple);
                    return true;
                }
                if (Jedas.DEBUGMODE) {
                    System.out.println("Trans::timeSync=" + Jedas.timeSync + ", " + "drawSync=" + Jedas.drawSync + " EOT");
                }
                return false;
            }
            case 4: {
                DTuple tuple = this.getNext();
                if (tuple != null) {
                    this.obj.setSizeTrans((DPair)tuple);
                    return true;
                }
                return false;
            }
            case 5: {
                DTuple tuple = this.getNext();
                return tuple != null;
            }
            case 6: {
                DTuple tuple = this.getNext();
                if (tuple != null) {
                    ((GraphItem)this.obj).setFillColorTrans(new Color((float)tuple.value[0], (float)tuple.value[1], (float)tuple.value[2]));
                    return true;
                }
                return false;
            }
            case 8: {
                DTuple tuple = this.getNext();
                if (tuple != null) {
                    this.obj.setColorTrans(new Color((float)tuple.value[0], (float)tuple.value[1], (float)tuple.value[2]));
                    return true;
                }
                return false;
            }
            case 7: {
                DTuple[] tupleList = this.getNextList();
                if (tupleList != null) {
                    DPair[] pairList = new DPair[tupleList.length];
                    int i = 0;
                    while (i < tupleList.length) {
                        pairList[i] = (DPair)tupleList[i];
                        ++i;
                    }
                    this.obj.setGeometryTrans(pairList);
                    return true;
                }
                return false;
            }
            case 9: {
                DTuple tuple = this.getNext();
                if (tuple != null) {
                    this.obj.setCustomTrans(this.subType, tuple);
                    return true;
                }
                return false;
            }
        }
        this.warn.pstr("process", "Modifier " + this.getModifier() + " not supported.");
        return false;
    }

    private void fetchObject() {
        this.obj = (Item)Jedas.findRecordable(this.objID);
        if (this.obj == null) {
            throw new Error("Trans::fetchObject() Item to animate not found!");
        }
    }

    public void setRecordingTime(long timeSync) {
        this.recordingTime = timeSync;
    }

    public long getRecordingTime() {
        return this.recordingTime;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public long getLengthMs() {
        if (this.isLooping()) {
            System.err.println("Trans::getLengthMs() Can't calculate time for looping transition!");
            return Long.MAX_VALUE;
        }
        if (this.getModifier() == 7) {
            if (this.loopCount > 0) {
                return this.pathList[0].getAnimLengthMs() * (long)this.loopCount;
            }
            return this.pathList[0].getAnimLengthMs();
        }
        if (this.loopCount > 0) {
            return this.path.getAnimLengthMs() * (long)this.loopCount;
        }
        return this.path.getAnimLengthMs();
    }

    public void sync(long lastPrListTime) {
        this.reset();
        this.firstSync = this.recordTimeSync;
        if (this.isLooping()) {
            if (this.getModifier() == 7) {
                long animL = this.pathList[0].getAnimLengthMs();
                int thisLoop = (int)((Jedas.timeSync - this.firstSync) / animL);
                this.firstSync += (long)thisLoop * animL;
            } else {
                long animL = this.path.getAnimLengthMs();
                int thisLoop = (int)((Jedas.timeSync - this.firstSync) / animL);
                this.firstSync += (long)thisLoop * animL;
            }
        }
        this.process();
    }

    public long getFirstSync() {
        return this.firstSync;
    }

    public long getRecordTimeSync() {
        return this.recordTimeSync;
    }

    public final boolean isAbsolute() {
        return false;
    }

    public final boolean isObsolete() {
        return false;
    }

    public Path getPath() {
        return this.path;
    }

    public Path[] getPathList() {
        return this.pathList;
    }

    public int getLoopCount() {
        return this.loopCount;
    }
}

