/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.util.Vector;
import jedas.LibMsgOutput;
import jedas.Trans;

public class TransEvDispatcher
implements Runnable {
    protected LibMsgOutput out = new LibMsgOutput(this);
    protected LibMsgOutput warn = new LibMsgOutput(this, 0);
    protected LibMsgOutput err = new LibMsgOutput(this, 1);
    private static Thread thread = null;
    private static TransEvDispatcher inst = null;
    private Vector transList = new Vector();

    public TransEvDispatcher() {
        inst = this;
        this.startThread();
    }

    private void startThread() {
        thread = new Thread((Runnable)this, "JEDAS-TrEvDispatch");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                TransEvDispatcher transEvDispatcher = this;
                synchronized (transEvDispatcher) {
                    this.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean notEmpty = true;
        while (notEmpty) {
            Trans trans;
            TransEvDispatcher transEvDispatcher = this;
            synchronized (transEvDispatcher) {
                trans = (Trans)this.transList.elementAt(0);
                this.transList.removeElementAt(0);
                notEmpty = !this.transList.isEmpty();
            }
            trans.dispatchEvent();
        }
    }

    public synchronized void clear() {
        while (!this.transList.isEmpty()) {
            this.transList.removeElementAt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postEvent(Trans trans) {
        this.transList.addElement(trans);
        TransEvDispatcher transEvDispatcher = this;
        synchronized (transEvDispatcher) {
            this.notifyAll();
        }
    }

    public static boolean exists() {
        return thread != null;
    }

    public static void resume() {
        if (TransEvDispatcher.exists()) {
            thread.resume();
        }
    }

    public static void suspend() {
        if (TransEvDispatcher.exists()) {
            thread.suspend();
        }
    }

    public static void destroy() {
        if (inst != null) {
            inst.clear();
        }
        if (TransEvDispatcher.exists()) {
            thread.stop();
            thread = null;
            inst.startThread();
            TransEvDispatcher.suspend();
        }
    }
}

