/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.Vector;
import jedas.BBox;
import jedas.CompPanel;
import jedas.Composite;
import jedas.DPair;
import jedas.DTuple;
import jedas.DrawAttr;
import jedas.Item;
import jedas.Path;
import jedas.RecordObject;
import jedas.Trans;

public class ZoomScrollObj
extends RecordObject
implements Item {
    public static final int ZOOM = 1;
    private CompPanel compPanel;

    public ZoomScrollObj(CompPanel compPanel) {
        this.compPanel = compPanel;
    }

    public CompPanel getCompPanel() {
        return this.compPanel;
    }

    public void setPosTrans(DPair pos) {
        this.compPanel.setHotSpotTrans(pos);
    }

    public DPair getPos() {
        return this.compPanel.getHotSpot();
    }

    public void setCustomTrans(int transType, DTuple value) {
        switch (transType) {
            case 1: {
                this.compPanel.setZoomTrans(value.value[0]);
                break;
            }
            default: {
                System.err.println(this.getName() + "::setCustomTrans() unknown trans type: " + transType);
            }
        }
    }

    public Trans createCameraDistance(DPair start, DPair end, long length) {
        Path p = new Path();
        p.createDistance(start, end, length);
        Trans t = new Trans((Item)this, p, 2);
        return t;
    }

    public Trans createCameraMotion(DPair start, DPair end, int motionType, double amplitude, long time) {
        Path p = new Path();
        p.createMotion(start, end, motionType, amplitude, time);
        Trans t = new Trans((Item)this, p, 2);
        return t;
    }

    public Trans createZoom(double startZoom, double endZoom, long time) {
        DTuple d1 = new DTuple(1);
        DTuple d2 = new DTuple(1);
        d1.value[0] = startZoom;
        d2.value[0] = endZoom;
        Path p = new Path();
        p.createDistance(d1, d2, time);
        Trans t = new Trans((Item)this, p, 9, 1);
        return t;
    }

    public Composite getParent() {
        return this.compPanel;
    }

    public DrawAttr getDrawAttr() {
        return this.compPanel.getDrawAttr();
    }

    public void markChanged() {
        super.markChanged();
        this.compPanel.markChanged();
    }

    public void updateDrawAttr(DrawAttr da) {
    }

    public void setParent(Composite parent) {
    }

    public void setPos(DPair pos) {
    }

    public void setPos(double x, double y) {
    }

    public void setPosTrans(double x, double y) {
    }

    public void setSize(DPair size) {
    }

    public void setSize(double sx, double sy) {
    }

    public void setSizeTrans(DPair size) {
    }

    public void setSizeTrans(double sx, double sy) {
    }

    public DPair getSize() {
        return null;
    }

    public BBox getBBox() {
        return null;
    }

    public void setGeometry(DPair[] geom) {
    }

    public void setGeometryTrans(DPair[] geom) {
    }

    public DPair[] getGeometry() {
        return null;
    }

    public void scale(DPair scale) {
    }

    public void setColor(Color color) {
    }

    public void setColorTrans(Color color) {
    }

    public void hide() {
    }

    public void show() {
    }

    public boolean isVisible() {
        return false;
    }

    public void showBBox() {
    }

    public void hideBBox() {
    }

    public void draw() {
    }

    public void superDraw() {
    }

    public void addAllObjects(Vector objs) {
    }

    public void addRealObjects(Vector objs) {
    }

    public void removeFromParent() {
    }

    public void zoomNotify() {
    }

    public void writeXFigObject(PrintWriter out) {
    }

    public int getItemCount() {
        return 1;
    }

    public void addAllItems(Vector objects) {
    }

    public void addAllChangedItems(Vector objects) {
    }
}

