/*
 * Decompiled with CFR 0.152.
 */
package jedas.annotate;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import jedas.BBox;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.Obj;
import jedas.Properties;
import jedas.annotate.AnnotationItem;
import jedas.annotate.AnnotationLineObjProperties;
import jedas.annotate.OwnerLineEvent;
import jedas.io.Attribute;
import jedas.utils.Misc;

public class AnnotationLineObj
extends Obj
implements AnnotationItem {
    static final long serialVersionUID = -5046598317299850114L;
    private static final int SET_END_POINT = 950;
    private static final int SET_OWNER = 951;
    private static final int SET_OWNER_NEW = 953;
    Obj owner = null;
    private DPair start_pos;
    private DPair end_pos;
    private DPair rueck_pos;
    private int[] vx;
    private int[] vy;
    private static final int arrowratio = 15;
    private static final double epsilon = 1.0E-9;
    private boolean arrowMode = false;
    private transient boolean ownerChanged = false;
    private transient Obj newOwner = null;

    public AnnotationLineObj(DPair start, DPair end, Color color, boolean arrowMode) {
        super(start, end, color);
        this.start_pos = (DPair)start.clone();
        this.end_pos = (DPair)end.clone();
        this.rueck_pos = new DPair(0.0, 0.0);
        this.arrowMode = arrowMode;
        this.vx = new int[3];
        this.vy = new int[3];
    }

    public void addRealObjects(Vector objList) {
    }

    public void setOwner(Obj owner) {
        if (this.owner == owner) {
            return;
        }
        this.ownerChanged = true;
        this.newOwner = owner;
    }

    private void performSetOwner() {
        if (this.newOwner != null) {
            if (this.drawAttr == null) {
                this.drawAttr = this.owner == null ? this.getParent().getDrawAttr() : this.owner.getParent().getDrawAttr();
            }
            double sx = this.newOwner.getDrawAttr().getRelPosX(this.drawAttr.getPosX(this.start_pos.value[0]));
            double sy = this.newOwner.getDrawAttr().getRelPosY(this.drawAttr.getPosY(this.start_pos.value[1]));
            double ex = this.newOwner.getDrawAttr().getRelPosX(this.drawAttr.getPosX(this.end_pos.value[0]));
            double ey = this.newOwner.getDrawAttr().getRelPosY(this.drawAttr.getPosY(this.end_pos.value[1]));
            this.start_pos.value[0] = sx - this.newOwner.getPos().value[0];
            this.start_pos.value[1] = sy - this.newOwner.getPos().value[1];
            this.end_pos.value[0] = ex - this.newOwner.getPos().value[0];
            this.end_pos.value[1] = ey - this.newOwner.getPos().value[1];
        }
        this.owner = this.newOwner;
        this.ownerChanged = false;
        this.markChanged();
        this.addAttributeToQueue(953, true, new Attribute(new OwnerLineEvent(this.owner, Misc.cloneDPair(this.start_pos), Misc.cloneDPair(this.end_pos))));
    }

    public void setEndPoint(double x, double y) {
        if (this.owner != null) {
            return;
        }
        this.end_pos.value[0] = x;
        this.end_pos.value[1] = y;
        this.addAttributeToQueue(950, new Attribute(new DPair(x, y)));
        this.markChanged();
    }

    public void setPosTrans(double px, double py) {
        this.setPosTrans(new DPair(px, py));
    }

    public void setPosTrans(DPair n_pos) {
        if (this.owner != null) {
            return;
        }
        if (this.start_pos == null || this.end_pos == null || n_pos == null) {
            return;
        }
        DPair pos = this.getPos();
        double dx = n_pos.value[0] - pos.value[0];
        double dy = n_pos.value[1] - pos.value[1];
        this.start_pos.value[0] = this.start_pos.value[0] + dx;
        this.start_pos.value[1] = this.start_pos.value[1] + dy;
        this.end_pos.value[0] = this.end_pos.value[0] + dx;
        this.end_pos.value[1] = this.end_pos.value[1] + dy;
        this.propertiesChanged();
    }

    public void updateDrawAttr(DrawAttr drawAttr) {
        if (this.owner == null) {
            this.drawAttr = drawAttr;
        }
    }

    public boolean isValid() {
        double size = Math.abs(this.start_pos.value[0] - this.end_pos.value[0]) + Math.abs(this.start_pos.value[1] - this.end_pos.value[1]);
        return size >= 1.0E-9;
    }

    public void draw() {
        if (this.ownerChanged) {
            this.performSetOwner();
        }
        if (this.owner != null) {
            this.drawAttr = this.owner.getDrawAttr();
        } else if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            return;
        }
        if (this.drawAttr.graphics == null) {
            return;
        }
        if (this.owner == null) {
            this.drawArrow(this.drawAttr.graphics, this.drawAttr.getPosX(this.start_pos.value[0]), this.drawAttr.getPosY(this.start_pos.value[1]), this.drawAttr.getPosX(this.end_pos.value[0]), this.drawAttr.getPosY(this.end_pos.value[1]));
        } else {
            this.drawArrow(this.drawAttr.graphics, this.drawAttr.getPosX(this.owner.getPos().value[0] + this.start_pos.value[0]), this.drawAttr.getPosY(this.owner.getPos().value[1] + this.start_pos.value[1]), this.drawAttr.getPosX(this.owner.getPos().value[0] + this.end_pos.value[0]), this.drawAttr.getPosY(this.owner.getPos().value[1] + this.end_pos.value[1]));
        }
        super.draw();
    }

    private void drawArrow(Graphics gr, int p1x, int p1y, int p2x, int p2y) {
        int xD = p2x - p1x;
        int yD = p2y - p1y;
        double len = Math.sqrt(xD * xD + yD * yD);
        if (len > 0.0) {
            gr.setColor(this.getColor());
            gr.drawLine(p1x, p1y, p2x, p2y);
            if (this.arrowMode) {
                int arrowSize = Math.min(Math.max((int)len / 15, 5), 10);
                int xs = (int)((double)(xD * arrowSize) / len);
                int ys = (int)((double)(yD * arrowSize) / len);
                this.vx[0] = p2x;
                this.vy[0] = p2y;
                this.vx[1] = p2x + ys - xs;
                this.vy[1] = p2y - xs - ys;
                this.vx[2] = p2x - ys - xs;
                this.vy[2] = p2y + xs - ys;
                gr.fillPolygon(this.vx, this.vy, 3);
                gr.drawPolygon(this.vx, this.vy, 3);
            }
        }
    }

    public DPair getPos() {
        if (this.owner == null) {
            this.rueck_pos.value[0] = this.start_pos.value[0] < this.end_pos.value[0] ? this.start_pos.value[0] : this.end_pos.value[0];
            this.rueck_pos.value[1] = this.start_pos.value[1] < this.end_pos.value[1] ? this.start_pos.value[1] : this.end_pos.value[1];
        } else {
            this.rueck_pos.value[0] = this.start_pos.value[0] < this.end_pos.value[0] ? this.owner.getPos().value[0] + this.start_pos.value[0] : this.owner.getPos().value[0] + this.end_pos.value[0];
            this.rueck_pos.value[1] = this.start_pos.value[1] < this.end_pos.value[1] ? this.owner.getPos().value[1] + this.start_pos.value[1] : this.owner.getPos().value[1] + this.end_pos.value[1];
        }
        return this.rueck_pos;
    }

    public DPair getSize() {
        this.rueck_pos.value[0] = Math.abs(this.start_pos.value[0] - this.end_pos.value[0]);
        this.rueck_pos.value[1] = Math.abs(this.start_pos.value[1] - this.end_pos.value[1]);
        return this.rueck_pos;
    }

    public BBox getBBox() {
        double t;
        double x1 = this.start_pos.value[0];
        double y1 = this.start_pos.value[1];
        double x2 = this.end_pos.value[0];
        double y2 = this.end_pos.value[1];
        if (x2 < x1) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y2 < y1) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        if (this.owner == null) {
            return new BBox(new DPair(x1, y1), new DPair(x2, y2));
        }
        return new BBox(new DPair(this.owner.getPos().value[0] + x1, this.owner.getPos().value[1] + y1), new DPair(this.owner.getPos().value[0] + x2, this.owner.getPos().value[1] + y2));
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 950: {
                DPair tmp = (DPair)attr.value;
                if (tmp == null) break;
                this.setEndPoint(tmp.value[0], tmp.value[1]);
                break;
            }
            case 951: {
                this.setOwner((Obj)attr.value);
                break;
            }
            case 953: {
                OwnerLineEvent ole = (OwnerLineEvent)attr.value;
                this.owner = ole.owner;
                this.start_pos = Misc.cloneDPair(ole.start_pos);
                this.end_pos = Misc.cloneDPair(ole.end_pos);
                this.drawAttr = null;
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        AnnotationLineObjProperties alop = (AnnotationLineObjProperties)p;
        this.setColorTrans(new Color(alop.color.getRed(), alop.color.getGreen(), alop.color.getBlue()));
        this.start_pos = (DPair)alop.start_pos.clone();
        this.end_pos = (DPair)alop.end_pos.clone();
        this.arrowMode = alop.arrowMode;
        this.owner = alop.annoOwner;
        this.drawAttr = null;
        this.ownerChanged = false;
    }

    public Properties getProperties() {
        return this.getProperties(new AnnotationLineObjProperties());
    }

    public Properties getProperties(Properties p) {
        AnnotationLineObjProperties alop = (AnnotationLineObjProperties)super.getProperties(p);
        alop.start_pos = (DPair)this.start_pos.clone();
        alop.end_pos = (DPair)this.end_pos.clone();
        alop.arrowMode = this.arrowMode;
        alop.annoOwner = this.owner;
        return alop;
    }

    public boolean isDraggable() {
        return !this.arrowMode || this.arrowMode && this.owner == null;
    }

    public boolean isArrowMode() {
        return this.arrowMode;
    }

    public Vector getPoints() {
        Vector<DPair> dump = new Vector<DPair>();
        dump.addElement(this.start_pos);
        dump.addElement(this.end_pos);
        return dump;
    }

    public static Obj getNewOwner(Object CO) {
        return ((OwnerLineEvent)CO).owner;
    }

    public static DPair getStartPos(Object CO) {
        return ((OwnerLineEvent)CO).start_pos;
    }

    public static DPair getEndPos(Object CO) {
        return ((OwnerLineEvent)CO).end_pos;
    }
}

