/*
 * Decompiled with CFR 0.152.
 */
package jedas.annotate;

import java.awt.Color;
import java.util.Vector;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.Jedas;
import jedas.Obj;
import jedas.Properties;
import jedas.RectObj;
import jedas.annotate.AnnotationItem;
import jedas.annotate.AnnotationRectObjProperties;
import jedas.annotate.OwnerEvent;
import jedas.io.Attribute;
import jedas.utils.Misc;

public class AnnotationRectObj
extends RectObj
implements AnnotationItem {
    static final long serialVersionUID = 5270908248325373790L;
    static final int SET_OWNER = 951;
    static final int SET_OWNER_NEW = 952;
    private Obj owner;
    private DPair rel_pos = new DPair(0.0, 0.0);
    private DPair rueck_pos = new DPair(0.0, 0.0);
    private transient boolean ownerChanged = false;
    private transient Obj newOwner = null;

    public AnnotationRectObj(DPair pos, DPair size, Color color) {
        super(pos, size, color, Color.white, false);
    }

    public void setOwner(Obj owner) {
        this.newOwner = owner;
        this.ownerChanged = true;
    }

    private void performSetOwner() {
        if (this.newOwner != null) {
            if (this.drawAttr == null) {
                this.drawAttr = this.owner == null ? this.getParent().getDrawAttr() : this.owner.getParent().getDrawAttr();
            }
            DrawAttr tmp_dA = this.newOwner.getDrawAttr();
            double nx = tmp_dA.getRelPosX(this.drawAttr.getPosX(this.getPos().value[0]));
            double ny = tmp_dA.getRelPosY(this.drawAttr.getPosY(this.getPos().value[1]));
            if (this.rel_pos == null) {
                this.rel_pos = new DPair(0.0, 0.0);
            }
            this.rel_pos.value[0] = this.newOwner.getPos().value[0] - nx;
            this.rel_pos.value[1] = this.newOwner.getPos().value[1] - ny;
            double dAsX = 1.0 / this.drawAttr.getRelWidth(tmp_dA.getWidth(1.0));
            double dAsY = 1.0 / this.drawAttr.getRelHeight(tmp_dA.getHeight(1.0));
            this.scale(new DPair(dAsX, dAsY));
        }
        this.owner = this.newOwner;
        this.ownerChanged = false;
        this.markChanged();
        this.addAttributeToQueue(952, true, new Attribute(new OwnerEvent(this.owner, Misc.cloneDPair(this.rel_pos))));
    }

    public void addRealObjects(Vector objList) {
    }

    public void updateDrawAttr(DrawAttr drawAttr) {
        if (this.owner == null) {
            this.drawAttr = drawAttr;
        }
    }

    public DPair getPos() {
        if (this.owner != null) {
            this.rueck_pos.value[0] = this.owner.getPos().value[0] - this.rel_pos.value[0];
            this.rueck_pos.value[1] = this.owner.getPos().value[1] - this.rel_pos.value[1];
            return this.rueck_pos;
        }
        return super.getPos();
    }

    public void draw() {
        if (this.ownerChanged) {
            this.performSetOwner();
        }
        if (this.owner != null) {
            this.drawAttr = this.owner.getDrawAttr();
        }
        super.draw();
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 951: {
                System.out.println(this.getName() + ": owner set.");
                this.setOwner((Obj)attr.value);
                break;
            }
            case 952: {
                if (Jedas.DEBUGMODE) {
                    System.out.println(this.getName() + ": owner set (NEW!).");
                }
                this.owner = ((OwnerEvent)attr.value).newOwner;
                this.rel_pos = Misc.cloneDPair(((OwnerEvent)attr.value).new_rel_pos);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        AnnotationRectObjProperties arop = (AnnotationRectObjProperties)p;
        this.owner = arop.annoOwner;
        this.ownerChanged = false;
        this.drawAttr = null;
        this.rel_pos = Misc.cloneDPair(arop.rel_pos);
        super.setProperties(p);
    }

    public Properties getProperties() {
        return this.getProperties(new AnnotationRectObjProperties());
    }

    public Properties getProperties(Properties p) {
        AnnotationRectObjProperties arop = (AnnotationRectObjProperties)super.getProperties(p);
        arop.annoOwner = this.owner;
        arop.rel_pos = (DPair)this.rel_pos.clone();
        return arop;
    }

    public boolean isDraggable() {
        return this.owner == null;
    }

    public static Obj getNewOwner(Object CO) {
        return ((OwnerEvent)CO).newOwner;
    }

    public static DPair getRelPos(Object CO) {
        return ((OwnerEvent)CO).new_rel_pos;
    }
}

