/*
 * Decompiled with CFR 0.152.
 */
package jedas.annotate;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import jedas.CompObj;
import jedas.CompPanel;
import jedas.DPair;
import jedas.GraphItem;
import jedas.Jedas;
import jedas.Obj;
import jedas.Scheduler;
import jedas.Trans;
import jedas.TransStub;
import jedas.ZoomScrollObj;
import jedas.annotate.AnnotationItem;
import jedas.annotate.AnnotationLineObj;
import jedas.annotate.AnnotationOvalObj;
import jedas.annotate.AnnotationPanel;
import jedas.annotate.AnnotationPlineObj;
import jedas.annotate.AnnotationPointerObj;
import jedas.annotate.AnnotationRectObj;
import jedas.annotate.AnnotationTargetObj;
import jedas.annotate.AnnotationTextObj;

class Annotator
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final int BASE = 1000;
    private static final int CLEAR = 1001;
    private static final int REMOVE = 1002;
    private static final int UNDO = 1003;
    private static final int LINESTYLE = 1004;
    private static final int FONTSIZE = 1005;
    private static final int FILL = 1006;
    private static final int CURSOR = 1007;
    private static final int COLOR = 1008;
    private static final int TEXT = 1009;
    private static final int TYPE = 1010;
    private static final int NOBJECT = 0;
    private static final int LINE = 1;
    private static final int RECT = 2;
    private static final int PLINE = 3;
    private static final int OVAL = 4;
    private static final int ARROW = 7;
    private static final int ZOOM = 10;
    private static final int HOTSPOT = 11;
    private static final int MAXOBJECTS = 7;
    private Scheduler scheduler;
    private AnnotationPanel annoFrame;
    private CompPanel compPanel;
    private CompObj annoLayer;
    private AnnotationPointerObj pointer;
    private AnnotationTargetObj target;
    private AnnotationRectObj rect;
    private AnnotationLineObj arrow;
    private AnnotationPlineObj pline;
    private AnnotationLineObj line;
    private AnnotationOvalObj oval;
    private AnnotationTextObj text;
    private AnnotationItem dragItem;
    private double dragStartX;
    private double dragStartY;
    private double dragItemX;
    private double dragItemY;
    private boolean dragging = false;
    private boolean rightButtonActive = false;
    private int panStartX;
    private int panStartY;
    private DPair hsPanStart;
    private ZoomScrollObj zoomer = null;
    private boolean inTextMode = false;
    private boolean busy = false;
    private UpdateThread updateThread;

    public Annotator(Scheduler scheduler, AnnotationPanel annoFrame, CompPanel compPanel) {
        this.compPanel = compPanel;
        this.annoFrame = annoFrame;
        this.scheduler = scheduler;
        compPanel.getDrawPanel().addMouseListener(this);
        compPanel.getDrawPanel().addMouseMotionListener(this);
        this.annoLayer = new CompObj();
        this.pointer = new AnnotationPointerObj(new DPair(0.5, 0.5));
        this.pointer.setVisible(false);
        this.annoLayer.addItem(this.pointer, 20);
        compPanel.addItem(this.annoLayer, 20);
        this.updateThread = new UpdateThread();
        this.updateThread.start();
    }

    protected void updatePanel() {
        if (this.scheduler != null) {
            if (!this.scheduler.isRunning()) {
                Jedas.updateDisplay();
            }
        } else {
            Jedas.updateDisplay();
        }
    }

    public void clear() {
        this.annoLayer.clear();
        this.updateThread.requestUpdate();
    }

    private void waitBusy() {
        while (this.busy) {
            try {
                Thread.currentThread();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.busy) {
            this.waitBusy();
        }
        this.busy = true;
        block0 : switch (this.annoFrame.getFunction()) {
            case 1010: {
                double nx = this.annoLayer.getDrawAttr().getRelPosX(e.getX());
                double ny = this.annoLayer.getDrawAttr().getRelPosY(e.getY());
                switch (this.annoFrame.getFunctionType()) {
                    case 1006: {
                        this.fillObjectAt(e.getX(), e.getY());
                        break block0;
                    }
                    case 1009: {
                        if (this.inTextMode) {
                            this.finishTextEdit();
                        }
                        this.text = new AnnotationTextObj(new DPair(nx, ny), this.annoFrame.getCurrentFontSize(), this.annoFrame.getCurrentAlignment(), this.annoFrame.getCurrentFontName(), this.annoFrame.getCurrentColor());
                        this.annoLayer.addItem(this.text, 0);
                        if (Jedas.DEBUGMODE) {
                            System.err.println("Annotator::Added TextObj@" + this.annoFrame.getCurrentFontSize() + "pt, contents=`" + this.text.getText() + "'");
                        }
                        this.compPanel.getDrawPanel().addKeyListener(this);
                        this.compPanel.getDrawPanel().requestFocus();
                        this.inTextMode = true;
                        this.updateThread.requestUpdate();
                        break block0;
                    }
                    case 1002: {
                        this.killObjectAt(e.getX(), e.getY());
                    }
                }
            }
        }
        this.busy = false;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.rightButtonActive = true;
            return;
        }
        if (this.busy) {
            this.waitBusy();
        }
        this.busy = true;
        if (Jedas.DEBUGMODE) {
            System.err.println("Annotator::mousePressed()");
        }
        int mx = e.getX();
        int my = e.getY();
        double nx = this.annoLayer.getDrawAttr().getRelPosX(mx);
        double ny = this.annoLayer.getDrawAttr().getRelPosY(my);
        switch (this.annoFrame.getFunction()) {
            case 1010: {
                switch (this.annoFrame.getFunctionType()) {
                    case 1007: {
                        this.dragItem = this.getDraggableItemAt(mx, my);
                        if (this.dragItem == null) break;
                        this.dragStartX = nx;
                        this.dragStartY = ny;
                        this.dragItemX = this.dragItem.getPos().value[0];
                        this.dragItemY = this.dragItem.getPos().value[1];
                        this.dragging = true;
                        this.compPanel.getDrawPanel().setCursor(Cursor.getPredefinedCursor(13));
                        break;
                    }
                    case 2: {
                        if (Jedas.DEBUGMODE) {
                            System.err.println("Annotator::Adding RectObj at (" + nx + "," + ny + ")");
                        }
                        this.rect = new AnnotationRectObj(new DPair(nx, ny), new DPair(0.0, 0.0), this.annoFrame.getCurrentColor());
                        this.target = new AnnotationTargetObj(new DPair(nx, ny));
                        this.annoLayer.addItem(this.rect, 0);
                        this.annoLayer.addItem(this.target, 0);
                        this.updateThread.requestUpdate();
                        break;
                    }
                    case 7: {
                        if (Jedas.DEBUGMODE) {
                            System.err.println("Annotator::Adding LineObj at (" + nx + "," + ny + ")");
                        }
                        this.arrow = new AnnotationLineObj(new DPair(nx, ny), new DPair(nx, ny), this.annoFrame.getCurrentColor(), true);
                        this.target = new AnnotationTargetObj(new DPair(nx, ny));
                        this.annoLayer.addItem(this.arrow, 0);
                        this.annoLayer.addItem(this.target, 0);
                        this.updateThread.requestUpdate();
                        break;
                    }
                    case 3: {
                        if (Jedas.DEBUGMODE) {
                            System.err.println("Annotator::Adding PlineObj at (" + nx + "," + ny + ")");
                        }
                        this.pline = new AnnotationPlineObj(new DPair(nx, ny), this.annoFrame.getCurrentColor());
                        this.annoLayer.addItem(this.pline, 0);
                        break;
                    }
                    case 1: {
                        if (Jedas.DEBUGMODE) {
                            System.err.println("Annotator::Adding LineObj at (" + nx + "," + ny + ")");
                        }
                        this.line = new AnnotationLineObj(new DPair(nx, ny), new DPair(nx, ny), this.annoFrame.getCurrentColor(), false);
                        this.annoLayer.addItem(this.line, 0);
                        this.updateThread.requestUpdate();
                        break;
                    }
                    case 4: {
                        if (Jedas.DEBUGMODE) {
                            System.err.println("Annotator::Adding OvalObj at (" + nx + "," + ny + ")");
                        }
                        this.oval = new AnnotationOvalObj(new DPair(nx, ny), new DPair(0.0, 0.0), this.annoFrame.getCurrentColor());
                        this.target = new AnnotationTargetObj(new DPair(nx, ny));
                        this.annoLayer.addItem(this.oval, 0);
                        this.annoLayer.addItem(this.target, 0);
                        this.updateThread.requestUpdate();
                        break;
                    }
                    case 10: {
                        this.rect = new AnnotationRectObj(new DPair(nx, ny), new DPair(0.0, 0.0), Color.red);
                        this.annoLayer.addItem(this.rect, 0);
                        this.updateThread.requestUpdate();
                        break;
                    }
                    case 11: {
                        this.panStartX = mx;
                        this.panStartY = my;
                        this.hsPanStart = this.compPanel.getHotSpot();
                    }
                }
                break;
            }
        }
        this.busy = false;
    }

    public void mouseDragged(MouseEvent e) {
        block16: {
            if (this.rightButtonActive) {
                return;
            }
            if (this.busy) {
                return;
            }
            this.busy = true;
            int mx = e.getX();
            int my = e.getY();
            double nx = this.annoLayer.getDrawAttr().getRelPosX(mx);
            double ny = this.annoLayer.getDrawAttr().getRelPosY(my);
            block0 : switch (this.annoFrame.getFunction()) {
                case 1010: {
                    switch (this.annoFrame.getFunctionType()) {
                        case 1007: {
                            if (this.dragging) {
                                double deltaX = nx - this.dragStartX;
                                double deltaY = ny - this.dragStartY;
                                this.dragItem.setPos(new DPair(this.dragItemX + deltaX, this.dragItemY + deltaY));
                                this.pointer.setPos(new DPair(nx, ny));
                                this.updateThread.requestUpdate();
                                break block0;
                            }
                            break block16;
                        }
                        case 2: {
                            double px = this.rect.getPos().value[0];
                            double py = this.rect.getPos().value[1];
                            this.rect.setSize(new DPair(nx - px, ny - py));
                            this.target.setPos(new DPair(px + this.rect.getSize().value[0] / 2.0, py + this.rect.getSize().value[1] / 2.0));
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 7: {
                            this.arrow.setEndPoint(nx, ny);
                            this.target.setPos(new DPair(nx, ny));
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 3: {
                            this.pline.addPoint(new DPair(nx, ny));
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 1: {
                            this.line.setEndPoint(nx, ny);
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 4: {
                            double px = this.oval.getPos().value[0];
                            double py = this.oval.getPos().value[1];
                            this.oval.setSize(new DPair(nx - px, ny - py));
                            this.target.setPos(new DPair(px + this.oval.getSize().value[0] / 2.0, py + this.oval.getSize().value[1] / 2.0));
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 10: {
                            double rx = this.rect.getPos().value[0];
                            double ry = this.rect.getPos().value[1];
                            this.rect.setSize(new DPair(nx - rx, ny - ry));
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 11: {
                            double hsXd = this.compPanel.getDrawAttr().getRelWidth(mx - this.panStartX);
                            double hsYd = this.compPanel.getDrawAttr().getRelHeight(my - this.panStartY);
                            this.compPanel.setHotSpot(new DPair(this.hsPanStart.value[0] - hsXd, this.hsPanStart.value[1] - hsYd));
                            this.updateThread.requestUpdate();
                        }
                    }
                }
            }
        }
        this.busy = false;
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.rightButtonActive) {
            block0 : switch (this.annoFrame.getFunction()) {
                case 1010: {
                    switch (this.annoFrame.getFunctionType()) {
                        case 1007: {
                            this.dragging = false;
                            this.dragItem = null;
                            break block0;
                        }
                        case 2: {
                            this.annoLayer.deleteItem(this.rect);
                            this.rect = null;
                            this.annoLayer.deleteItem(this.target);
                            this.target = null;
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 7: {
                            this.annoLayer.deleteItem(this.arrow);
                            this.arrow = null;
                            this.annoLayer.deleteItem(this.target);
                            this.target = null;
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 3: {
                            this.annoLayer.deleteItem(this.pline);
                            this.pline = null;
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 1: {
                            this.annoLayer.deleteItem(this.line);
                            this.line = null;
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 4: {
                            this.annoLayer.deleteItem(this.oval);
                            this.oval = null;
                            this.annoLayer.deleteItem(this.target);
                            this.target = null;
                            this.updateThread.requestUpdate();
                            break block0;
                        }
                        case 10: {
                            this.annoLayer.deleteItem(this.rect);
                            this.rect = null;
                            this.updateThread.requestUpdate();
                        }
                    }
                }
            }
            return;
        }
        if (e.getButton() == 3) {
            this.rightButtonActive = false;
            return;
        }
        if (this.busy) {
            this.waitBusy();
        }
        this.busy = true;
        if (Jedas.DEBUGMODE) {
            System.err.println("Annotator::mouseReleased()");
        }
        block12 : switch (this.annoFrame.getFunction()) {
            case 1010: {
                switch (this.annoFrame.getFunctionType()) {
                    case 1007: {
                        this.dragging = false;
                        this.dragItem = null;
                        this.compPanel.getDrawPanel().setCursor(Cursor.getDefaultCursor());
                        break block12;
                    }
                    case 2: {
                        if (this.rect.getSize().value[0] != 0.0 || this.rect.getSize().value[1] != 0.0) {
                            this.rect.setOwner(this.findTarget());
                            this.annoFrame.registerAnnotation(this, this.annoLayer, this.rect);
                        } else {
                            this.annoLayer.deleteItem(this.rect);
                        }
                        this.rect = null;
                        this.annoLayer.deleteItem(this.target);
                        this.target = null;
                        this.updateThread.requestUpdate();
                        break block12;
                    }
                    case 7: {
                        if (this.arrow.isValid()) {
                            this.arrow.setOwner(this.findTarget());
                            this.annoFrame.registerAnnotation(this, this.annoLayer, this.arrow);
                        } else {
                            this.annoLayer.deleteItem(this.arrow);
                        }
                        this.arrow = null;
                        this.annoLayer.deleteItem(this.target);
                        this.target = null;
                        this.updateThread.requestUpdate();
                        break block12;
                    }
                    case 3: {
                        if (!this.pline.isValid()) {
                            this.annoLayer.deleteItem(this.pline);
                        } else {
                            this.annoFrame.registerAnnotation(this, this.annoLayer, this.pline);
                        }
                        this.pline = null;
                        break block12;
                    }
                    case 1: {
                        if (this.line.isValid()) {
                            this.annoFrame.registerAnnotation(this, this.annoLayer, this.line);
                        } else {
                            this.annoLayer.deleteItem(this.line);
                        }
                        this.line = null;
                        break block12;
                    }
                    case 4: {
                        if (this.oval.isValid()) {
                            this.oval.setOwner(this.findTarget());
                            this.annoFrame.registerAnnotation(this, this.annoLayer, this.oval);
                        } else {
                            this.annoLayer.deleteItem(this.oval);
                        }
                        this.oval = null;
                        this.annoLayer.deleteItem(this.target);
                        this.target = null;
                        this.updateThread.requestUpdate();
                        break block12;
                    }
                    case 10: {
                        double hsX = this.rect.getPos().value[0] + this.rect.getSize().value[0] / 2.0;
                        double hsY = this.rect.getPos().value[1] + this.rect.getSize().value[1] / 2.0;
                        double zF = 1.0 / Math.max(this.rect.getSize().value[0], this.rect.getSize().value[1]);
                        zF = zF < 0.25 ? 0.25 : (zF > 4.0 ? 4.0 : zF);
                        this.annoLayer.deleteItem(this.rect);
                        this.rect = null;
                        Scheduler s = Jedas.getScheduler();
                        if (s.isRunning()) {
                            if (this.zoomer == null) {
                                this.zoomer = new ZoomScrollObj(this.compPanel);
                            }
                            TransStub[] t = new Trans[]{this.zoomer.createCameraDistance(this.compPanel.getHotSpot(), new DPair(hsX, hsY), AnnotationPanel.ZOOM_TIME), this.zoomer.createZoom(this.compPanel.getZoom(), zF, AnnotationPanel.ZOOM_TIME)};
                            s.add(t);
                        } else {
                            this.compPanel.setZoom(zF);
                            this.compPanel.setHotSpot(new DPair(hsX, hsY));
                        }
                        this.updateThread.requestUpdate();
                        break block12;
                    }
                }
            }
        }
        this.busy = false;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        if (this.annoFrame.getFunction() == 1010 && this.annoFrame.getFunctionType() == 1007) {
            try {
                this.pointer.setPos(new DPair(this.annoLayer.getDrawAttr().getRelPosX(e.getX()), this.annoLayer.getDrawAttr().getRelPosY(e.getY())));
                this.updateThread.requestUpdate();
            }
            catch (NullPointerException ne) {
                // empty catch block
            }
        }
        this.busy = false;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.busy) {
            this.waitBusy();
        }
        this.busy = true;
        if (Jedas.DEBUGMODE) {
            System.err.println("Annotator::mouseEntered()");
        }
        if (this.annoFrame.getFunction() == 1010 && this.annoFrame.getFunctionType() == 1007 && this.pointer != null) {
            this.pointer.setVisible(true);
            this.updateThread.requestUpdate();
        }
        this.busy = false;
    }

    public void mouseExited(MouseEvent e) {
        if (this.busy) {
            this.waitBusy();
        }
        this.busy = true;
        if (Jedas.DEBUGMODE) {
            System.err.println("Annotator::mouseExited()");
        }
        if (this.annoFrame.getFunction() == 1010 && this.annoFrame.getFunctionType() == 1007 && this.pointer != null) {
            this.pointer.setVisible(false);
            this.updateThread.requestUpdate();
        }
        this.busy = false;
    }

    private Obj findTarget() {
        Vector objList = this.compPanel.getAllRealObjects();
        int tx = this.annoLayer.getDrawAttr().getPosX(this.target.getPos().value[0]);
        int ty = this.annoLayer.getDrawAttr().getPosY(this.target.getPos().value[1]);
        Obj tmp = null;
        int i = objList.size() - 1;
        while (i >= 0) {
            if (((Obj)objList.elementAt(i)).getIntBBox().contains(tx, ty)) {
                tmp = (Obj)objList.elementAt(i);
                break;
            }
            --i;
        }
        if (Jedas.DEBUGMODE && tmp != null) {
            System.err.println("Annotator::findTarget(): Found " + tmp.toString());
        }
        return tmp;
    }

    private void fillObjectAt(int x, int y) {
        Vector objList = this.compPanel.getAllObjects();
        GraphItem tmp = null;
        Obj tmp2 = null;
        int i = objList.size() - 1;
        while (i >= 0) {
            tmp2 = (Obj)objList.elementAt(i);
            if (tmp2.getIntBBox().contains(x, y) && tmp2 instanceof GraphItem) {
                tmp = (GraphItem)((Object)tmp2);
                break;
            }
            --i;
        }
        if (tmp != null) {
            if (Jedas.DEBUGMODE) {
                System.err.println("Annotator::fillObjectAt(), found " + tmp.toString());
            }
            tmp.setFillColor(this.annoFrame.getCurrentColor());
            tmp.setFilled(true);
            this.updateThread.requestUpdate();
        }
    }

    private void killObjectAt(int x, int y) {
        Vector objList = this.compPanel.getAllObjects();
        Obj tmp = null;
        int i = objList.size() - 1;
        while (i >= 0) {
            tmp = (Obj)objList.elementAt(i);
            if (tmp.getIntBBox().contains(x, y) && tmp instanceof AnnotationItem) {
                this.annoFrame.deleteAnnotation((AnnotationItem)((Object)tmp));
                break;
            }
            --i;
        }
    }

    private AnnotationItem getDraggableItemAt(int x, int y) {
        Vector objList = this.compPanel.getAllObjects();
        Obj tmp = null;
        int i = objList.size() - 1;
        while (i >= 0) {
            tmp = (Obj)objList.elementAt(i);
            if (tmp.getIntBBox().contains(x, y) && tmp instanceof AnnotationItem && ((AnnotationItem)((Object)tmp)).isDraggable()) {
                return (AnnotationItem)((Object)tmp);
            }
            --i;
        }
        return null;
    }

    private void finishTextEdit() {
        this.text.setText(this.cutLast(this.text.getText(), 1));
        if (!this.text.getText().equals("")) {
            this.annoFrame.registerAnnotation(this, this.annoLayer, this.text);
        } else {
            this.annoLayer.deleteItem(this.text);
        }
        this.text = null;
        this.compPanel.getDrawPanel().removeKeyListener(this);
        this.inTextMode = false;
        this.updateThread.requestUpdate();
    }

    private String cutLast(String cut, int howMany) {
        String tmp = cut;
        tmp = tmp.length() > 1 ? tmp.substring(0, tmp.length() - howMany) : "";
        return tmp;
    }

    protected void toolHasChanged() {
        if (this.inTextMode) {
            this.finishTextEdit();
        }
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        switch (c) {
            case '\uffff': {
                break;
            }
            case '\b': {
                this.text.setText(this.cutLast(this.text.getText(), 2) + "|");
                this.updateThread.requestUpdate();
                break;
            }
            case '\n': 
            case '\r': {
                if (Jedas.DEBUGMODE) {
                    System.err.println("Annotator:keyTyped(): Enter key detected!");
                }
                this.finishTextEdit();
                break;
            }
            default: {
                if (c <= '\u001f') break;
                this.text.setText(this.cutLast(this.text.getText(), 1) + c + "|");
                this.updateThread.requestUpdate();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private class UpdateThread
    extends Thread {
        private boolean newRequest = false;

        private UpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (!this.newRequest) {
                    UpdateThread updateThread = this;
                    synchronized (updateThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                this.newRequest = false;
                Annotator.this.updatePanel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestUpdate() {
            this.newRequest = true;
            UpdateThread updateThread = this;
            synchronized (updateThread) {
                this.notify();
            }
        }
    }
}

