/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.zip.InflaterInputStream;
import jedas.io.JedasAnimation;
import jedas.io.PleaseWaitFrame;
import jedas.io.PrListEntry;
import jedas.io.PrListViewer;
import jedas.io.TrListEntry;
import jedas.io.TransListViewer;
import jedas.utils.UserDialog;

public class AnimationExplorer
extends Frame {
    static final String BT_VIEW = "View";
    static final String BT_QUIT = "Quit";
    static final String BT_TR_STATS = "TransStream stats";
    private JedasAnimation jedasAnim = null;
    private boolean quitOnQuit = false;
    private List lsTrList;
    private List lsPrList;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java jedas.io.AnimationExplorer <jedas anim file>");
            System.exit(0);
        }
        new AnimationExplorer(args[0]);
    }

    public AnimationExplorer(String fileName) {
        super("Animation Explorer v201");
        this.quitOnQuit = true;
        if (!this.readAnimation(fileName)) {
            System.exit(1);
        }
        this.initGUI();
        this.initLists();
        this.setVisible(true);
    }

    public AnimationExplorer(JedasAnimation jedasAnim) {
        super("Animation Explorer v201");
        this.jedasAnim = jedasAnim;
        this.initGUI();
        this.initLists();
        this.setVisible(true);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.lsTrList = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 500);
            }
        };
        this.lsTrList.addItemListener(new TrListChecker());
        this.lsTrList.addActionListener(new TrListDoubleClickChecker());
        this.lsPrList = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 500);
            }
        };
        this.lsPrList.addActionListener(new PrListDoubleClickChecker());
        Panel pnLists = new Panel();
        pnLists.setLayout(new GridLayout(1, 2));
        pnLists.add(this.lsTrList);
        pnLists.add(this.lsPrList);
        Panel pnButtons = new Panel();
        pnButtons.setLayout(new FlowLayout());
        ButtonListener btListener = new ButtonListener();
        Button bt = new Button(BT_VIEW);
        bt.addActionListener(btListener);
        pnButtons.add(bt);
        bt = new Button(BT_QUIT);
        bt.addActionListener(btListener);
        pnButtons.add(bt);
        bt = new Button(BT_TR_STATS);
        bt.addActionListener(btListener);
        pnButtons.add(bt);
        Panel pnLabels = new Panel();
        pnLabels.setLayout(new GridLayout(1, 2));
        pnLabels.add(new Label("TransAccessStream"));
        pnLabels.add(new Label("PropertiesAccessStream"));
        this.add((Component)pnLabels, "North");
        this.add((Component)pnLists, "Center");
        this.add((Component)pnButtons, "South");
        this.pack();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension sSize = tk.getScreenSize();
        int px = (sSize.width - this.getSize().width) / 2;
        int py = (sSize.height - this.getSize().height) / 2;
        if (px < 0 || py < 0) {
            this.setSize(sSize);
        } else {
            this.setLocation(px, py);
        }
        this.addWindowListener(new WindowChecker());
    }

    private void initLists() {
        int i = 0;
        while (i < this.jedasAnim.trList.size()) {
            TrListEntry trE = (TrListEntry)this.jedasAnim.trList.elementAt(i);
            this.lsTrList.add("Entry #" + i + ": t=" + trE.timeStamp + ", " + trE.trans.size() + " transitions");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jedasAnim.prList.size()) {
            PrListEntry prE = (PrListEntry)this.jedasAnim.prList.elementAt(i2);
            this.lsPrList.add("Entry #" + i2 + ": t=" + prE.timeStamp + ", " + prE.properties.length + " Item properties");
            ++i2;
        }
    }

    private void findCorrespondingPrListEntry() {
        if (this.lsTrList.getSelectedIndex() != -1) {
            TrListEntry trE = (TrListEntry)this.jedasAnim.trList.elementAt(this.lsTrList.getSelectedIndex());
            int prIndex = this.jedasAnim.prList.indexOf(trE.prEntry);
            this.lsPrList.select(prIndex);
        }
    }

    private void openTransViewer() {
        if (this.lsTrList.getSelectedIndex() != -1) {
            TrListEntry trE = (TrListEntry)this.jedasAnim.trList.elementAt(this.lsTrList.getSelectedIndex());
            new TransListViewer(this.jedasAnim, trE);
        }
    }

    private void openPrListViewer() {
        if (this.lsPrList.getSelectedIndex() != -1) {
            PrListEntry prE = (PrListEntry)this.jedasAnim.prList.elementAt(this.lsPrList.getSelectedIndex());
            new PrListViewer(prE);
        }
    }

    private void saveTrListStats() {
        FileDialog fd = new FileDialog((Frame)this, "Save TransStream stats", 1);
        fd.show();
        String fName = fd.getFile();
        if (fName == null) {
            return;
        }
        if (fName.equals("")) {
            return;
        }
        fName = fd.getDirectory() + fd.getFile();
        try {
            System.out.println("Opening file for output: " + fName);
            PrintWriter out = new PrintWriter(new FileOutputStream(fName));
            TrListEntry trE = null;
            int i = 0;
            while (i < this.jedasAnim.trList.size()) {
                trE = (TrListEntry)this.jedasAnim.trList.elementAt(i);
                out.println(trE.timeStamp + " " + trE.trans.size());
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error while saving TransStream stats.");
            System.err.println(e.toString());
        }
    }

    private boolean readAnimation(String fileName) {
        boolean back = true;
        PleaseWaitFrame pwf = new PleaseWaitFrame("Reading animation...");
        pwf.repaint();
        try {
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new FileInputStream(fileName)));
            this.jedasAnim = (JedasAnimation)in.readObject();
        }
        catch (Exception e) {
            String[] text = new String[]{"While reading the animation, the following", "java exception was thrown:", "", e.toString()};
            String[] bts = new String[]{"OK"};
            new UserDialog(text, bts, null);
            e.printStackTrace();
            back = false;
        }
        pwf.dispose();
        return back;
    }

    private class PrListDoubleClickChecker
    implements ActionListener {
        private PrListDoubleClickChecker() {
        }

        public void actionPerformed(ActionEvent e) {
            AnimationExplorer.this.openPrListViewer();
        }
    }

    private class TrListDoubleClickChecker
    implements ActionListener {
        private TrListDoubleClickChecker() {
        }

        public void actionPerformed(ActionEvent e) {
            AnimationExplorer.this.openTransViewer();
        }
    }

    private class TrListChecker
    implements ItemListener {
        private TrListChecker() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                AnimationExplorer.this.findCorrespondingPrListEntry();
            }
        }
    }

    private class WindowChecker
    extends WindowAdapter {
        private WindowChecker() {
        }

        public void windowClosing(WindowEvent e) {
            if (!AnimationExplorer.this.quitOnQuit) {
                AnimationExplorer.this.dispose();
            } else {
                System.exit(0);
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(AnimationExplorer.BT_QUIT)) {
                if (!AnimationExplorer.this.quitOnQuit) {
                    AnimationExplorer.this.dispose();
                } else {
                    System.exit(0);
                }
            } else if (cmd.equals(AnimationExplorer.BT_VIEW)) {
                AnimationExplorer.this.openTransViewer();
            } else if (cmd.equals(AnimationExplorer.BT_TR_STATS)) {
                AnimationExplorer.this.saveTrListStats();
            }
        }
    }
}

