/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.Color;
import java.text.DecimalFormat;
import jedas.DTriple;
import jedas.DTuple;
import jedas.io.stringHelper;

public class ColorHelper {
    static String RGBToHexString(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    static String RGBToHexString(DTuple color) {
        String red = Integer.toHexString((int)(color.get(0) * 255.0));
        String green = Integer.toHexString((int)(color.get(1) * 255.0));
        String blue = Integer.toHexString((int)(color.get(2) * 255.0));
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    static String RGB(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return "rgb(" + red + "," + green + "," + blue + ")";
    }

    static String RGB(DTuple color, DecimalFormat df) {
        double red = color.get(0) * 255.0;
        double green = color.get(1) * 255.0;
        double blue = color.get(2) * 255.0;
        return "rgb(" + df.format(red) + "," + df.format(green) + "," + df.format(blue) + ")";
    }

    static DTuple RGB(Color color, boolean nothing) {
        double red = (double)color.getRed() / 255.0;
        double green = (double)color.getGreen() / 255.0;
        double blue = (double)color.getBlue() / 255.0;
        return new DTriple(red, green, blue);
    }

    static Color get_color(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    static Color StringToColor(String str) {
        String[] rgb = null;
        rgb = stringHelper.get_parameters(str, ",");
        return ColorHelper.get_color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
    }

    static DTuple StringToDTuple(String str) {
        String[] rgb = null;
        rgb = stringHelper.get_parameters(str, ",");
        DTuple tmp = new DTuple(3);
        tmp.set(0, Double.parseDouble(rgb[0]) / 255.0);
        tmp.set(1, Double.parseDouble(rgb[1]) / 255.0);
        tmp.set(2, Double.parseDouble(rgb[2]) / 255.0);
        return tmp;
    }
}

