/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import jedas.CompPanel;
import jedas.Jedas;
import jedas.JedasError;
import jedas.Recordable;
import jedas.io.Jedas2Animation;
import jedas.io.PlayerControlFrame;
import jedas.io.PlayerScheduler;
import jedas.io.PleaseWaitFrame;
import jedas.utils.UserDialog;

public class JedasPlayer {
    private Jedas2Animation jedasAnim;
    private PlayerScheduler playerScheduler;
    private static JedasPlayer jedasPlayerInstance;
    private static boolean instanciated;
    public static boolean DEBUGMODE;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java jedas.io.JedasPlayer <jedas anim file>");
            System.exit(0);
        }
        if (args.length > 1 && args[1].equals("debug")) {
            DEBUGMODE = true;
        }
        Jedas.setPlayerMode(true);
        System.out.println("jedas.io.JedasPlayer v201");
        System.out.println();
        System.out.println("This program is part of the JEDAS package.");
        System.out.println("(c) 2000 Rainer Mueller & Martin Danielsson");
        System.out.println();
        System.out.println("http://ad.informatik.uni-freiburg.de/~rmueller/jedas");
        System.out.println("eMail: rmueller@informatik.uni-freiburg.de");
        System.out.println("       martin@danielsson.de");
        new JedasPlayer(args[0]);
    }

    public JedasPlayer(String filename) {
        if (instanciated) {
            throw new Error("JedasPlayer::already instanciated in this session!");
        }
        instanciated = true;
        jedasPlayerInstance = this;
        if (!this.readAnimation(filename)) {
            System.exit(1);
        }
        System.out.println("===================================");
        System.out.println("Jedas version of saving instance: v" + this.jedasAnim.jedasVersion);
        System.out.println("   Length of animation: " + this.jedasAnim.animLength);
        System.out.println("   TAS entries        : " + this.jedasAnim.transitionAccessStream.size());
        System.out.println("   PAS entries        : " + this.jedasAnim.propertyAccessStream.size());
        this.initItems();
        System.out.println();
        System.out.println("Starting application...");
        PlayerControlFrame pcf = new PlayerControlFrame(this.jedasAnim.animLength);
        this.playerScheduler = new PlayerScheduler(this.jedasAnim, pcf.pcp);
        this.playerScheduler.jumpToTime(0L);
        Jedas.updateDisplay();
    }

    public static JedasPlayer getInstance() {
        return jedasPlayerInstance;
    }

    public Jedas2Animation getJedasAnimation() {
        return this.jedasAnim;
    }

    public PlayerScheduler getPlayerScheduler() {
        return this.playerScheduler;
    }

    private void initItems() {
        Enumeration enumeration = this.jedasAnim.recordableTable.elements();
        int upperX = 0;
        int upperY = 90;
        while (enumeration.hasMoreElements()) {
            Recordable tmp = (Recordable)enumeration.nextElement();
            if (!(tmp instanceof CompPanel)) continue;
            System.out.println(" --> " + tmp.getName());
            CompPanel cp = (CompPanel)tmp;
            cp.initOnPlay();
            cp.setPreferredSize(new Dimension(400, 400));
            Frame frT = new Frame(cp.getPanelName());
            frT.setLayout(new BorderLayout());
            frT.add((Component)cp.getDrawPanel(), "Center");
            frT.setVisible(true);
            frT.setLocation(upperX, upperY);
            frT.setSize(new Dimension(400, 400));
            upperY += 100;
            upperX += 100;
            frT.pack();
        }
    }

    public void jumpToTime(long timeStamp) {
        this.playerScheduler.jumpToTime(timeStamp);
    }

    protected void quitNotify() {
        this.playerScheduler.quitNotify();
    }

    boolean readAnimation(String fileName) {
        boolean back = true;
        PleaseWaitFrame pwf = new PleaseWaitFrame("Reading animation...");
        pwf.repaint();
        try {
            Object readObject = null;
            try {
                ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new FileInputStream(fileName)));
                readObject = in.readObject();
            }
            catch (ZipException e) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
                readObject = in.readObject();
            }
            if (!(readObject instanceof Jedas2Animation)) {
                throw new JedasError("This version does not support recorded animations of versions less than 2.00!");
            }
            this.jedasAnim = (Jedas2Animation)readObject;
        }
        catch (Exception e) {
            String[] text = new String[]{"While reading the animation, the following", "java exception was thrown:", "", e.toString()};
            String[] bts = new String[]{"OK"};
            new UserDialog(text, bts, null);
            e.printStackTrace();
            back = false;
        }
        pwf.dispose();
        return back;
    }

    static {
        instanciated = false;
        DEBUGMODE = false;
    }
}

