/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import jedas.DPair;
import jedas.DTuple;
import jedas.GraphObj;
import jedas.Item;
import jedas.Obj;
import jedas.OvalObj;
import jedas.PlineObj;
import jedas.PolygonObj;
import jedas.TextObj;
import jedas.annotate.AnnotationLineObj;
import jedas.annotate.AnnotationOvalObj;
import jedas.annotate.AnnotationPlineObj;
import jedas.annotate.AnnotationPointerObj;
import jedas.annotate.AnnotationRectObj;
import jedas.dom.DomHelper;
import jedas.io.AbsoluteTrans;
import jedas.io.Attribute;
import jedas.io.ColorHelper;
import jedas.io.xmlFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JedasSvg
implements xmlFormat {
    static final int OpenMarkerStart = 100;
    static final int OpenMarkerEnd = 101;
    static final int FillMarkerStart = 102;
    static final int FillMarkerEnd = 103;
    public static final int SETTEXT = 200;
    public static final int RAISE = 201;
    public static final int LOW = 202;
    public static final int OWNER_L_E = 203;
    public static final int OWNER_E = 204;
    final double zero = 1.0E-6;
    private String strokewidth;
    private Document doc;
    private double width_root;
    private double height_root;
    private String transform = "";
    private String transform_obj = "";
    private double x_ = 0.0;
    private double y_ = 0.0;
    private DecimalFormat df;
    private DecimalFormat df2;

    public JedasSvg(Document doc, double width_root, double height_root) {
        this.doc = doc;
        this.width_root = width_root;
        this.height_root = height_root;
        this.df = new DecimalFormat("0.000000");
        this.df2 = new DecimalFormat("0");
    }

    public Element createRootElement(String id) {
        Element newElement = this.doc.createElement("svg");
        newElement.setAttribute("id", id);
        newElement.setAttribute("width", "" + this.width_root);
        newElement.setAttribute("height", "" + this.height_root);
        newElement.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        newElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        newElement.setAttribute("onload", "getSVGDoc(evt)");
        newElement.insertBefore(this.createMarker(100), null);
        newElement.insertBefore(this.createMarker(101), null);
        newElement.insertBefore(this.createMarker(102), null);
        newElement.insertBefore(this.createMarker(103), null);
        newElement.insertBefore(this.createJavaScript("text/javascript"), null);
        this.doc.insertBefore(newElement, null);
        return newElement;
    }

    public Element createGroup(String style, String id, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("g");
        newElement.setAttribute("id", id);
        newElement.setAttribute("transform", this.transform);
        newElement.setAttribute("style", style);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createRect(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, long at, Element anim_visibility, Element latestElement) {
        if (filled.equals("false")) {
            fillcolor = "none";
        }
        Element newElement = this.doc.createElement("rect");
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("transform", this.transform);
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("fill", fillcolor);
        newElement.setAttribute("stroke", strokecolor);
        newElement.setAttribute("stroke-width", this.strokewidth);
        newElement.setAttribute("width", "" + this.width_root);
        newElement.setAttribute("height", "" + this.height_root);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createOval(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, long at, Element anim_visibility, Element latestElement) {
        if (filled.equals("false")) {
            fillcolor = "none";
        }
        Element newElement = this.doc.createElement("ellipse");
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("transform", this.transform);
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("fill", fillcolor);
        newElement.setAttribute("stroke", strokecolor);
        newElement.setAttribute("stroke-width", this.strokewidth);
        newElement.setAttribute("rx", "" + this.width_root / 2.0);
        newElement.setAttribute("ry", "" + this.height_root / 2.0);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createArc(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, DPair angles, long at, Element anim_visibility, Element latestElement) {
        return null;
    }

    public Element createText(String obj_id, String vml_style_mutual, String textString, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("text");
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("transform", this.transform);
        newElement.setAttribute("style", vml_style_mutual);
        newElement.insertBefore(this.doc.createTextNode(textString), null);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createPlineObj(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, Item item, long at, Element anim_visibility, Element latestElement) {
        DTuple my_dtuple;
        Enumeration e;
        Vector my_vector = ((PlineObj)item).getPoints();
        String points = "";
        StringBuffer tmp_buffer = new StringBuffer();
        tmp_buffer.append("M");
        String arrowStyle = this.getArrowStyle(item);
        double pos_X = item.getPos().get(0);
        double pos_Y = item.getPos().get(1);
        double current_x_size = item.getSize().get(0);
        double current_y_size = item.getSize().get(1);
        if (current_x_size == Double.MIN_VALUE) {
            current_x_size = 1.0;
        }
        if (current_y_size == Double.MIN_VALUE) {
            current_y_size = 1.0;
        }
        if (current_x_size == 0.0) {
            current_x_size = 1.0E-6;
        }
        if (current_y_size == 0.0) {
            current_y_size = 1.0E-6;
        }
        double tmp_A = this.width_root / current_x_size;
        double tmp_B = this.height_root / current_y_size;
        if (item instanceof AnnotationPlineObj || item instanceof AnnotationLineObj) {
            tmp_A = this.width_root;
            tmp_B = this.height_root;
            pos_Y = 0.0;
            pos_X = 0.0;
        }
        if ((e = my_vector.elements()).hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(this.df.format((my_dtuple.get(0) - pos_X) * tmp_A)).append(" ").append(this.df.format((my_dtuple.get(1) - pos_Y) * tmp_B));
        }
        while (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(" L");
            tmp_buffer.append(this.df.format((my_dtuple.get(0) - pos_X) * tmp_A)).append(" ").append(this.df.format((my_dtuple.get(1) - pos_Y) * tmp_B));
        }
        if (item instanceof PolygonObj) {
            tmp_buffer.append(" Z");
        }
        points = tmp_buffer.toString();
        if (filled.equals("false")) {
            fillcolor = "none";
        }
        Element newElement = this.doc.createElement("path");
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("transform", this.transform);
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("fill", fillcolor);
        newElement.setAttribute("stroke", strokecolor);
        newElement.setAttribute("stroke-width", this.strokewidth);
        newElement.setAttribute("d", points);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        newElement = this.createMarkerAttr(item, newElement, arrowStyle);
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createAnnotationLineObj(String obj_id, String strokecolor, boolean arrowmode, String vml_style_mutual, DPair[] objgeometrie, long at, Element anim_visibility, Element latestElement, Item tmp) {
        String points = "M ";
        int k = 0;
        while (k < objgeometrie.length) {
            points = points + "" + objgeometrie[k].get(0) * this.width_root + " " + objgeometrie[k].get(1) * this.height_root;
            if (k < objgeometrie.length - 1) {
                points = points + " L";
            }
            ++k;
        }
        Element newElement = this.doc.createElement("path");
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("transform", this.transform);
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("stroke", strokecolor);
        newElement.setAttribute("stroke-width", this.strokewidth);
        newElement.setAttribute("d", points);
        if (arrowmode) {
            newElement.setAttribute("marker-end", "url(#FillMarkerEnd)");
        }
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createAnnotationPointerObj(String obj_id, String vml_style_mutual, DPair[] objgeometrie, long at, Element anim_visibility, Element latestElement, Item tmp) {
        return null;
    }

    public Element creatAnimationMotion(Vector my_Attlist, Item animatable_object, long begin, long duration, String repeatCount) {
        DTuple my_dtuple;
        String values = "";
        StringBuffer tmp_buffer = new StringBuffer();
        String additive = "sum";
        double current_x_pos = animatable_object.getPos().get(0);
        double current_y_pos = animatable_object.getPos().get(1);
        double current_x_size = animatable_object.getSize().get(0);
        double current_y_size = animatable_object.getSize().get(1);
        if (current_x_size == Double.MIN_VALUE) {
            current_x_size = 1.0;
        }
        if (current_y_size == Double.MIN_VALUE) {
            current_y_size = 1.0;
        }
        if (current_x_size == 0.0) {
            current_x_size = 1.0E-6;
        }
        if (current_y_size == 0.0) {
            current_y_size = 1.0E-6;
        }
        if (animatable_object instanceof TextObj) {
            current_x_size = current_y_size;
        }
        if (animatable_object instanceof AnnotationPlineObj || animatable_object instanceof AnnotationLineObj) {
            current_y_size = 1.0;
            current_x_size = 1.0;
            current_y_pos = 0.0;
            current_x_pos = 0.0;
            additive = "replace";
        }
        double tmp_A = this.width_root / current_x_size;
        double tmp_B = this.height_root / current_y_size;
        Enumeration e = my_Attlist.elements();
        if (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(this.df2.format((my_dtuple.get(0) - current_x_pos) * tmp_A)).append(",").append(this.df2.format((my_dtuple.get(1) - current_y_pos) * tmp_B));
        }
        while (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(" ; ");
            tmp_buffer.append(this.df2.format((my_dtuple.get(0) - current_x_pos) * tmp_A)).append(",").append(this.df2.format((my_dtuple.get(1) - current_y_pos) * tmp_B));
        }
        values = tmp_buffer.toString();
        Element newElement = this.doc.createElement("animateTransform");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", "transform");
        newElement.setAttribute("type", "translate");
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("begin", begin + "ms");
        newElement.setAttribute("dur", duration + "ms");
        newElement.setAttribute("additive", additive);
        newElement.setAttribute("values", values);
        return newElement;
    }

    public Element createAnimationResize() {
        Element newElement = this.doc.createElement("animateTransform");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", "transform");
        newElement.setAttribute("type", "scale");
        newElement.setAttribute("additive", "sum");
        return newElement;
    }

    public Element fulfilAnimationResize(Vector my_Attlist, Element latestElement, Element newElement, String id, Item animatable_object, long begin, long duration, DPair current, String repeatCount) {
        Enumeration e;
        StringBuffer tmp_buffer = new StringBuffer();
        String values = "";
        double tmpx = 0.0;
        double tmpy = 0.0;
        double current_x_size = current.get(0);
        double current_y_size = current.get(1);
        if (current_x_size == Double.MIN_VALUE) {
            current_x_size = 1.0;
        }
        if (current_y_size == Double.MIN_VALUE) {
            current_y_size = 1.0;
        }
        if (current_x_size == 0.0) {
            current_x_size = 1.0E-6;
        }
        if (current_y_size == 0.0) {
            current_y_size = 1.0E-6;
        }
        if (animatable_object instanceof TextObj) {
            DTuple my_dtuple;
            e = my_Attlist.elements();
            if (e.hasMoreElements()) {
                my_dtuple = (DTuple)e.nextElement();
                tmpy = my_dtuple.get(1);
                if (tmpy == 0.0) {
                    tmpy = 1.0E-6;
                }
                tmp_buffer.append(this.df.format(tmpy / current_y_size));
            }
            while (e.hasMoreElements()) {
                my_dtuple = (DTuple)e.nextElement();
                tmpy = my_dtuple.get(1);
                if (tmpy == 0.0) {
                    tmpy = 1.0E-6;
                }
                tmp_buffer.append(" ; ");
                tmp_buffer.append(this.df.format(tmpy / current_y_size));
            }
        } else {
            DTuple my_dtuple;
            e = my_Attlist.elements();
            if (e.hasMoreElements()) {
                my_dtuple = (DTuple)e.nextElement();
                tmpx = my_dtuple.get(0);
                tmpy = my_dtuple.get(1);
                if (tmpx == 0.0) {
                    tmpx = 1.0E-6;
                }
                if (tmpy == 0.0) {
                    tmpy = 1.0E-6;
                }
                tmp_buffer.append(this.df.format(tmpx / current_x_size)).append(",").append(this.df.format(tmpy / current_y_size));
            }
            while (e.hasMoreElements()) {
                my_dtuple = (DTuple)e.nextElement();
                tmp_buffer.append(" ; ");
                tmpx = my_dtuple.get(0);
                tmpy = my_dtuple.get(1);
                if (tmpx == 0.0) {
                    tmpx = 1.0E-6;
                }
                if (tmpy == 0.0) {
                    tmpy = 1.0E-6;
                }
                tmp_buffer.append(this.df.format(tmpx / current_x_size)).append(",").append(this.df.format(tmpy / current_y_size));
            }
        }
        values = tmp_buffer.toString();
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("values", values);
        newElement.setAttribute("id", id);
        newElement.setAttribute("begin", Long.toString(begin) + "ms");
        newElement.setAttribute("dur", Long.toString(duration) + "ms");
        if (animatable_object instanceof OvalObj) {
            Element tmp = this.compensate(begin, duration);
            tmp.setAttribute("repeatCount", repeatCount);
            Element tmp_ = (Element)tmp.cloneNode(false);
            tmp.setAttribute("from", this.df.format(-this.width_root / 2.0) + " " + this.df.format(-this.height_root / 2.0));
            tmp.setAttribute("to", this.df.format(-this.width_root / 2.0) + " " + this.df.format(-this.height_root / 2.0));
            tmp_.setAttribute("from", this.df.format(this.width_root / 2.0) + " " + this.df.format(this.height_root / 2.0));
            tmp_.setAttribute("to", this.df.format(this.width_root / 2.0) + " " + this.df.format(this.height_root / 2.0));
            latestElement.insertBefore(tmp, null);
            latestElement.insertBefore(newElement, null);
            latestElement.insertBefore(tmp_, null);
        } else {
            latestElement.insertBefore(newElement, null);
        }
        return latestElement;
    }

    public Element creatAnimationFillcolor(Vector my_Attlist, long begin, long duration, String repeatCount) {
        DTuple my_dtuple;
        StringBuffer tmp_buffer = new StringBuffer();
        String values = "";
        Enumeration e = my_Attlist.elements();
        if (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(ColorHelper.RGB(my_dtuple, this.df2));
        }
        while (e.hasMoreElements()) {
            tmp_buffer.append(";");
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(ColorHelper.RGB(my_dtuple, this.df2));
        }
        values = tmp_buffer.toString();
        Element newElement = this.doc.createElement("animate");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", "fill");
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("begin", begin + "ms");
        newElement.setAttribute("dur", duration + "ms");
        newElement.setAttribute("values", values);
        return newElement;
    }

    public Element creatAnimationColor(Vector my_Attlist, Item animatable_object, long begin, long duration, String repeatCount) {
        DTuple my_dtuple;
        StringBuffer tmp_buffer = new StringBuffer();
        String values = "";
        String attributeName = "stroke";
        Enumeration e = my_Attlist.elements();
        if (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(ColorHelper.RGB(my_dtuple, this.df2));
        }
        while (e.hasMoreElements()) {
            tmp_buffer.append(";");
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(ColorHelper.RGB(my_dtuple, this.df2));
        }
        values = tmp_buffer.toString();
        Element newElement = this.doc.createElement("animate");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", attributeName);
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("values", values);
        newElement.setAttribute("begin", begin + "ms");
        newElement.setAttribute("dur", duration + "ms");
        return newElement;
    }

    public Element creatFreeHandAnimation(long firstTimeStamp, Vector values, Vector timestamp, long duration, Obj obj) {
        DPair singlevalue = null;
        String points = "";
        String keytimes = "";
        String additive = "sum";
        StringBuffer tmp_buffer = new StringBuffer();
        StringBuffer tmp_points = new StringBuffer();
        tmp_buffer.append("M");
        double current_x_pos = obj.getPos().get(0);
        double current_y_pos = obj.getPos().get(1);
        double current_x_size = obj.getSize().get(0);
        double current_y_size = obj.getSize().get(1);
        if (current_x_size == Double.MIN_VALUE) {
            current_x_size = 1.0;
        }
        if (current_y_size == Double.MIN_VALUE) {
            current_y_size = 1.0;
        }
        if (current_x_size == 0.0) {
            current_x_size = 1.0E-6;
        }
        if (current_y_size == 0.0) {
            current_y_size = 1.0E-6;
        }
        if (obj instanceof AnnotationPlineObj || obj instanceof AnnotationLineObj) {
            current_y_pos = 0.0;
            current_x_pos = 0.0;
            current_y_size = 1.0;
            current_x_size = 1.0;
            additive = "replace";
        }
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            Vector my_value = (Vector)e.nextElement();
            Enumeration e2 = my_value.elements();
            while (e2.hasMoreElements()) {
                singlevalue = (DPair)e2.nextElement();
                tmp_buffer.append(this.df2.format((singlevalue.get(0) - current_x_pos) * this.width_root / current_x_size)).append(" ").append(this.df2.format((singlevalue.get(1) - current_y_pos) * this.height_root / current_y_size));
                if (!e2.hasMoreElements()) continue;
                tmp_buffer.append(" L");
            }
            if (e.hasMoreElements()) {
                tmp_points.append(tmp_buffer.toString()).append(" ; ");
                tmp_points.append("M");
            } else {
                tmp_points.append(tmp_buffer.toString());
            }
            tmp_buffer.delete(0, tmp_buffer.length());
        }
        points = tmp_points.toString();
        keytimes = this.getKeyTimes(timestamp, firstTimeStamp, duration);
        Element newElement = this.doc.createElement("animate");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", "d");
        newElement.setAttribute("begin", firstTimeStamp + "ms");
        if (duration > 0L) {
            newElement.setAttribute("dur", duration + "ms");
        }
        newElement.setAttribute("additive", additive);
        if (!keytimes.equals("")) {
            newElement.setAttribute("keyTimes", keytimes);
        }
        newElement.setAttribute("values", points);
        return newElement;
    }

    public Element createGeometrieAnimation(Vector my_Attlist, int geometrie_index, Item animatable_object, Element latestElement, long begin, long duration, String repeatCount) {
        StringBuffer tmp_buffer = new StringBuffer();
        double[] transformlist = this.getTransform(latestElement.getAttribute("transform"));
        double tmp_A = this.width_root / transformlist[2];
        double tmp_B = this.height_root / transformlist[3];
        DPair[] geometrie = ((Obj)animatable_object).getGeometry();
        String values = "";
        int counter_for_one = 0;
        int counter = 0;
        Enumeration e = my_Attlist.elements();
        while (e.hasMoreElements()) {
            DTuple my_dtuple = (DTuple)e.nextElement();
            if (counter_for_one == 0) {
                tmp_buffer.append("M");
            }
            if (counter_for_one >= 1) {
                tmp_buffer.append(" L");
            }
            ++counter_for_one;
            tmp_buffer.append(this.df.format((my_dtuple.get(0) - geometrie[counter].get(0)) * tmp_A)).append(" ").append(this.df.format((my_dtuple.get(1) - geometrie[counter].get(1)) * tmp_B));
            if (++counter / geometrie_index != 0) {
                if (animatable_object instanceof PolygonObj) {
                    tmp_buffer.append(" Z");
                }
                if (e.hasMoreElements()) {
                    tmp_buffer.append(";");
                }
                counter = 0;
                counter_for_one = 0;
                continue;
            }
            if (!e.hasMoreElements() || counter_for_one == 1) continue;
            tmp_buffer.append("");
        }
        counter_for_one = 0;
        values = tmp_buffer.toString();
        Element newElement = this.doc.createElement("animate");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", "d");
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("begin", Long.toString(begin) + "ms");
        newElement.setAttribute("dur", Long.toString(duration) + "ms");
        newElement.setAttribute("additive", "sum");
        newElement.setAttribute("values", values);
        return newElement;
    }

    public Element fillColor(boolean filled, long begin, Item animatable_object) {
        String value = "none";
        if (filled && ((GraphObj)animatable_object).getFillColor() != null) {
            value = ColorHelper.RGB(((GraphObj)animatable_object).getFillColor());
        }
        Element newElement = this.doc.createElement("set");
        newElement.setAttribute("attributeName", "fill");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("to", value);
        newElement.setAttribute("begin", begin - 1L + "ms");
        return newElement;
    }

    public Element createAnimationVisibility(boolean is_visible, long begin) {
        String value = "visible";
        if (!is_visible) {
            value = "hidden";
        }
        Element newElement = this.doc.createElement("animate");
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        newElement.setAttribute("attributeName", "visibility");
        newElement.setAttribute("repeatCount", "1");
        newElement.setAttribute("begin", Long.toString(begin) + "ms");
        newElement.setAttribute("dur", "1ms");
        newElement.setAttribute("values", value);
        return newElement;
    }

    public Element SetSize(Vector values, Element latestElement, Item obj, String id, long firstTimeStamp, long duration, DPair current, Vector timestamp) {
        String keytimes = this.getKeyTimes(timestamp, firstTimeStamp, duration);
        Element newElement = this.createAnimationResize();
        if (!keytimes.equals("")) {
            newElement.setAttribute("keyTimes", keytimes);
        }
        latestElement = this.fulfilAnimationResize(values, latestElement, newElement, id, obj, firstTimeStamp, duration, current, "1");
        return latestElement;
    }

    public Element SetPos(Vector value, Element latestElement, Item obj, String id, long firstTimeStamp, long duration, DPair currentpos, DPair currentsize, Vector timestamp) {
        DTuple my_dtuple;
        StringBuffer tmp_buffer = new StringBuffer();
        String keytimes = this.getKeyTimes(timestamp, firstTimeStamp, duration);
        String values = "";
        String additive = "sum";
        double current_x_pos = currentpos.get(0);
        double current_y_pos = currentpos.get(1);
        double current_x_size = currentsize.get(0);
        double current_y_size = currentsize.get(1);
        if (current_x_size == Double.MIN_VALUE) {
            current_x_size = 1.0;
        }
        if (current_y_size == Double.MIN_VALUE) {
            current_y_size = 1.0;
        }
        if (current_x_size == 0.0) {
            current_x_size = 1.0E-6;
        }
        if (current_y_size == 0.0) {
            current_y_size = 1.0E-6;
        }
        if (obj instanceof TextObj) {
            current_x_size = current_y_size;
        }
        if (obj instanceof AnnotationPlineObj || obj instanceof AnnotationLineObj) {
            current_y_size = 1.0;
            current_x_size = 1.0;
            current_y_pos = 0.0;
            current_x_pos = 0.0;
            additive = "replace";
        }
        if (obj instanceof AnnotationPointerObj) {
            current_y_size = 1.0;
            current_x_size = 1.0;
            additive = "replace";
        }
        double tmp_A = this.width_root / current_x_size;
        double tmp_B = this.height_root / current_y_size;
        Enumeration e_ = value.elements();
        if (e_.hasMoreElements()) {
            my_dtuple = (DTuple)e_.nextElement();
            tmp_buffer.append(this.df.format((my_dtuple.get(0) - current_x_pos) * tmp_A)).append(",").append(this.df.format((my_dtuple.get(1) - current_y_pos) * tmp_B));
        }
        while (e_.hasMoreElements()) {
            my_dtuple = (DTuple)e_.nextElement();
            tmp_buffer.append(" ; ");
            tmp_buffer.append(this.df.format((my_dtuple.get(0) - current_x_pos) * tmp_A)).append(",").append(this.df.format((my_dtuple.get(1) - current_y_pos) * tmp_B));
        }
        values = tmp_buffer.toString();
        Element newElement = this.doc.createElement("animateTransform");
        newElement.setAttribute("attributeName", "transform");
        newElement.setAttribute("type", "translate");
        newElement.setAttribute("additive", additive);
        newElement.setAttribute("calcMode", "discrete");
        newElement.setAttribute("fill", "freeze");
        if (!keytimes.equals("")) {
            newElement.setAttribute("keyTimes", keytimes);
        }
        newElement.setAttribute("values", values);
        newElement.setAttribute("begin", firstTimeStamp + "ms");
        newElement.setAttribute("dur", duration + "ms");
        latestElement.insertBefore(newElement, null);
        return latestElement;
    }

    public void SetText(Vector attrList, Element latest, String id) {
        int n = 0;
        while (n < attrList.size()) {
            Attribute attr = (Attribute)attrList.elementAt(n);
            if (attr.value != null) {
                latest.insertBefore(this.create_scripting(200, attr.time, "", id, (String)attr.value, ""), null);
            }
            ++n;
        }
    }

    public String convertFontName(String FountName) {
        String result = "'Times New Roman'";
        if (FountName.equals("Monospaced")) {
            result = "monospace";
        } else if (FountName.equals("SansSerif")) {
            result = "sans-serif";
        }
        return result;
    }

    public String getStyleMutual(Item tmp, long at, boolean add_z_order, int z_order) {
        this.strokewidth = "2.0";
        double width = 0.0;
        double height = 0.0;
        double tmp_width = tmp.getSize().get(0);
        double tmp_height = tmp.getSize().get(1);
        this.x_ = tmp.getPos().get(0) * this.width_root;
        this.y_ = tmp.getPos().get(1) * this.height_root;
        String keep_layer = "";
        String visibility = "visible";
        if (tmp_width == Double.MIN_VALUE) {
            tmp_width = 1.0;
        }
        if (tmp_height == Double.MIN_VALUE) {
            tmp_height = 1.0;
        }
        if (tmp_width == 0.0) {
            tmp_width = 1.0E-6;
        }
        if (tmp_height == 0.0) {
            tmp_height = 1.0E-6;
        }
        width = tmp_width * this.width_root;
        height = tmp_height * this.height_root;
        if (tmp instanceof OvalObj) {
            this.transform = "translate(" + this.df.format(this.x_ + width / 2.0) + "," + this.df.format(this.y_ + height / 2.0) + ")" + " " + "scale(" + this.df.format(tmp_width) + "," + this.df.format(tmp_height) + ")";
        } else if (tmp instanceof AnnotationPlineObj || tmp instanceof AnnotationLineObj || tmp instanceof AnnotationPointerObj) {
            this.transform = "translate(0,0) scale(1,1)";
            this.strokewidth = "1.0";
        } else {
            this.transform = "translate(" + this.x_ + "," + this.y_ + ")" + " " + "scale(" + this.df.format(tmp_width) + "," + this.df.format(tmp_height) + ")";
        }
        if (add_z_order) {
            keep_layer = ";z-index:" + z_order;
        }
        visibility = tmp.isVisible() && at == 0L ? "visible" : "hidden";
        if (tmp instanceof TextObj) {
            this.transform = "translate(" + this.df.format(this.x_) + "," + this.df.format(this.y_) + ")" + " " + "scale(" + this.df.format(tmp_height) + ")";
            String align = "start";
            TextObj mytext = (TextObj)tmp;
            switch (mytext.getAlign()) {
                case 0: {
                    align = "middle";
                    break;
                }
                case 2: {
                    align = "end";
                }
            }
            String font_style = "normal";
            switch (mytext.getFontStyle()) {
                case 2: {
                    font_style = "italic";
                    break;
                }
                case 3: {
                    font_style = "italic";
                }
            }
            String fontFamily = this.convertFontName(mytext.getFontName());
            int fontsize = mytext.getFontSize();
            return "visibility:" + visibility + ";font-style:" + font_style + ";font-family:@" + fontFamily + ";text-anchor:" + align + ";fill:" + ColorHelper.RGB(mytext.getColor()) + ";font-size:" + this.height_root;
        }
        return "visibility:" + visibility;
    }

    public String getColor(DTuple color) {
        return ColorHelper.RGB(color, this.df2);
    }

    public String getColor(Color color) {
        return ColorHelper.RGB(color);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void z_index_raise(Element latest, long begin, String parent_id, String id) {
        latest.insertBefore(this.create_scripting(201, begin, parent_id, id, "", ""), null);
    }

    public void z_index_low(Element latest, long begin, String parent_id, String id) {
        latest.insertBefore(this.create_scripting(202, begin, parent_id, id, "", ""), null);
    }

    public void OwnerLineEvent(Vector attrList, Element latest, String id) {
        Attribute attr = (Attribute)attrList.firstElement();
        if (attr.value != null) {
            Obj newOwner = AnnotationLineObj.getNewOwner(attr.value);
            DPair startPos = AnnotationLineObj.getStartPos(attr.value);
            DPair endPos = AnnotationLineObj.getEndPos(attr.value);
            String masterId = newOwner.getName().replace('.', '_');
            Element tmp = new DomHelper().find_element((Node)this.doc, "id", masterId);
            if (tmp != null) {
                DPair currentPos = newOwner.getPos();
                DPair MasterSize = newOwner.getSize();
                double MasterSize_w = MasterSize.get(0);
                double MasterSize_h = MasterSize.get(1);
                if (newOwner instanceof TextObj) {
                    MasterSize_w = MasterSize_h;
                }
                double[] transformlist = this.getTransform(latest.getAttribute("transform"));
                String strokewidth = this.df.format(1.0 / Math.abs(this.getStrokWidth(tmp) * Math.min(MasterSize_w, MasterSize_h)));
                double p1 = startPos.get(0) * this.width_root / MasterSize_w;
                double p2 = startPos.get(1) * this.height_root / MasterSize_h;
                double q1 = endPos.get(0) * this.width_root / MasterSize_w;
                double q2 = endPos.get(1) * this.height_root / MasterSize_h;
                if (newOwner instanceof OvalObj) {
                    double rx = this.width_root / 2.0;
                    double ry = this.height_root / 2.0;
                    p1 -= rx;
                    p2 -= ry;
                    q1 -= rx;
                    q2 -= ry;
                }
                String twoPoints = "M" + this.df.format(p1) + " " + this.df.format(p2) + " L" + this.df.format(q1) + " " + this.df.format(q2);
                latest.insertBefore(this.create_scripting(attr.time, masterId, id, strokewidth, twoPoints), null);
            }
        }
    }

    public void OwnerEvent(AbsoluteTrans absTrans, Element latest, String id) {
        Vector attrList = absTrans.getAttributeList();
        Attribute attr = (Attribute)attrList.firstElement();
        boolean isoval = false;
        if (attr.value != null) {
            String masterId;
            Element tmp;
            Obj slaveObj = (Obj)absTrans.getObj();
            DPair slaveSize = slaveObj.getSize();
            DPair slavePos = slaveObj.getPos();
            double translate_x = 0.0;
            double translate_y = 0.0;
            double x_norm = 1.0;
            double y_norm = 1.0;
            double x = 0.0;
            double y = 0.0;
            double MasterSize_w = 0.0;
            double MasterSize_h = 0.0;
            DPair RelPos = null;
            DPair MasterSize = null;
            boolean owner_is_null = true;
            Obj newOwner = AnnotationOvalObj.getNewOwner(attr.value);
            if (newOwner != null) {
                MasterSize = newOwner.getSize();
                MasterSize_w = MasterSize.get(0);
                MasterSize_h = MasterSize.get(1);
                if (newOwner instanceof TextObj) {
                    MasterSize_w = MasterSize_h;
                }
                if (slaveObj instanceof AnnotationOvalObj) {
                    RelPos = AnnotationOvalObj.getRelPos(attr.value);
                    x = Math.abs(this.width_root / 2.0 * slaveSize.get(0) / MasterSize_w);
                    y = Math.abs(this.height_root / 2.0 * slaveSize.get(1) / MasterSize_h);
                    translate_x = Math.abs(slaveSize.get(0) / 2.0 * this.width_root);
                    translate_y = Math.abs(slaveSize.get(1) / 2.0 * this.height_root);
                    isoval = true;
                    owner_is_null = false;
                } else {
                    RelPos = AnnotationRectObj.getRelPos(attr.value);
                    x = Math.abs(this.width_root * slaveSize.get(0) / MasterSize_w);
                    y = Math.abs(this.height_root * slaveSize.get(1) / MasterSize_h);
                    owner_is_null = false;
                }
            }
            if (!owner_is_null && (tmp = new DomHelper().find_element((Node)this.doc, "id", masterId = newOwner.getName().replace('.', '_'))) != null) {
                DPair currentPos = newOwner.getPos();
                if (slaveSize.get(0) / MasterSize.get(0) < 0.0) {
                    x_norm = -1.0;
                }
                if (slaveSize.get(1) / MasterSize.get(1) < 0.0) {
                    y_norm = -1.0;
                }
                translate_x += (slaveSize.get(0) / 2.0 * (1.0 - x_norm) - RelPos.get(0)) * this.width_root;
                translate_y += (slaveSize.get(1) / 2.0 * (1.0 - y_norm) - RelPos.get(1)) * this.height_root;
                if (newOwner instanceof OvalObj) {
                    translate_x -= MasterSize.get(0) / 2.0 * this.width_root;
                    translate_y -= MasterSize.get(1) / 2.0 * this.height_root;
                }
                String transform = " translate(" + translate_x + "," + translate_y + ") ";
                String strokewidth = this.df.format(1.0 / Math.abs(this.getStrokWidth(tmp) * Math.min(MasterSize_w, MasterSize_h)));
                latest.insertBefore(this.create_scripting(attr.time, masterId, id, strokewidth, isoval, x, y, transform), null);
            }
        }
    }

    public Document createTamplate(Document doc) {
        return null;
    }

    private Element compensate(long begin, long duration) {
        Element tmp = this.doc.createElement("animateTransform");
        tmp.setAttribute("attributeName", "transform");
        tmp.setAttribute("type", "translate");
        tmp.setAttribute("calcMode", "linear");
        tmp.setAttribute("fill", "freeze");
        tmp.setAttribute("begin", Long.toString(begin) + "ms");
        tmp.setAttribute("dur", Long.toString(duration) + "ms");
        tmp.setAttribute("additive", "sum");
        return tmp;
    }

    private Element createMarker(int type) {
        Element defs = this.doc.createElement("defs");
        Element marker = this.doc.createElement("marker");
        marker.setAttribute("viewBox", "0 0 8 16");
        marker.setAttribute("markerUnits", "strokeWidth");
        marker.setAttribute("markerWidth", "15");
        marker.setAttribute("markerHeight", "15");
        marker.setAttribute("orient", "auto");
        Element path = this.doc.createElement("path");
        switch (type) {
            case 100: {
                marker.setAttribute("id", "OpenMarkerStart");
                marker.setAttribute("refX", "0");
                marker.setAttribute("refY", "8");
                path.setAttribute("d", "M 8 0 L 0 8 L 8 16");
                path.setAttribute("stroke", "black");
                path.setAttribute("fill", "none");
                break;
            }
            case 101: {
                marker.setAttribute("id", "OpenMarkerEnd");
                marker.setAttribute("refX", "8");
                marker.setAttribute("refY", "8");
                path.setAttribute("d", "M 0 0 L 8 8 L 0 16");
                path.setAttribute("stroke", "black");
                path.setAttribute("fill", "none");
                break;
            }
            case 102: {
                marker.setAttribute("id", "FillMarkerStart");
                marker.setAttribute("refX", "0");
                marker.setAttribute("refY", "8");
                path.setAttribute("d", "M 8 0 L 0 8 L 8 16Z");
                break;
            }
            case 103: {
                marker.setAttribute("id", "FillMarkerEnd");
                marker.setAttribute("refX", "8");
                marker.setAttribute("refY", "8");
                path.setAttribute("d", "M 0 0 L 8 8 L 0 16Z");
            }
        }
        marker.insertBefore(path, null);
        defs.insertBefore(marker, null);
        return defs;
    }

    private Element createJavaScript(String type) {
        String cdata = "var svgdoc,svgroot;function getSVGDoc(load_evt){ \n svgdoc=load_evt.getTarget().getOwnerDocument(); \n svgroot=svgdoc.getDocumentElement(); \n } \n function modifyText(x,y){ \n var textobj; \n textobj=svgdoc.getElementById(x).getFirstChild(); \n textobj.setData(y); \n } \n function raiseElement(parent,child){ \n var group = svgdoc.getElementById(parent); \n var elem= svgdoc.getElementById(child); \n group.removeChild(elem); \n group.appendChild(elem); \n } \n function lowElement(parent,child){ \n var group = svgdoc.getElementById(parent); \n var elem= svgdoc.getElementById(child); \n var firstcd = group.getFirstChild(); \n group.removeChild(elem); \n group.insertBefore(elem,firstcd); \n } \n function owner_event(masterId,slaveId,x,y,strokewidth,mode,transform) { \n var master = svgdoc.getElementById(masterId); \n var MasterParent = master.getParentNode(); \n var slave = svgdoc.getElementById(slaveId); \n var group = slave.getParentNode(); \n var cloneslave = slave.cloneNode(false); \n var visib  = slave.getElementsByTagName('animate'); \n for (var j= 0 ; j<visib.getLength() ;j++){ \n if(visib.item(j).getAttribute('attributeName')=='visibility'){ \n cloneslave.appendChild(visib.item(j).cloneNode(false)); \n } \n } \n group.removeChild(slave); \n var masterTransform = master.getAttribute('transform'); \n cloneslave.setAttribute('stroke-width',strokewidth); \n cloneslave.setAttribute('style','visibility:hidden'); \n if(mode=='true'){  \n cloneslave.setAttribute('transform',transform+masterTransform); \n cloneslave.setAttribute('rx',x);cloneslave.setAttribute('ry',y); \n }else if(mode=='false'){ \n cloneslave.setAttribute('transform',transform+masterTransform); \n cloneslave.setAttribute('width',x); \n cloneslave.setAttribute('height',y); \n } \n else{ \n cloneslave.setAttribute('transform',masterTransform); \n cloneslave.setAttribute('d',x); \n } \n var animlist = master.getElementsByTagName('animateTransform'); \n for (var i= 0 ; i<animlist.getLength() ; i++){ \n cloneslave.appendChild(animlist.item(i).cloneNode(false)); \n } \n while(MasterParent.getTagName()=='g'){ \n var cloneMaster = MasterParent.cloneNode(false); \n var clone_id = MasterParent.getAttribute('id'); \n cloneMaster.setAttribute('id',clone_id+'cloned'); \n cloneMaster.appendChild(cloneslave); \n var childNodes = MasterParent.getChildNodes(); \n for (var j= 0 ; j<childNodes.getLength() ; j++){ \n if(childNodes.item(j).getNodeName=='animateTransform'){ \n cloneMaster.appendChild(childNodes.item(j).cloneNode(false)); \n } \n } \n cloneslave = cloneMaster; \n MasterParent= MasterParent.getParentNode(); \n } \n group.appendChild(cloneslave); \n }";
        Element new_Element = this.doc.createElement("script");
        new_Element.setAttribute("type", type);
        new_Element.appendChild(this.doc.createCDATASection(cdata));
        return new_Element;
    }

    private Element create_scripting(int mode, long begin, String parent_id, String id, String value, String strokewidth) {
        Element new_Element = this.doc.createElement("animate");
        new_Element.setAttribute("begin", begin + "ms");
        switch (mode) {
            case 200: {
                new_Element.setAttribute("onbegin", "modifyText('" + id + "','" + value + "')");
                break;
            }
            case 201: {
                new_Element.setAttribute("onbegin", "raiseElement('" + parent_id + "','" + id + "')");
                break;
            }
            case 202: {
                new_Element.setAttribute("onbegin", "lowElement('" + parent_id + "','" + id + "')");
            }
        }
        return new_Element;
    }

    private Element create_scripting(long begin, String parent_id, String id, String strokewidth, boolean isoval, double x, double y, String transform) {
        Element new_Element = this.doc.createElement("animate");
        new_Element.setAttribute("begin", begin + "ms");
        new_Element.setAttribute("onbegin", "owner_event('" + parent_id + "','" + id + "','" + x + "','" + y + "','" + strokewidth + "','" + isoval + "','" + transform + "')");
        return new_Element;
    }

    private Element create_scripting(long begin, String parent_id, String id, String strokewidth, String twoPoints) {
        Element new_Element = this.doc.createElement("animate");
        new_Element.setAttribute("begin", begin + "ms");
        new_Element.setAttribute("onbegin", "owner_event('" + parent_id + "','" + id + "','" + twoPoints + "','','" + strokewidth + "','path','')");
        return new_Element;
    }

    private double getStrokWidth(Element tmp) {
        double stro = 1.0;
        Element masterElement = (Element)tmp.getParentNode();
        if (masterElement != null) {
            while (masterElement.getTagName().equals("g")) {
                double[] transform = this.getTransform(masterElement.getAttribute("transform"));
                stro *= Math.max(transform[2], transform[3]);
                masterElement = (Element)masterElement.getParentNode();
            }
        }
        return stro;
    }

    public double[] getTransform(String transform) {
        double[] result = new double[4];
        String[] transformtyp = transform.split(" ");
        int i = 0;
        while (i < transformtyp.length) {
            if (transformtyp[i].startsWith("translate")) {
                result[0] = Double.parseDouble(transformtyp[i].substring(transformtyp[i].indexOf("(") + 1, transformtyp[i].indexOf(",")));
                result[1] = Double.parseDouble(transformtyp[i].substring(transformtyp[i].indexOf(",") + 1, transformtyp[i].indexOf(")")));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < transformtyp.length) {
            if (transformtyp[i2].startsWith("scale")) {
                result[2] = Double.parseDouble(transformtyp[i2].substring(transformtyp[i2].indexOf("(") + 1, transformtyp[i2].indexOf(",")));
                result[3] = Double.parseDouble(transformtyp[i2].substring(transformtyp[i2].indexOf(",") + 1, transformtyp[i2].indexOf(")")));
            }
            ++i2;
        }
        return result;
    }

    private String getArrowStyle(Item item) {
        String arrowStyle = "None";
        switch (((PlineObj)item).getArrowStyle()) {
            case 1: {
                arrowStyle = "FillMarker";
                break;
            }
            case 0: {
                arrowStyle = "OpenMarker";
                break;
            }
            case 2: {
                arrowStyle = "FillMarker";
                break;
            }
            default: {
                arrowStyle = "None";
            }
        }
        return arrowStyle;
    }

    private Element createMarkerAttr(Item item, Element newElement, String arrowStyle) {
        switch (((PlineObj)item).getArrowMode()) {
            case 1: {
                newElement.setAttribute("marker-start", "url(#" + arrowStyle + "Start)");
                break;
            }
            case 2: {
                newElement.setAttribute("marker-end", "url(#" + arrowStyle + "End)");
                break;
            }
            case 3: {
                newElement.setAttribute("marker-start", "url(#" + arrowStyle + "Start)");
                newElement.setAttribute("marker-end", "url(#" + arrowStyle + "End)");
                break;
            }
        }
        return newElement;
    }

    private String getKeyTimes(Vector timestamp, long firstTimeStamp, long duration) {
        StringBuffer tmp_buffer = new StringBuffer();
        if (timestamp.size() > 1) {
            Long keyframe;
            Enumeration e = timestamp.elements();
            if (e.hasMoreElements()) {
                keyframe = (Long)e.nextElement();
                tmp_buffer.append(this.df.format((double)(keyframe - firstTimeStamp) / (double)duration));
            }
            while (e.hasMoreElements()) {
                keyframe = (Long)e.nextElement();
                tmp_buffer.append(" ; ");
                tmp_buffer.append(this.df.format((double)(keyframe - firstTimeStamp) / (double)duration));
            }
        }
        return tmp_buffer.toString();
    }
}

