/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jedas.Jedas;
import jedas.io.Animation2Explorer;
import jedas.io.BenchmarkFrame;
import jedas.io.JedasPlayer;
import jedas.io.PlayerLabel;
import jedas.io.PlayerVisualizer;
import jedas.utils.ToolButton;
import jedas.utils.XFigExportFrame;

public class PlayerControlPanel
extends Panel
implements PlayerVisualizer {
    static final int PLAY = 1;
    static final int PAUSE = 2;
    static final int STOP = 3;
    static final int QUIT = 4;
    static final int DEBUG = 5;
    static final int BENCHMARK = 6;
    static final int EXPORT = 7;
    TimeControl timeControl;
    TimeScroller timeScroller;
    PlayerLabel timeLabel;
    PlayerLabel animTimeLabel;
    ToolButton tbPlay;
    ToolButton tbPause;
    ToolButton tbQuit;
    ToolButton tbExplore;
    ToolButton tbBenchmark;
    ToolButton tbExport;
    static boolean busy = false;
    private ScrollThread scrollThread = null;

    public PlayerControlPanel(long animLength) {
        this.setBackground(Jedas.DEFAULT_BGCOLOR);
        this.setLayout(new BorderLayout());
        Panel tp = new Panel();
        tp.setLayout(new BorderLayout());
        int twentieth = (int)(animLength / 20L);
        this.timeControl = new TimeControl(0, 0, twentieth, 0, (int)animLength + twentieth - 1);
        this.scrollThread = new ScrollThread();
        this.scrollThread.start();
        this.timeScroller = new TimeScroller();
        this.timeControl.addAdjustmentListener(this.timeScroller);
        this.timeControl.setBlockIncrement(1000);
        tp.add((Component)this.timeControl, "Center");
        this.add((Component)tp, "North");
        Panel btP = new Panel(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 40);
            }
        };
        btP.setLayout(null);
        MyMouseAdapter ml = new MyMouseAdapter();
        String path = "images/";
        Dimension dim = new Dimension(45, 27);
        Dimension pos = new Dimension(2, 5);
        this.tbPlay = new ToolButton(null, pos, dim, path + "play.gif", null, 1, false, ml);
        this.tbPlay.setDisabledImage(path + "playdis.gif");
        btP.add(this.tbPlay);
        pos = new Dimension(52, 5);
        this.tbPause = new ToolButton(null, pos, dim, path + "pause.gif", null, 2, false, ml);
        this.tbPause.setDisabledImage(path + "pausedis.gif");
        btP.add(this.tbPause);
        pos = new Dimension(102, 5);
        this.tbQuit = new ToolButton(null, pos, dim, path + "quit.gif", null, 4, false, ml);
        this.tbQuit.setDisabledImage(path + "quitdis.gif");
        btP.add(this.tbQuit);
        dim = new Dimension(61, 27);
        pos = new Dimension(202, 5);
        this.tbExplore = new ToolButton(null, pos, dim, path + "view.gif", null, 5, false, ml);
        btP.add(this.tbExplore);
        pos = new Dimension(267, 5);
        this.tbBenchmark = new ToolButton(null, pos, dim, path + "benchmrk.gif", null, 6, false, ml);
        btP.add(this.tbBenchmark);
        pos = new Dimension(332, 5);
        this.tbBenchmark = new ToolButton(null, pos, dim, path + "export.gif", null, 7, false, ml);
        btP.add(this.tbBenchmark);
        this.timeLabel = new PlayerLabel("0:00:00.000");
        this.timeLabel.setLocation(420, 5);
        this.timeLabel.setSize(130, 20);
        btP.add(this.timeLabel);
        this.animTimeLabel = new PlayerLabel("0:00:00.000");
        this.animTimeLabel.setLocation(420, 20);
        this.animTimeLabel.setSize(130, 20);
        btP.add(this.animTimeLabel);
        this.add((Component)btP, "South");
    }

    public void play() {
        if (!JedasPlayer.getInstance().getPlayerScheduler().isRunning()) {
            Thread playAnim = new Thread(){

                public void run() {
                    JedasPlayer.getInstance().getPlayerScheduler().start();
                }
            };
            playAnim.start();
        }
    }

    public void pause() {
        JedasPlayer.getInstance().getPlayerScheduler().quitNotify();
    }

    public void benchmark() {
        Thread benchM = new Thread(){

            public void run() {
                new BenchmarkFrame(JedasPlayer.getInstance().getPlayerScheduler());
            }
        };
        benchM.start();
    }

    public void setTime(long realTimeStamp) {
        this.timeControl.setValue((int)realTimeStamp);
        this.timeLabel.setText(this.getTimeString(realTimeStamp));
    }

    public void setAnimTime(long animTimeStamp) {
        this.animTimeLabel.setText(this.getTimeString(animTimeStamp));
    }

    public long getVisualizedTime() {
        return this.timeControl.getValue();
    }

    public boolean isTimeOK(long timeStamp) {
        return true;
    }

    private String make2(int number) {
        String tmp = "" + number;
        if (tmp.length() == 1) {
            return "0" + tmp;
        }
        return tmp;
    }

    private String make3(long number) {
        String tmp = "" + number;
        switch (tmp.length()) {
            case 1: {
                return "00" + tmp;
            }
            case 2: {
                return "0" + tmp;
            }
        }
        return tmp;
    }

    public String getTimeString(long timeStamp) {
        int seconds;
        int minutes;
        long span = timeStamp;
        int hours = (int)(span / 3600000L);
        if (hours > 0) {
            span %= (long)(hours * 3600000);
        }
        if ((minutes = (int)(span / 60000L)) > 0) {
            span %= (long)(minutes * 60000);
        }
        if ((seconds = (int)(span / 1000L)) > 0) {
            span %= (long)(seconds * 1000);
        }
        return hours + ":" + this.make2(minutes) + ":" + this.make2(seconds) + "." + this.make3(span);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 60);
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            int tag = ((ToolButton)e.getSource()).getTag();
            int subTag = ((ToolButton)e.getSource()).getSubTag();
            switch (tag) {
                case 1: {
                    PlayerControlPanel.this.play();
                    break;
                }
                case 2: {
                    PlayerControlPanel.this.pause();
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    System.exit(0);
                    break;
                }
                case 5: {
                    new Animation2Explorer(JedasPlayer.getInstance().getJedasAnimation());
                    break;
                }
                case 6: {
                    PlayerControlPanel.this.benchmark();
                    break;
                }
                case 7: {
                    new XFigExportFrame();
                }
            }
        }
    }

    private class ScrollThread
    extends Thread {
        long lastRequest = -1L;
        boolean newRequest = false;
        boolean waiting = false;

        private ScrollThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (!this.newRequest) {
                    try {
                        ScrollThread scrollThread = this;
                        synchronized (scrollThread) {
                            this.waiting = true;
                            this.wait();
                            this.waiting = false;
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.newRequest = false;
                JedasPlayer.getInstance().getPlayerScheduler().jumpToTime(this.lastRequest);
                PlayerControlPanel.this.setTime(this.lastRequest);
                JedasPlayer.getInstance().getPlayerScheduler().updatePanels();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestTime(long time) {
            this.lastRequest = time;
            this.newRequest = true;
            if (this.waiting) {
                ScrollThread scrollThread = this;
                synchronized (scrollThread) {
                    this.notify();
                }
            }
        }
    }

    private class TimeScroller
    implements AdjustmentListener {
        private TimeScroller() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!JedasPlayer.getInstance().getPlayerScheduler().isRunning()) {
                PlayerControlPanel.this.scrollThread.requestTime(e.getValue());
            }
        }
    }

    class TimeControl
    extends Scrollbar {
        public TimeControl(int orient, int a, int b, int c, int d) {
            super(orient, a, b, c, d);
        }
    }
}

