/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jedas.Composite;
import jedas.CompositeProperties;
import jedas.Properties;
import jedas.io.CompositePropertiesViewer;
import jedas.io.PrListEntry;
import jedas.io.PropertiesViewer;

class PrListViewer
extends Frame {
    PrListEntry prEntry;
    List lsProps;

    public PrListViewer(PrListEntry prEntry) {
        super("PropertiesAccessStreamEntry@" + prEntry.timeStamp);
        this.prEntry = prEntry;
        this.initGUI();
        this.updateGUI();
        this.setVisible(true);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.lsProps = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(300, 600);
            }
        };
        this.add((Component)this.lsProps, "Center");
        this.addWindowListener(new WindowChecker());
        this.lsProps.addActionListener(new RecordableClicker());
        this.pack();
    }

    private void updateGUI() {
        int i = 0;
        while (i < this.prEntry.properties.length) {
            this.lsProps.add("#" + i + ": " + this.prEntry.properties[i].owner.getName());
            ++i;
        }
    }

    void openCompositeViewer() {
        if (this.lsProps.getSelectedIndex() != -1) {
            Properties p = this.prEntry.properties[this.lsProps.getSelectedIndex()];
            if (p.owner instanceof Composite) {
                System.out.println("CompositePropertiesViewer()");
                new CompositePropertiesViewer(this.prEntry, (CompositeProperties)p);
            } else {
                new PropertiesViewer(p);
            }
        }
    }

    private class RecordableClicker
    implements ActionListener {
        private RecordableClicker() {
        }

        public void actionPerformed(ActionEvent e) {
            PrListViewer.this.openCompositeViewer();
        }
    }

    private class WindowChecker
    extends WindowAdapter {
        private WindowChecker() {
        }

        public void windowClosing(WindowEvent e) {
            PrListViewer.this.dispose();
        }
    }
}

