/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import jedas.Properties;

class PropertiesViewer
extends Frame {
    Properties props;
    List lsProps;

    public PropertiesViewer(Properties props) {
        super(props.owner.getName());
        this.props = props;
        this.initGUI();
        this.updateGUI();
        this.setVisible(true);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.lsProps = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        this.add((Component)this.lsProps, "Center");
        this.addWindowListener(new WindowChecker());
        this.pack();
    }

    private void updateGUI() {
        Field[] fs = this.props.getClass().getFields();
        int i = 0;
        while (i < fs.length) {
            try {
                this.lsProps.add(fs[i].getName() + " = " + fs[i].get(this.props) + " [" + fs[i].getDeclaringClass().getName() + "]");
            }
            catch (Exception e) {
                this.lsProps.add(fs[i].getName() + " = <error: " + e.toString() + ">");
            }
            ++i;
        }
    }

    private class WindowChecker
    extends WindowAdapter {
        private WindowChecker() {
        }

        public void windowClosing(WindowEvent e) {
            PropertiesViewer.this.dispose();
        }
    }
}

