/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.Dimension;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jedas.Jedas;
import jedas.JedasError;
import jedas.io.Recorder;
import jedas.utils.LightLabel;
import jedas.utils.ToolButton;

public class RecordPanel
extends Panel {
    static final int RECORD = 10;
    static final int STOP = 20;
    private static RecordPanel instance = null;
    private ToolButton tbRecord = null;
    private ToolButton tbStop = null;
    private LightLabel lbName = null;

    public RecordPanel() {
        if (instance != null) {
            throw new JedasError("There may only exist a single instance of jedas.io.RecordPanel!");
        }
        instance = this;
        this.initGUI();
    }

    private void initGUI() {
        this.setBackground(Jedas.DEFAULT_BGCOLOR);
        this.setLayout(null);
        RecordButtonAdapter rba = new RecordButtonAdapter();
        String path = "images/";
        Dimension dim = new Dimension(45, 27);
        Dimension pos = new Dimension(2, 2);
        this.tbRecord = new ToolButton(null, pos, dim, path + "record.gif", null, 10, false, rba);
        this.tbRecord.setDisabledImage(path + "recorddis.gif");
        this.tbRecord.setEnabled(true);
        this.add(this.tbRecord);
        pos = new Dimension(52, 2);
        this.tbStop = new ToolButton(null, pos, dim, path + "stop.gif", null, 20, false, rba);
        this.tbStop.setDisabledImage(path + "stopdis.gif");
        this.tbStop.setEnabled(false);
        this.add(this.tbStop);
        this.lbName = new LightLabel(Recorder.getFileName(), 10);
        this.lbName.setSize(120, 15);
        this.lbName.setLocation(5, 30);
        this.add(this.lbName);
        this.setSize(this.getPreferredSize());
    }

    public void setRecordEnabled(boolean b) {
        this.tbRecord.setEnabled(b);
        this.tbStop.setEnabled(!b);
    }

    protected void displayFileName(String fileName) {
        this.lbName.setText(fileName);
    }

    public Dimension getPreferredSize() {
        return new Dimension(125, 50);
    }

    public static RecordPanel getInstance() {
        return instance;
    }

    private class RecordButtonAdapter
    extends MouseAdapter {
        private RecordButtonAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            int tag = ((ToolButton)e.getSource()).getTag();
            switch (tag) {
                case 10: {
                    Jedas.setRecording(true);
                    break;
                }
                case 20: {
                    Jedas.setRecording(false);
                }
            }
        }
    }
}

