/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import jedas.Jedas;
import jedas.Properties;
import jedas.RecordObject;
import jedas.io.Attribute;
import jedas.io.JedasPlayer;
import jedas.io.SpeedChange;
import jedas.io.SpeedEvent;
import jedas.io.SpeedProperties;

public class Speed
extends RecordObject {
    static final long serialVersionUID = -7120492518977220579L;
    private static final int SET_SPEED = 800;
    private static final int RESUME = 801;
    private static final int SUSPEND = 802;
    private static final int QUIT_ANIM = 803;
    private static final int SPEED_EVENT = 804;
    private int speed = 100;
    public double floatSpeed = 1.0;
    private long lastSpeedChange = -1L;
    private long timeOffset = 0L;
    private long suspendTime = 0L;
    private long suspendTimeOffset = 0L;
    private long lastTimeSync = 0L;
    private boolean suspended = true;

    public Speed() {
        this(100);
    }

    public Speed(int initSpeed) {
        this.setSpeedTrans(Jedas.getRecordTime(), Jedas.timeSync, initSpeed);
    }

    public synchronized void setSpeed(int newSpeed) {
        long tmp = Jedas.getRecordTime();
        this.setSpeedTrans(tmp, Jedas.timeSync, newSpeed);
        this.markChanged();
        this.addAttributeToQueue(800, new Attribute(tmp, new SpeedChange(Jedas.timeSync, newSpeed)));
    }

    private void setSpeedTrans(long timeStamp, long newOffset, int newSpeed) {
        this.lastSpeedChange = timeStamp;
        this.speed = newSpeed;
        this.timeOffset = newOffset;
        this.floatSpeed = (double)this.speed / 100.0;
        this.propertiesChanged();
    }

    public void syncSpeed(long timeStamp) {
        this.setSpeedTrans(timeStamp, 0L, this.speed);
        this.suspended = false;
        this.markChanged();
        this.addAttributeToQueue(800, new Attribute(timeStamp, new SpeedChange(0L, this.speed)));
    }

    protected void syncPlaySpeed(long timeStamp, long offSet) {
        this.setSpeedTrans(timeStamp, offSet, this.speed);
        this.suspended = false;
    }

    private void suspendTrans(long suspendTime, long backupTimeSync) {
        this.suspendTime = suspendTime;
        this.lastTimeSync = backupTimeSync;
        this.suspended = true;
        this.propertiesChanged();
    }

    public void suspend(long suspendTime) {
        this.suspendTime = suspendTime;
        this.lastTimeSync = this.getTimeSync(suspendTime);
        this.suspended = true;
        this.markChanged();
        this.addAttributeToQueue(804, new Attribute(suspendTime, new SpeedEvent(0, this.lastTimeSync)));
    }

    private void resumeTrans(long resumeTime, long backupTimeOffset) {
        this.timeOffset = backupTimeOffset;
        this.lastSpeedChange = resumeTime;
        this.suspended = false;
        this.propertiesChanged();
    }

    public void resume(long resumeTime) {
        this.timeOffset = this.lastTimeSync;
        this.lastSpeedChange = resumeTime;
        this.suspended = false;
        this.markChanged();
        this.addAttributeToQueue(804, new Attribute(resumeTime, new SpeedEvent(1, this.timeOffset)));
    }

    public void quit(long quitTime) {
        if (Jedas.IO_DEBUGMODE) {
            System.out.println("Speed::quit() Recording QUIT_ANIM attribute");
        }
        this.suspend(quitTime);
        this.addAttributeToQueue(803, new Attribute(quitTime, null));
        this.markChanged();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public int getSpeed() {
        return this.speed;
    }

    public synchronized long getTimeSync(long forThisTime) {
        if (!this.isSuspended()) {
            return this.timeOffset + (long)(this.floatSpeed * (double)(forThisTime - this.lastSpeedChange));
        }
        return this.lastTimeSync;
    }

    public synchronized long getTimeSync() {
        if (!Jedas.isPlayerMode()) {
            if (!this.isSuspended()) {
                return this.timeOffset + (long)(this.floatSpeed * (double)(Jedas.recordTime - this.lastSpeedChange));
            }
            return this.lastTimeSync;
        }
        return this.timeOffset + (long)(this.floatSpeed * (double)(System.currentTimeMillis() - this.lastSpeedChange));
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 800: {
                SpeedChange sc = (SpeedChange)attr.value;
                this.setSpeedTrans(attr.time, sc.timeOffset, sc.newSpeed);
                break;
            }
            case 802: {
                this.suspendTrans(attr.time, (Long)attr.value);
                break;
            }
            case 801: {
                this.resumeTrans(attr.time, (Long)attr.value);
                break;
            }
            case 804: {
                SpeedEvent o = (SpeedEvent)attr.value;
                switch (o.type) {
                    case 0: {
                        this.suspendTrans(attr.time, o.time);
                        break;
                    }
                    case 1: {
                        this.resumeTrans(attr.time, o.time);
                        break;
                    }
                    case 2: {
                        this.setSpeedTrans(attr.time, o.time, o.speed);
                    }
                }
                break;
            }
            case 803: {
                JedasPlayer jP = JedasPlayer.getInstance();
                if (jP == null) {
                    throw new Error("Speed::received QUIT_ANIM attribute in non-player mode!");
                }
                this.quit(attr.time);
                jP.getPlayerScheduler().quitNotify();
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public Properties getProperties() {
        SpeedProperties sp = new SpeedProperties();
        return this.getProperties(sp);
    }

    public Properties getProperties(Properties p) {
        SpeedProperties sp = (SpeedProperties)super.getProperties(p);
        sp.speed = this.speed;
        sp.lastSpeedChange = this.lastSpeedChange;
        sp.timeOffset = this.timeOffset;
        sp.suspended = this.isSuspended();
        sp.suspendTime = this.suspendTime;
        sp.lastTimeSync = this.lastTimeSync;
        return sp;
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        SpeedProperties sp = (SpeedProperties)p;
        this.suspended = sp.suspended;
        this.suspendTime = sp.suspendTime;
        this.lastTimeSync = sp.lastTimeSync;
        this.lastSpeedChange = sp.lastSpeedChange;
        this.timeOffset = sp.timeOffset;
        this.speed = sp.speed;
        this.floatSpeed = (double)this.speed / 100.0;
    }

    protected boolean recordStatus() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

