/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jedas.CompObj;
import jedas.Composite;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.GraphObj;
import jedas.Item;
import jedas.LineObj;
import jedas.Obj;
import jedas.OvalObj;
import jedas.Path;
import jedas.PlineObj;
import jedas.PolygonObj;
import jedas.RectObj;
import jedas.Scheduler;
import jedas.TextObj;
import jedas.Trans;
import jedas.dispatcher.SetColorDispatcher;
import jedas.dispatcher.SetFillColorDispatcher;
import jedas.dispatcher.SetFilledDispatcher;
import jedas.dispatcher.SetVisibleDispatcher;
import jedas.dispatcher.TransDispatcher;
import jedas.io.Animate;
import jedas.io.ColorHelper;
import jedas.io.Set;
import jedas.io.Transformation;
import jedas.io.stringHelper;
import jedas.math.Matrix;

public class creator {
    private Scheduler scheduler;
    private Vector disper;
    private Color stroke;
    private Color fill;
    private boolean is_filled;
    private boolean has_stroke;
    private boolean is_visible;
    private String font_family;
    private int font_size;
    private int alignment_mode;
    private double rel_font_size;
    private DrawAttr drawattr;

    public creator(Scheduler scheduler, Vector disper) {
        this.scheduler = scheduler;
        this.disper = disper;
    }

    public CompObj createJedasCompPanel(Composite panel, double width_root, double height_root, Vector animvect, Matrix matr) {
        double x = matr.getValue(0, 2) / width_root;
        double y = matr.getValue(1, 2) / height_root;
        double w = matr.getValue(0, 0);
        double h = matr.getValue(1, 1);
        CompObj mycoppobj = new CompObj();
        mycoppobj.setPos(new DPair(x, y));
        mycoppobj.setSize(new DPair(w, h));
        panel.addItem(mycoppobj);
        Enumeration e = animvect.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (!(object instanceof Transformation)) continue;
            Transformation transform = (Transformation)object;
            this.create_animation(transform, width_root, height_root, mycoppobj, matr);
        }
        return mycoppobj;
    }

    public void createJedasRect(Composite panel, Matrix properties, String style, double width_root, double height_root, Vector animvect, Matrix matr) {
        this.convertStyle(style);
        Matrix oldcoord = matr.mult(properties);
        double x = oldcoord.getValue(0, 2) / width_root;
        double y = oldcoord.getValue(1, 2) / height_root;
        double w = oldcoord.getValue(0, 0) / width_root;
        double h = oldcoord.getValue(1, 1) / height_root;
        RectObj obj = new RectObj(new DPair(x, y), new DPair(w, h), this.stroke, this.fill, this.is_filled);
        panel.addItem(obj);
        if (!this.is_visible) {
            obj.hide();
        }
        Enumeration e = animvect.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Transformation) {
                Transformation transform = (Transformation)object;
                this.create_animation(transform, properties, width_root, height_root, obj, matr);
                continue;
            }
            if (object instanceof Animate) {
                Animate animate = (Animate)object;
                this.create_animation(animate, (Obj)obj);
                continue;
            }
            if (!(object instanceof Set)) continue;
            Set set = (Set)object;
            this.create_animation(set, (Obj)obj);
        }
    }

    public void createJedasOval(Composite panel, Matrix properties, String style, double width_root, double height_root, Vector animvect, Matrix matr) {
        this.convertStyle(style);
        Matrix oldcoord = matr.mult(properties);
        double x = oldcoord.getValue(0, 2) / width_root;
        double y = oldcoord.getValue(1, 2) / height_root;
        double w = oldcoord.getValue(0, 0) / width_root;
        double h = oldcoord.getValue(1, 1) / height_root;
        OvalObj obj = new OvalObj(new DPair(x, y), new DPair(w, h), this.stroke, this.fill);
        obj.setFilled(this.is_filled);
        panel.addItem(obj);
        if (!this.is_visible) {
            obj.hide();
        }
        Enumeration e = animvect.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Transformation) {
                Transformation transform = (Transformation)object;
                this.create_animation(transform, properties, width_root, height_root, obj, matr);
                continue;
            }
            if (object instanceof Animate) {
                Animate animate = (Animate)object;
                this.create_animation(animate, (Obj)obj);
                continue;
            }
            if (!(object instanceof Set)) continue;
            Set set = (Set)object;
            this.create_animation(set, (Obj)obj);
        }
    }

    public void createJedasText(Composite panel, Matrix properties, String style, double width_root, double height_root, Vector animvect, Matrix matr, String text) {
        this.convertStyle(style);
        TextObj obj = new TextObj(text, new DPair(0.0, 0.0), (double)this.font_size / height_root, this.alignment_mode);
        if (!this.is_visible) {
            obj.hide();
        }
        properties.setValue(0, 0, width_root);
        properties.setValue(1, 1, height_root);
        Matrix oldcoord = matr.mult(properties);
        double x = oldcoord.getValue(0, 2) / width_root;
        double y = oldcoord.getValue(1, 2) / height_root;
        double w = oldcoord.getValue(0, 0) / width_root;
        double h = oldcoord.getValue(1, 1) / height_root;
        CompObj mycoppobj = new CompObj();
        mycoppobj.setPos(new DPair(x, y));
        mycoppobj.setSize(new DPair(w, h));
        mycoppobj.addItem(obj);
        panel.addItem(mycoppobj);
        Enumeration e = animvect.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Transformation) {
                Transformation transform = (Transformation)object;
                this.create_animation(transform, properties, width_root, height_root, mycoppobj, matr);
                continue;
            }
            if (object instanceof Animate) {
                Animate animate = (Animate)object;
                this.create_animation(animate, (Obj)obj);
                continue;
            }
            if (!(object instanceof Set)) continue;
            Set set = (Set)object;
            this.create_animation(set, (Obj)obj);
        }
    }

    public void createJedasPlineObj(Composite panel, Matrix properties, String style, double width_root, double height_root, Vector animvect, Matrix matr, boolean is_polygon) {
        PlineObj obj;
        Vector<DPair> points = new Vector<DPair>();
        this.convertStyle(style);
        double[] list = properties.toDoubleList();
        int len = list.length / 3;
        double x_left = list[0];
        double x_right = list[0];
        double y_above = list[len];
        double y_down = list[len];
        int i = 0;
        while (i < len) {
            x_left = Math.min(x_left, list[i]);
            x_right = Math.max(x_right, list[i]);
            y_above = Math.min(y_above, list[i + len]);
            y_down = Math.max(y_down, list[i + len]);
            ++i;
        }
        int i2 = 0;
        while (i2 < len) {
            points.add(new DPair((list[i2] - x_left) / width_root, (list[i2 + len] - y_above) / height_root));
            ++i2;
        }
        if (this.is_filled || is_polygon) {
            obj = new PolygonObj(points, this.stroke, this.fill);
            obj.setFilled(this.is_filled);
        } else {
            obj = new PlineObj(points, this.stroke);
        }
        if (!this.is_visible) {
            obj.hide();
        }
        properties = null;
        properties = new Matrix(3, 3);
        double[] values = new double[]{width_root, 0.0, x_left, 0.0, height_root, y_above, 0.0, 0.0, 1.0};
        properties.setMatrix(values);
        Matrix oldcoord = matr.mult(properties);
        double x = oldcoord.getValue(0, 2) / width_root;
        double y = oldcoord.getValue(1, 2) / height_root;
        double w = oldcoord.getValue(0, 0) / width_root;
        double h = oldcoord.getValue(1, 1) / height_root;
        CompObj mycoppobj = new CompObj();
        mycoppobj.setPos(new DPair(x, y));
        mycoppobj.setSize(new DPair(w, h));
        mycoppobj.addItem(obj);
        panel.addItem(mycoppobj);
        Enumeration e = animvect.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Transformation) {
                Transformation transform = (Transformation)object;
                this.create_animation(transform, properties, width_root, height_root, mycoppobj, matr);
                continue;
            }
            if (object instanceof Animate) {
                Animate animate = (Animate)object;
                this.create_animation(animate, (Obj)obj);
                continue;
            }
            if (!(object instanceof Set)) continue;
            Set set = (Set)object;
            this.create_animation(set, (Obj)obj);
        }
    }

    public void createJedasLineObj(Composite panel, Matrix properties, String style, double width_root, double height_root, Vector animvect, Matrix matr) {
        this.convertStyle(style);
        double x1 = properties.getValue(0, 2);
        double y1 = properties.getValue(1, 2);
        double x2 = properties.getValue(0, 0);
        double y2 = properties.getValue(1, 1);
        double x_left = Math.min(x1, x2);
        double x_right = Math.max(x1, x2);
        double y_above = Math.min(y1, y2);
        double y_down = Math.max(y1, y2);
        LineObj obj = new LineObj(new DPair((x1 - x_left) / width_root, (y1 - y_above) / height_root), new DPair((x2 - x_left) / width_root, (y2 - y_above) / height_root), this.stroke);
        if (!this.is_visible) {
            obj.hide();
        }
        properties = null;
        properties = new Matrix(3, 3);
        double[] values = new double[]{width_root, 0.0, x_left, 0.0, height_root, y_above, 0.0, 0.0, 1.0};
        properties.setMatrix(values);
        Matrix oldcoord = matr.mult(properties);
        x1 = oldcoord.getValue(0, 2) / width_root;
        y1 = oldcoord.getValue(1, 2) / height_root;
        x2 = oldcoord.getValue(0, 0) / width_root;
        y2 = oldcoord.getValue(1, 1) / height_root;
        CompObj mycoppobj = new CompObj();
        mycoppobj.setPos(new DPair(x1, y1));
        mycoppobj.setSize(new DPair(x2, y2));
        mycoppobj.addItem(obj);
        panel.addItem(mycoppobj);
        Enumeration e = animvect.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Transformation) {
                Transformation transform = (Transformation)object;
                this.create_animation(transform, properties, width_root, height_root, mycoppobj, matr);
                continue;
            }
            if (object instanceof Animate) {
                Animate animate = (Animate)object;
                this.create_animation(animate, (Obj)obj);
                continue;
            }
            if (!(object instanceof Set)) continue;
            Set set = (Set)object;
            this.create_animation(set, (Obj)obj);
        }
    }

    private void create_animation(Transformation transform, double width_root, double height_root, CompObj obj, Matrix matr) {
        transform.setFrom(matr.mult(transform.from));
        transform.setTo(matr.mult(transform.to));
        boolean loop = false;
        Path pathmove = new Path();
        Path pathresize = new Path();
        int repeatCount = 1;
        long begin = transform.begin;
        long duration = transform.duration;
        double xf = transform.from.getValue(0, 2) / width_root;
        double yf = transform.from.getValue(1, 2) / height_root;
        double wf = transform.from.getValue(0, 0);
        double hf = transform.from.getValue(1, 1);
        double xt = transform.to.getValue(0, 2) / width_root;
        double yt = transform.to.getValue(1, 2) / height_root;
        double wt = transform.to.getValue(0, 0);
        double ht = transform.to.getValue(1, 1);
        String tmp_repeatCount = transform.repeatcount;
        if (tmp_repeatCount.equals("indefinite")) {
            loop = true;
        } else {
            repeatCount = tmp_repeatCount.equals("") ? 0 : Integer.parseInt(tmp_repeatCount);
        }
        if (xf != xt || yf != yt) {
            pathmove.createDistance(new DPair(xf, yf), new DPair(xt, yt), duration);
            Trans transM = new Trans((Item)obj, pathmove, 2, loop);
            this.disper.add(new TransDispatcher(this.scheduler, transM, begin));
        }
        if (wf != wt || hf != ht) {
            pathresize.createDistance(new DPair(wf, hf), new DPair(wt, ht), duration);
            Trans transS = new Trans((Item)obj, pathresize, 4, loop);
            this.disper.add(new TransDispatcher(this.scheduler, transS, begin));
        }
    }

    private void create_animation(Transformation transform, Matrix properties, double width_root, double height_root, Obj obj, Matrix matr) {
        double xfb = 0.0;
        double yfb = 0.0;
        double wfb = 0.0;
        double hfb = 0.0;
        boolean loop = false;
        Path pathmove = new Path();
        Path pathresize = new Path();
        int repeatCount = 1;
        transform.setFrom(matr.mult(transform.from));
        transform.setTo(matr.mult(transform.to));
        long begin = transform.begin;
        long duration = transform.duration;
        Matrix from = transform.from.mult(properties);
        Matrix to = transform.to.mult(properties);
        double xf = from.getValue(0, 2) / width_root;
        double yf = from.getValue(1, 2) / height_root;
        double wf = from.getValue(0, 0) / width_root;
        double hf = from.getValue(1, 1) / height_root;
        double xt = to.getValue(0, 2) / width_root;
        double yt = to.getValue(1, 2) / height_root;
        double wt = to.getValue(0, 0) / width_root;
        double ht = to.getValue(1, 1) / height_root;
        String tmp_repeatCount = transform.repeatcount;
        if (tmp_repeatCount.equals("indefinite")) {
            loop = true;
        } else {
            repeatCount = tmp_repeatCount.equals("") ? 0 : Integer.parseInt(tmp_repeatCount);
        }
        if (xf != xt || yf != yt) {
            pathmove.createDistance(new DPair(xf, yf), new DPair(xt, yt), duration);
            Trans transM = new Trans((Item)obj, pathmove, 2, loop);
            this.disper.add(new TransDispatcher(this.scheduler, transM, begin));
        }
        if (wf != wt || hf != ht) {
            pathresize.createDistance(new DPair(wf, hf), new DPair(wt, ht), duration);
            Trans transS = new Trans((Item)obj, pathresize, 4, loop);
            this.disper.add(new TransDispatcher(this.scheduler, transS, begin));
        }
    }

    private void create_animation(Transformation transform, Matrix properties, double width_root, double height_root, CompObj obj, Matrix matr) {
        double xfb = 0.0;
        double yfb = 0.0;
        double wfb = 0.0;
        double hfb = 0.0;
        boolean loop = false;
        Path pathmove = new Path();
        Path pathresize = new Path();
        int repeatCount = 1;
        transform.setFrom(matr.mult(transform.from));
        transform.setTo(matr.mult(transform.to));
        long begin = transform.begin;
        long duration = transform.duration;
        Matrix from = transform.from.mult(properties);
        Matrix to = transform.to.mult(properties);
        double xf = from.getValue(0, 2) / width_root;
        double yf = from.getValue(1, 2) / height_root;
        double wf = from.getValue(0, 0) / width_root;
        double hf = from.getValue(1, 1) / height_root;
        double xt = to.getValue(0, 2) / width_root;
        double yt = to.getValue(1, 2) / height_root;
        double wt = to.getValue(0, 0) / width_root;
        double ht = to.getValue(1, 1) / height_root;
        String tmp_repeatCount = transform.repeatcount;
        if (tmp_repeatCount.equals("indefinite")) {
            loop = true;
        } else {
            repeatCount = tmp_repeatCount.equals("") ? 0 : Integer.parseInt(tmp_repeatCount);
        }
        if (xf != xt || yf != yt) {
            pathmove.createDistance(new DPair(xf, yf), new DPair(xt, yt), duration);
            Trans transM = new Trans((Item)obj, pathmove, 2, loop);
            this.disper.add(new TransDispatcher(this.scheduler, transM, begin));
        }
        if (wf != wt || hf != ht) {
            pathresize.createDistance(new DPair(wf, hf), new DPair(wt, ht), duration);
            Trans transS = new Trans((Item)obj, pathresize, 4, loop);
            this.disper.add(new TransDispatcher(this.scheduler, transS, begin));
        }
    }

    private void create_animation(Animate animate, Obj obj) {
        String attributeName = animate.attributeName;
        Path path = animate.path;
        long begin = animate.begin;
        if (path == null) {
            System.out.println("path is null");
        }
        if (attributeName.equals("fill")) {
            Trans trans = new Trans((Item)obj, path, 6, animate.loop);
            this.disper.add(new SetFilledDispatcher((GraphObj)obj, true, (long)((int)begin)));
            this.disper.add(new TransDispatcher(this.scheduler, trans, begin + 1L));
        } else if (attributeName.equals("stroke")) {
            Trans trans = new Trans((Item)obj, path, 8, animate.loop);
            this.disper.add(new TransDispatcher(this.scheduler, trans, begin));
        }
    }

    private void create_animation(Set set, Obj obj) {
        String attributeName = set.attributeName;
        long begin = set.begin;
        if (attributeName.equals("fill")) {
            if (set.none) {
                this.disper.add(new SetFilledDispatcher((GraphObj)obj, false, begin));
            } else {
                this.disper.add(new SetFilledDispatcher((GraphObj)obj, true, begin));
                this.disper.add(new SetFillColorDispatcher((GraphObj)obj, ColorHelper.StringToColor(set.rgb), (long)((int)begin)));
            }
        } else if (attributeName.equals("stroke")) {
            this.disper.add(new SetColorDispatcher(obj, ColorHelper.StringToColor(set.rgb), begin));
        } else if (attributeName.equals("visibility")) {
            boolean visib = true;
            if (set.visibility.equals("hidden")) {
                visib = false;
            }
            this.disper.add(new SetVisibleDispatcher(obj, visib, begin));
        }
    }

    private void convertStyle(String style) {
        this.stroke = Color.black;
        this.fill = Color.black;
        this.is_filled = true;
        this.has_stroke = true;
        this.is_visible = true;
        this.font_family = "";
        this.font_size = 1;
        this.alignment_mode = 1;
        String[] stylelist = stringHelper.split(style, ";");
        int i = 0;
        while (i < stylelist.length) {
            String[] tmp = stringHelper.split(stylelist[i], ":");
            if (tmp[0].equals("fill")) {
                if (tmp[1].equals("none")) {
                    this.is_filled = false;
                }
                if (tmp[1].startsWith("rgb")) {
                    this.fill = ColorHelper.StringToColor(tmp[1]);
                }
            }
            if (tmp[0].equals("stroke")) {
                if (tmp[1].equals("none")) {
                    this.has_stroke = false;
                }
                if (tmp[1].startsWith("rgb")) {
                    this.stroke = ColorHelper.StringToColor(tmp[1]);
                }
            }
            if (tmp[0].equals("visibility") && tmp[1].equals("hidden")) {
                this.is_visible = false;
            }
            if (tmp[0].equals("font-family")) {
                this.font_family = tmp[1];
            }
            if (tmp[0].equals("font-size")) {
                this.font_size = Integer.parseInt(tmp[1]);
            }
            if (tmp[0].equals("text-anchor")) {
                if (tmp[1].equals("end")) {
                    this.alignment_mode = 2;
                } else if (tmp[1].equals("middle")) {
                    this.alignment_mode = 0;
                }
            }
            ++i;
        }
    }
}

