/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.zip.InflaterInputStream;
import jedas.CompPanel;
import jedas.CompPanelProperties;
import jedas.CompositeProperties;
import jedas.Properties;
import jedas.dom.DomHelper;
import jedas.dom.WriteDomDocument2XmlFile;
import jedas.io.DealCompoProperties;
import jedas.io.DealTrans;
import jedas.io.Jedas2Animation;
import jedas.io.JedasSvg;
import jedas.io.JedasVml;
import jedas.io.PasKeyFrame;
import jedas.io.PlayerScheduler;
import jedas.io.xmlFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class jedas2XML {
    private Jedas2Animation jedas2Animation_;
    private Properties root_properties;

    public static void main(String[] args) {
        System.out.println("jedas.io.jedas2XML v201");
        System.out.println("This program is part of the JEDAS package.");
        System.out.println("(c)2003 Ramin Danaei-Boroumand.");
        System.out.println("eMail: rmueller@informatik.uni-freiburg.de");
        System.out.println("       danaei-b@informatik.uni-freiburg.de");
        String modus = "null";
        if (args.length != 3) {
            System.out.println("Usage: java jedas.io.jedas2XML <animation.jea>");
            System.exit(0);
        }
        if (args[1].equals("vml")) {
            modus = "vml";
        } else if (args[1].equals("svg")) {
            modus = "svg";
        } else {
            System.out.println("Usage: Secound parameter musr be vml or svg.");
            System.exit(0);
        }
        try {
            System.out.println("jedas2XML: Loading '" + args[0] + "'...");
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new FileInputStream(args[0])));
            Object o = in.readObject();
            System.out.println("Explor Records...");
            new jedas2XML((Jedas2Animation)o, modus, args[2]);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public jedas2XML(Jedas2Animation jedas2Animation, String modus, String output) {
        this.jedas2Animation_ = jedas2Animation;
        this.start(modus, output);
    }

    private void start(String modus, String output) {
        PlayerScheduler my_sc = new PlayerScheduler(this.jedas2Animation_, null);
        Properties[] my_feld = ((PasKeyFrame)this.jedas2Animation_.propertyAccessStream.elementAt((int)0)).properties;
        this.applyProperties(my_feld, 0L);
        Document doc = DomHelper.CreateDomDocument();
        double width = ((CompPanelProperties)this.root_properties).dimension.getWidth();
        double height = ((CompPanelProperties)this.root_properties).dimension.getHeight();
        if (doc != null) {
            xmlFormat xml_format;
            if (modus.equals("vml")) {
                System.out.println("modus vml");
                xml_format = new JedasVml(doc, width, height);
            } else {
                System.out.println("modus svg");
                xml_format = new JedasSvg(doc, width, height);
            }
            String id = this.root_properties.owner.getName().replace('.', '_');
            Element newElement = xml_format.createRootElement(id);
            DealCompoProperties my_Deal = new DealCompoProperties((CompositeProperties)this.root_properties, xml_format);
            Document frame_doc = my_Deal.DealingLayers(doc, newElement);
            new DealTrans(frame_doc, this.jedas2Animation_.transitionAccessStream, this.jedas2Animation_.propertyAccessStream, my_sc, my_Deal, xml_format, modus);
            if (modus.equals("vml")) {
                xml_format.createTamplate(frame_doc);
                System.out.println("WriteDomDocument2XmlFile");
                new WriteDomDocument2XmlFile(frame_doc, output + "_temporary_rdb_19102364");
                try {
                    File outputfile = new File(output);
                    File tmporary = new File(output + "_temporary_rdb_19102364");
                    System.out.println("deleteCommentTags");
                    DomHelper.deleteCommentTags((File)tmporary, (File)outputfile);
                    tmporary.delete();
                }
                catch (Exception e) {
                    System.out.println("Try to Write in File: " + output + " Faild: " + e);
                }
            } else {
                System.out.println("WriteDomDocument2XmlFile");
                new WriteDomDocument2XmlFile(frame_doc, output);
            }
            System.out.println(" END ");
        }
    }

    private void applyProperties(Properties[] properties, long timeStamp) {
        int i = 0;
        while (i < properties.length) {
            if (properties[i].nextPropertiesTimeStamp > timeStamp && !(properties[i].owner instanceof CompPanel)) {
                properties[i].owner.setProperties(properties[i]);
            }
            if (properties[i].owner instanceof CompPanel) {
                System.out.println("instance of CompPanel");
                this.root_properties = properties[i];
            }
            ++i;
        }
    }
}

