/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import jedas.DPair;
import jedas.Item;
import jedas.Jedas;
import jedas.Path;
import jedas.SyncTrans;
import jedas.Trans;
import jedas.trees.AVLNodeItem;
import jedas.trees.SearchNodeItem;
import jedas.trees.SearchTree;
import jedas.trees.TreeNode;

public class AVLTree
extends SearchTree {
    static final long serialVersionUID = 6128639016902519168L;
    public static long PAUSE_TIME = 400L;

    public AVLTree() {
    }

    public AVLTree(AVLNodeItem rootItem) {
        this(new DPair(0.0, 0.0), rootItem);
    }

    public AVLTree(DPair pos, AVLNodeItem rootItem) {
        super(Jedas.getScheduler(), pos, rootItem);
        rootItem.setBalance(0);
    }

    public TreeNode insertAVLItem(AVLNodeItem newItem) {
        return this.insertAVLItem(newItem, true);
    }

    public TreeNode insertAVLItemFast(AVLNodeItem newItem) {
        return this.insertAVLItem(newItem, false);
    }

    private TreeNode insertAVLItem(AVLNodeItem insertItem, boolean anims) {
        if (insertItem == null) {
            System.err.println(this.getName() + "::insertAVLItem(null) not allowed!");
            return null;
        }
        if (this.getRoot() == null) {
            this.insertRoot(insertItem);
            insertItem.setBalance(0);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
            return this.getRoot();
        }
        TreeNode current = this.getRoot();
        TreeNode inserted = null;
        boolean ready = false;
        boolean callUpin = false;
        while (!ready) {
            if (anims) {
                this.animate(current.moveItemHere(insertItem));
            }
            if (this.getValue(current) == insertItem.getValue()) {
                System.out.println(this.getName() + "::Value already in tree, ignored!");
                insertItem.removeFromParent();
                ready = true;
            }
            if (ready) continue;
            if (this.getValue(current) > insertItem.getValue()) {
                if (current.getLeftSon() == null) {
                    inserted = current.insertLeft(insertItem);
                    insertItem.setBalance(0);
                    if (this.getBalance(current) == 1) {
                        this.setBalance(current, 0);
                        ready = true;
                        continue;
                    }
                    this.setBalance(current, -1);
                    callUpin = true;
                    ready = true;
                    continue;
                }
                current = current.getLeftSon();
                continue;
            }
            if (current.getRightSon() == null) {
                inserted = current.insertRight(insertItem);
                insertItem.setBalance(0);
                if (this.getBalance(current) == -1) {
                    this.setBalance(current, 0);
                    ready = true;
                    continue;
                }
                this.setBalance(current, 1);
                ready = true;
                callUpin = true;
                continue;
            }
            current = current.getRightSon();
        }
        if (ready) {
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
        }
        if (callUpin) {
            this.upin(current, anims);
        }
        return inserted;
    }

    private void upin(TreeNode P, boolean anims) {
        TreeNode fP;
        if (P.isRoot()) {
            return;
        }
        this.setComment(P, "upin");
        if (anims) {
            this.doPause();
        }
        if ((fP = P.getFather()).getLeftSon() == P) {
            if (this.getBalance(fP) == 1) {
                this.setBalance(fP, 0);
            } else if (this.getBalance(fP) == 0) {
                this.setBalance(fP, -1);
                this.setComment(P, "");
                this.upin(fP, anims);
            } else if (this.getBalance(P) == -1) {
                fP.rotateRight();
                this.setBalance(fP, 0);
                this.setBalance(P, 0);
                if (anims) {
                    this.doAnims();
                } else {
                    this.getInShape();
                }
            } else {
                TreeNode H = P.getRightSon();
                int oldHbal = this.getBalance(H);
                P.rotateLeft();
                if (anims) {
                    this.doAnims();
                } else {
                    this.getInShape();
                }
                fP.rotateRight();
                this.setBalance(H, 0);
                switch (oldHbal) {
                    case 1: {
                        this.setBalance(P, -1);
                        this.setBalance(fP, 0);
                        break;
                    }
                    case -1: {
                        this.setBalance(P, 0);
                        this.setBalance(fP, 1);
                        break;
                    }
                    case 0: {
                        this.setBalance(P, 0);
                        this.setBalance(fP, 0);
                    }
                }
                if (anims) {
                    this.doAnims();
                } else {
                    this.getInShape();
                }
            }
        } else if (this.getBalance(fP) == -1) {
            this.setBalance(fP, 0);
        } else if (this.getBalance(fP) == 0) {
            this.setBalance(fP, 1);
            this.setComment(P, "");
            this.upin(fP, anims);
        } else if (this.getBalance(P) == 1) {
            fP.rotateLeft();
            this.setBalance(fP, 0);
            this.setBalance(P, 0);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
        } else {
            TreeNode H = P.getLeftSon();
            int oldHbal = this.getBalance(H);
            P.rotateRight();
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
            fP.rotateLeft();
            this.setBalance(H, 0);
            switch (oldHbal) {
                case -1: {
                    this.setBalance(fP, 0);
                    this.setBalance(P, 1);
                    break;
                }
                case 1: {
                    this.setBalance(fP, -1);
                    this.setBalance(P, 0);
                    break;
                }
                case 0: {
                    this.setBalance(fP, 0);
                    this.setBalance(P, 0);
                }
            }
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
        }
        if (this.getComment(P).equals("upin")) {
            this.setComment(P, "");
        }
    }

    public void deleteAVLItemWithValue(int delValue, DPair newPos) {
        this.deleteAVLItemWithValue(delValue, newPos, true);
    }

    public void deleteAVLItemWithValueFast(int delValue, DPair newPos) {
        this.deleteAVLItemWithValue(delValue, newPos, false);
    }

    private void deleteAVLItemWithValue(int delValue, DPair newPos, boolean anims) {
        TreeNode P = this.findNodeWithValue(delValue);
        if (this.getValue(P) != delValue) {
            System.err.println(this.getName() + "::deleteAVLItem() value " + delValue + " not found in tree.");
            return;
        }
        if (P.getLeftSon() != null && P.getRightSon() != null) {
            TreeNode symP = P.getSymmetricalSuccessor();
            P.replace(symP);
            int bP = this.getBalance(P);
            int bsymP = this.getBalance(symP);
            this.setBalance(P, bsymP);
            this.setBalance(symP, bP);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
        }
        this.deleteCases_1_and_2(P, newPos, anims);
    }

    private void deleteCases_1_and_2(TreeNode P, DPair newPos, boolean anims) {
        if (P.getLeftSon() == null && P.getRightSon() == null) {
            if (P.isRoot()) {
                P.delete(newPos);
                if (anims) {
                    this.doAnims();
                } else {
                    this.getInShape();
                }
            } else {
                TreeNode fP = P.getFather();
                if (fP.getLeftSon() == P) {
                    if (this.getBalance(fP) == -1) {
                        this.setBalance(fP, 0);
                        P.delete(newPos);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        this.upout(fP, anims);
                    } else if (this.getBalance(fP) == 0) {
                        this.setBalance(fP, 1);
                        P.delete(newPos);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                    } else {
                        P.delete(newPos);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        TreeNode Q = fP.getRightSon();
                        if (this.getBalance(Q) == 1) {
                            fP.rotateLeft();
                            this.setBalance(fP, 0);
                            this.setBalance(Q, 0);
                            if (anims) {
                                this.doAnims();
                            } else {
                                this.getInShape();
                            }
                            this.upout(Q, anims);
                        } else if (this.getBalance(Q) == -1) {
                            TreeNode S = Q.getLeftSon();
                            Q.rotateRight();
                            this.setBalance(Q, 0);
                            this.setBalance(S, 1);
                            this.setBalance(fP, 0);
                            if (anims) {
                                this.doAnims();
                            } else {
                                this.getInShape();
                            }
                            fP.rotateLeft();
                            this.setBalance(S, 0);
                            this.setBalance(Q, 0);
                            if (anims) {
                                this.doAnims();
                            } else {
                                this.getInShape();
                            }
                            this.upout(S, anims);
                        } else {
                            TreeNode S = Q.getLeftSon();
                            Q.rotateRight();
                            this.setBalance(S, 2);
                            this.setBalance(Q, 1);
                            this.setBalance(fP, 3);
                            if (anims) {
                                this.doAnims();
                            } else {
                                this.getInShape();
                            }
                            fP.rotateLeft();
                            this.setBalance(fP, 0);
                            this.setBalance(S, 1);
                            this.setBalance(Q, 1);
                            if (anims) {
                                this.doAnims();
                            } else {
                                this.getInShape();
                            }
                        }
                    }
                } else if (this.getBalance(fP) == 1) {
                    this.setBalance(fP, 0);
                    P.delete(newPos);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    this.upout(fP, anims);
                } else if (this.getBalance(fP) == 0) {
                    this.setBalance(fP, -1);
                    P.delete(newPos);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                } else {
                    TreeNode Q = fP.getLeftSon();
                    P.delete(newPos);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    if (this.getBalance(Q) == -1) {
                        fP.rotateRight();
                        this.setBalance(fP, 0);
                        this.setBalance(Q, 0);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        this.upout(Q, anims);
                    } else if (this.getBalance(Q) == 1) {
                        TreeNode S = Q.getRightSon();
                        Q.rotateLeft();
                        this.setBalance(Q, 0);
                        this.setBalance(S, -1);
                        this.setBalance(fP, -2);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        fP.rotateRight();
                        this.setBalance(fP, 0);
                        this.setBalance(S, 0);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        this.upout(S, anims);
                    } else {
                        TreeNode S = Q.getRightSon();
                        Q.rotateLeft();
                        this.setBalance(fP, -3);
                        this.setBalance(S, -2);
                        this.setBalance(Q, -1);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        fP.rotateRight();
                        this.setBalance(fP, 0);
                        this.setBalance(S, -1);
                        this.setBalance(Q, -1);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                    }
                }
            }
        } else if (P.getLeftSon() == null) {
            TreeNode Q = P.getRightSon();
            P.replace(Q);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
            P.delete(newPos);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
            this.upout(Q, anims);
        } else if (P.getRightSon() == null) {
            TreeNode Q = P.getLeftSon();
            P.replace(Q);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
            P.delete(newPos);
            if (anims) {
                this.doAnims();
            } else {
                this.getInShape();
            }
            this.upout(Q, anims);
        } else {
            System.err.println("Program error, case 3 occurred again!");
        }
    }

    private void upout(TreeNode P, boolean anims) {
        TreeNode fP;
        if (P.isRoot()) {
            return;
        }
        if (this.getBalance(P) != 0) {
            System.err.println(this.getName() + "::upout(" + P + "), P has balance " + this.getBalance(P));
            return;
        }
        this.setComment(P, "upout");
        if (anims) {
            this.doPause();
        }
        if ((fP = P.getFather()).getLeftSon() == P) {
            if (this.getBalance(fP) == -1) {
                this.setBalance(fP, 0);
                this.setComment(P, "");
                this.upout(fP, anims);
            } else if (this.getBalance(fP) == 0) {
                this.setBalance(fP, 1);
            } else {
                TreeNode Q = fP.getRightSon();
                if (this.getBalance(Q) == 0) {
                    fP.rotateLeft();
                    this.setBalance(Q, -1);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                } else if (this.getBalance(Q) == 1) {
                    fP.rotateLeft();
                    this.setBalance(fP, 0);
                    this.setBalance(Q, 0);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    this.setComment(P, "");
                    this.upout(Q, anims);
                } else {
                    TreeNode R = Q.getLeftSon();
                    if (this.getBalance(R) == -1) {
                        Q.rotateRight();
                        this.setBalance(R, 2);
                        this.setBalance(fP, 3);
                        this.setBalance(Q, 1);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        fP.rotateLeft();
                        this.setBalance(fP, 0);
                        this.setBalance(R, 0);
                        this.setBalance(Q, 1);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        this.setComment(P, "");
                        this.upout(R, anims);
                    } else if (this.getBalance(R) == 1) {
                        Q.rotateRight();
                        this.setBalance(Q, 0);
                        this.setBalance(R, 1);
                        this.setBalance(fP, 2);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        fP.rotateLeft();
                        this.setBalance(fP, 0);
                        this.setBalance(Q, 0);
                        this.setBalance(R, 0);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        this.setComment(P, "");
                        this.upout(R, anims);
                    } else {
                        Q.rotateRight();
                        this.setBalance(R, 2);
                        this.setBalance(fP, 3);
                        this.setBalance(Q, 0);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        fP.rotateLeft();
                        this.setBalance(fP, -1);
                        this.setBalance(R, 0);
                        this.setBalance(Q, 0);
                        if (anims) {
                            this.doAnims();
                        } else {
                            this.getInShape();
                        }
                        this.setComment(P, "");
                        this.upout(R, anims);
                    }
                }
            }
        } else if (this.getBalance(fP) == 1) {
            this.setBalance(fP, 0);
            this.setComment(P, "");
            this.upout(fP, anims);
        } else if (this.getBalance(fP) == 0) {
            this.setBalance(fP, -1);
        } else {
            TreeNode Q = fP.getLeftSon();
            if (this.getBalance(Q) == 0) {
                fP.rotateRight();
                this.setBalance(Q, 1);
                if (anims) {
                    this.doAnims();
                } else {
                    this.getInShape();
                }
            } else if (this.getBalance(Q) == -1) {
                fP.rotateRight();
                this.setBalance(fP, 0);
                this.setBalance(Q, 0);
                if (anims) {
                    this.doAnims();
                } else {
                    this.getInShape();
                }
                this.setComment(P, "");
                this.upout(Q, anims);
            } else {
                TreeNode R = Q.getRightSon();
                if (this.getBalance(R) == 1) {
                    Q.rotateLeft();
                    this.setBalance(R, -2);
                    this.setBalance(fP, -3);
                    this.setBalance(Q, -1);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    fP.rotateRight();
                    this.setBalance(fP, 0);
                    this.setBalance(R, 0);
                    this.setBalance(Q, -1);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    this.setComment(P, "");
                    this.upout(R, anims);
                } else if (this.getBalance(R) == -1) {
                    Q.rotateLeft();
                    this.setBalance(Q, 0);
                    this.setBalance(R, -1);
                    this.setBalance(fP, -2);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    fP.rotateRight();
                    this.setBalance(fP, 0);
                    this.setBalance(Q, 0);
                    this.setBalance(R, 0);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    this.setComment(P, "");
                    this.upout(R, anims);
                } else {
                    Q.rotateLeft();
                    this.setBalance(R, -2);
                    this.setBalance(fP, -3);
                    this.setBalance(Q, 0);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    fP.rotateRight();
                    this.setBalance(fP, 1);
                    this.setBalance(R, 0);
                    this.setBalance(Q, 0);
                    if (anims) {
                        this.doAnims();
                    } else {
                        this.getInShape();
                    }
                    this.setComment(P, "");
                    this.upout(R, anims);
                }
            }
        }
        if (this.getComment(P).equals("upout")) {
            this.setComment(P, "");
        }
    }

    public TreeNode insertItem(SearchNodeItem newItem) {
        return null;
    }

    public TreeNode insertItemFast(SearchNodeItem newItem) {
        return null;
    }

    protected int getBalance(TreeNode node) {
        return ((AVLNodeItem)node.getNodeItem()).getBalance();
    }

    protected void setBalance(TreeNode node, int balance) {
        ((AVLNodeItem)node.getNodeItem()).setBalance(balance);
    }

    protected void setComment(TreeNode node, String comment) {
        ((AVLNodeItem)node.getNodeItem()).setComment(comment);
        if (comment.equals("")) {
            node.getNodeItem().setHighlight(false);
        } else {
            node.getNodeItem().setHighlight(true);
        }
    }

    protected String getComment(TreeNode node) {
        return ((AVLNodeItem)node.getNodeItem()).getComment();
    }

    protected void doPause() {
        Path p = new Path();
        p.createNull(PAUSE_TIME, 1);
        Trans t = new Trans((Item)this, p, 5);
        this.animate(t);
    }

    protected void animate(Trans trans) {
        if (this.scheduler.isLooping()) {
            SyncTrans syncTrans = new SyncTrans(this.scheduler);
            syncTrans.add(trans);
        } else if (!this.scheduler.isActive()) {
            this.scheduler.add(trans);
            this.scheduler.start();
        } else {
            this.scheduler.add(trans);
        }
    }
}

