/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import jedas.DPair;
import jedas.Jedas;
import jedas.Scheduler;
import jedas.trees.SearchNodeItem;
import jedas.trees.SearchTree;
import jedas.trees.TreeNode;

public class SplayTree
extends SearchTree {
    static final long serialVersionUID = 1998825014832798147L;

    public SplayTree(Scheduler scheduler, SearchNodeItem rootItem) {
        this(scheduler, new DPair(0.0, 0.0), rootItem);
    }

    public SplayTree(Scheduler scheduler, DPair pos, SearchNodeItem rootItem) {
        super(scheduler, pos, rootItem);
    }

    public SplayTree(Scheduler scheduler, TreeNode rootNode) {
        this(scheduler, new DPair(0.0, 0.0), rootNode);
    }

    public SplayTree(Scheduler scheduler, DPair pos, TreeNode rootNode) {
        super(scheduler, pos, rootNode);
    }

    public void splayOperation(int value) {
        TreeNode q;
        TreeNode p = this.findNodeWithValue(value);
        if (this.getValue(p) > value && (q = p.getSymmetricalPredecessor()) != null) {
            p = q;
        }
        if (Jedas.DEBUGMODE && this.getValue(p) != value) {
            System.out.println("SplayTree::value " + value + " not found.");
        }
        while (!p.isRoot()) {
            TreeNode fP = p.getFather();
            TreeNode ffP = fP != null ? fP.getFather() : null;
            if (fP.isRoot()) {
                if (Jedas.DEBUGMODE) {
                    System.out.println("SplayTree::splayOperation() zig");
                }
                if (fP.getLeftSon() == p) {
                    fP.rotateRight();
                    this.doAnims();
                    continue;
                }
                if (fP.getRightSon() != p) continue;
                fP.rotateLeft();
                this.doAnims();
                continue;
            }
            boolean ready = false;
            if (!ready && ffP.getLeftSon() == fP && fP.getLeftSon() == p) {
                if (Jedas.DEBUGMODE) {
                    System.out.println("SplayTree::splayOperation() zig-zig");
                }
                ffP.rotateRight();
                this.doAnims();
                fP.rotateRight();
                this.doAnims();
                ready = true;
            }
            if (!ready && ffP.getRightSon() == fP && fP.getRightSon() == p) {
                if (Jedas.DEBUGMODE) {
                    System.out.println("SplayTree::splayOperation() zig-zig");
                }
                ffP.rotateLeft();
                this.doAnims();
                fP.rotateLeft();
                this.doAnims();
                ready = true;
            }
            if (!ready && ffP.getRightSon() == fP && fP.getLeftSon() == p) {
                if (Jedas.DEBUGMODE) {
                    System.out.println("SplayTree::splayOperation() zig-zag");
                }
                fP.rotateRight();
                this.doAnims();
                ffP.rotateLeft();
                this.doAnims();
                ready = true;
            }
            if (ready || ffP.getLeftSon() != fP || fP.getRightSon() != p) continue;
            if (Jedas.DEBUGMODE) {
                System.out.println("SplayTree::splayOperation() zig-zag");
            }
            fP.rotateLeft();
            this.doAnims();
            ffP.rotateRight();
            this.doAnims();
            ready = true;
        }
    }

    public TreeNode splayInsert(SearchNodeItem insertItem) {
        this.splayOperation(insertItem.getValue());
        if (this.getValue(this.getRoot()) == insertItem.getValue()) {
            return this.getRoot();
        }
        TreeNode newNode = new TreeNode(this, insertItem);
        this.setFRoot(newNode);
        if (this.getValue(this.getRoot()) > insertItem.getValue()) {
            newNode.setFRightSon(this.getRoot());
            this.getRoot().setFFather(newNode);
        } else {
            newNode.setFLeftSon(this.getRoot());
            this.getRoot().setFFather(newNode);
            this.getRoot().setFRightSon(null);
            newNode.setFRightSon(this.getRoot().getRightSon());
            if (this.getRoot().getRightSon() != null) {
                this.getRoot().getRightSon().setFFather(newNode);
            }
        }
        TreeNode.animRequired = true;
        this.getFRoot().updateShapeRT();
        this.doAnims();
        return newNode;
    }

    public void splayDelete(int value, DPair newPos) {
        this.splayOperation(value);
        if (this.getValue(this.getRoot()) != value) {
            return;
        }
        if (this.getRoot().getLeftSon() == null) {
            this.getRoot().delete(newPos);
            this.doAnims();
            return;
        }
        if (this.getRoot().getRightSon() == null) {
            this.getRoot().delete(newPos);
            this.doAnims();
            return;
        }
        SplayTree temp = new SplayTree(this.scheduler, this.getPos(), this.getRoot().getLeftSon());
        temp.setRootPos(temp.getRoot().getNodeItem().getPos());
        temp.setSize(this.getSize());
        this.transferItem(temp, 10);
        temp.getRoot().transferToTreeRek(temp);
        temp.getRoot().setFFather(null);
        this.getRoot().setFLeftSon(null);
        this.getRoot().updateRelationsRek();
        temp.getRoot().updateShapeRT();
        temp.doAnims();
        temp.splayOperation(Integer.MAX_VALUE);
        this.getRoot().deleteAndReplace(temp.getRoot(), newPos);
        this.doAnims();
        this.deleteItem(temp);
    }
}

