/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import java.util.Vector;
import jedas.CompObj;
import jedas.DPair;
import jedas.Jedas;
import jedas.Trans;
import jedas.trees.NodeItem;
import jedas.trees.TreeNode;

public class Tree
extends CompObj {
    static final long serialVersionUID = 2020196003077278979L;
    private transient TreeNode root;
    private transient TreeNode fRoot;
    private transient DPair rootPos = null;

    public Tree(NodeItem rootItem) {
        this(new DPair(0.0, 0.0), rootItem);
    }

    public Tree(DPair pos, NodeItem rootItem) {
        this.setPos(pos);
        this.fRoot = this.root = new TreeNode(this, rootItem);
        this.getInShape();
    }

    public Tree(TreeNode rootItem) {
        this(new DPair(0.0, 0.0), rootItem);
    }

    public Tree(DPair pos, TreeNode rootItem) {
        this.setPos(pos);
        this.setRoot(rootItem);
        this.setFRoot(rootItem);
        rootItem.transferToTreeRek(this, Jedas.getRecordTime());
    }

    public Tree() {
    }

    public void insertRoot(NodeItem rootItem) {
        if (this.getRoot() != null) {
            System.err.println("Tree::Tree has to be empty to insert root node!");
            return;
        }
        this.root = new TreeNode(this, rootItem);
        this.setFRoot(this.root);
        this.setRoot(this.root);
        this.getFRoot().updateShapeRT();
    }

    protected void setFRoot(TreeNode nextRoot) {
        this.fRoot = nextRoot;
    }

    protected TreeNode getFRoot() {
        return this.fRoot;
    }

    protected void setRoot(TreeNode newRoot) {
        this.root = newRoot;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRootPos(DPair newRootPos) {
        if (newRootPos != null) {
            if (this.rootPos == null) {
                this.rootPos = new DPair();
            }
            this.rootPos.set(newRootPos);
        } else {
            this.rootPos = null;
        }
    }

    public DPair getRootPos() {
        return this.rootPos;
    }

    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    public void getInShape() {
        this.getFRoot().updateShapeRT();
        TreeNode.setAnimMode(false);
        this.getFRoot().updateRelationsRek();
        TreeNode.setAnimMode(true);
        this.root = this.fRoot;
    }

    private void getTrans(Vector t) {
        if (this.getRoot() == null) {
            return;
        }
        if (this.getFRoot() != null) {
            this.getFRoot().getTransRek(t);
            this.getFRoot().updateRelationsRek();
        }
        this.root = this.fRoot;
    }

    public Trans[] getTrans() {
        Vector t = new Vector();
        this.getTrans(t);
        TreeNode.getSpecialAnims(t);
        Object[] trans = new Trans[t.size()];
        t.copyInto(trans);
        return trans;
    }

    public void setSteps(long steps) {
        TreeNode.setSteps(steps);
    }

    private void dumpTree(TreeNode current, String space) {
        System.out.println(space + "Node `" + current.getNodeItem() + "'");
        System.out.print(space + "Left son : ");
        if (current.getLeftSon() != null) {
            if (current != current.getLeftSon().getFather()) {
                System.err.println("*** Father of Son is not Father!!");
            }
            this.dumpTree(current.getLeftSon(), space + "L - ");
        } else {
            System.out.println("null");
        }
        System.out.print(space + "Right son: ");
        if (current.getRightSon() != null) {
            if (current != current.getRightSon().getFather()) {
                System.err.println("*** Father of Son is not Father!!");
            }
            this.dumpTree(current.getRightSon(), space + "R - ");
        } else {
            System.out.println("null");
        }
    }

    private void dumpFTree(TreeNode current, String space) {
        System.out.println(space + "Node `" + current.getNodeItem() + "'");
        System.out.print(space + "Left son : ");
        if (current.getFLeftSon() != null) {
            if (current != current.getFLeftSon().getFFather()) {
                System.err.println("*** Father of Son is not Father!!");
            }
            this.dumpTree(current.getFLeftSon(), space + "L - ");
        } else {
            System.out.println("null");
        }
        System.out.print(space + "Right son: ");
        if (current.getFRightSon() != null) {
            if (current != current.getFRightSon().getFFather()) {
                System.err.println("*** Father of Son is not Father!!");
            }
            this.dumpTree(current.getFRightSon(), space + "R - ");
        } else {
            System.out.println("null");
        }
    }

    public void dumpFTree() {
        this.dumpFTree(this.getFRoot(), "");
    }

    public void dumpTree() {
        this.dumpTree(this.getRoot(), "");
    }
}

