/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import java.awt.Color;
import java.util.Vector;
import jedas.CompObj;
import jedas.DPair;
import jedas.PolygonObj;
import jedas.TextObj;
import jedas.trees.NodeItem;
import jedas.trees.TreeNode;

public class TreeSymbol
extends CompObj
implements NodeItem {
    static final long serialVersionUID = 2019086288138363227L;
    public static final int DEFAULT_HEIGHT = 2;
    public static final String DEFAULT_TEXT = "T";
    public static final double DEFAULT_WIDTH = 0.1;
    private static double FONT_SIZE = 0.03;
    private double LEVEL_SPACE = TreeNode.LEVEL_SPACE;
    private PolygonObj triangle;
    private TextObj centerLabel;
    private double width;
    private int height;
    private transient TreeNode node = null;

    public TreeSymbol(DPair pos) {
        this(pos, 2);
    }

    public TreeSymbol(DPair pos, int height) {
        this(pos, height, DEFAULT_TEXT);
    }

    public TreeSymbol(DPair pos, int height, String c) {
        this(pos, height, c, 0.1);
    }

    public TreeSymbol(DPair pos, int height, String c, double width) {
        this.height = height;
        this.width = width;
        Vector<DPair> tmp = new Vector<DPair>();
        tmp.addElement(new DPair(0.0, 0.0));
        tmp.addElement(new DPair(width / 2.0, this.LEVEL_SPACE * (double)height));
        tmp.addElement(new DPair(-width / 2.0, this.LEVEL_SPACE * (double)height));
        this.triangle = new PolygonObj(tmp);
        this.triangle.setFillColorTrans(Color.white);
        this.triangle.setFilledTrans(true);
        this.addItem(this.triangle, 0);
        this.centerLabel = new TextObj(c, new DPair(0.0, this.LEVEL_SPACE * (double)height - 0.01), FONT_SIZE);
        this.addItem(this.centerLabel);
        this.setPosTrans(pos);
    }

    public double getLeftDistance() {
        return this.width / 2.0;
    }

    public double getRightDistance() {
        return this.width / 2.0;
    }

    public void setHighlight(boolean b) {
        if (b) {
            this.triangle.setFillColor(new Color(0xFFAAAA));
        } else {
            this.triangle.setFillColor(Color.white);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setTreeNode(TreeNode node) {
        this.node = node;
    }

    public TreeNode getTreeNode() {
        return this.node;
    }
}

