/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees.fheap;

import java.awt.Color;
import java.util.Vector;
import jedas.CompObj;
import jedas.DPair;
import jedas.Item;
import jedas.Jedas;
import jedas.LineObj;
import jedas.Path;
import jedas.PlineObj;
import jedas.Scheduler;
import jedas.TextObj;
import jedas.Trans;
import jedas.trees.fheap.ArrayObj;
import jedas.trees.fheap.FibNode;

public class FibHeap
extends CompObj {
    private FibNode min;
    private int size;
    private int potential;
    private int count;
    private LineObj minPointer;
    private LineObj rootList;
    private ArrayObj array;
    private transient Scheduler scheduler;
    static double nodePosX = 0.075;
    static double nodePosY = 0.25;
    static double pointerY = nodePosY - 0.08;
    private static DPair initialPointerPos1 = new DPair(nodePosX, pointerY);
    private static DPair initialPointerPos2 = new DPair(nodePosX, pointerY + 0.04);
    private static DPair initialNodePos = new DPair(nodePosX, nodePosY);
    private static DPair messagePos0 = new DPair(0.5, 0.85);
    private static DPair messagePos1 = new DPair(0.5, 0.9);
    private static DPair messagePos2 = new DPair(0.5, 0.95);
    static long pointerSpeed = 200L;
    static long ENTRYTIME = 300L;
    static long pauseLength = 500L;
    static Color conflict = Color.red;
    public static final int NONE = 0;
    public static final int NORMAL = 1;
    public static final int MORE = 2;
    public static final int DETAIL = 4;
    static boolean quickAnim = false;
    static boolean keyColorMode = true;
    static int textMode = 2;
    private TextObj[] message;

    public FibHeap(Scheduler scheduler) {
        this.min = null;
        this.potential = 0;
        this.size = 0;
        this.scheduler = scheduler;
        this.minPointer = new LineObj(initialPointerPos1, initialPointerPos2, Color.blue, 2, 2, Color.blue);
        this.rootList = new LineObj(new DPair(-1.0, nodePosY), new DPair(2.0, nodePosY), Color.black);
        this.addItem(this.minPointer);
        this.minPointer.setPos(initialPointerPos1);
        this.addItem(this.rootList);
        this.message = new TextObj[3];
        this.message[0] = new TextObj("New Fibonacci Heap", messagePos0, 14, 0, 0, Color.black);
        this.message[1] = new TextObj("", messagePos1, 13, 0, 0, Color.red);
        this.message[2] = new TextObj("", messagePos2, 12, 0, 0, Color.blue);
        this.addItem(this.message[0]);
        this.addItem(this.message[1]);
        this.addItem(this.message[2]);
    }

    private FibHeap(int k, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.min = new FibNode(k, scheduler);
        this.potential = 1;
        this.size = 1;
    }

    private FibHeap(FibNode existing) {
        this.potential = 0;
        this.size = 0;
        this.min = existing;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void meld(FibHeap other) {
        if (textMode > 2) {
            this.showText("Merging F-heaps", 1);
        }
        if (!this.isEmpty() && !other.isEmpty()) {
            this.min.join(other.min, false);
            if (other.min.getKey() < this.min.getKey()) {
                this.updateMin(other.min);
            }
        } else if (this.isEmpty()) {
            this.updateMin(other.min);
            this.size = other.getHeapSize();
        }
        this.size += other.getHeapSize();
        this.potential += other.potential;
        ++this.count;
    }

    public FibNode insert(int k) {
        if (textMode > 0) {
            this.showText("insert(" + k + ")", 0);
        }
        this.resetCount();
        if (textMode > 2) {
            this.showText("Creating new F-heap", 1);
        }
        FibHeap q = new FibHeap(k, this.scheduler);
        this.transferItem(q.min);
        DPair pos = this.isEmpty() ? initialNodePos : new DPair(this.min.getPos().get(0) + (double)this.min.getTreeWidth() * FibNode.DISTANCE, nodePosY - FibNode.DISTANCE);
        q.min.setPos(pos);
        q.min.fPos = pos;
        q.min.appear();
        if (!this.isEmpty()) {
            this.min.makeRoomFor(q.min);
        }
        if (!quickAnim) {
            this.animate();
        }
        this.meld(q);
        this.animate();
        return q.min;
    }

    public int accessmin() {
        if (this.isEmpty()) {
            if (textMode > 2) {
                this.showText("F-heap empty", 2);
            }
            return 999;
        }
        if (textMode > 2) {
            this.showText("Minimum key is " + this.min.getKey(), 2);
        }
        return this.min.getKey();
    }

    public int deletemin() {
        if (textMode > 0) {
            this.showText("deletemin()", 0);
        }
        this.resetCount();
        int m = this.accessmin();
        if (!this.isEmpty()) {
            this.min.focus();
            this.remove(this.min);
            if (!this.isEmpty()) {
                this.consolidate();
            } else {
                this.min = null;
            }
        }
        return m;
    }

    private void remove(FibNode node) {
        if (textMode > 1) {
            this.showText("Removing node", 1);
        }
        --this.size;
        --this.potential;
        if (node == this.min) {
            FibNode nextmin = !this.isEmpty() ? (this.min.getRightSibling() != this.min ? this.min.getRightSibling() : this.min.getChildNode()) : null;
            this.updateMin(nextmin);
        }
        node.delete();
        this.animate();
        node.hide();
    }

    protected void consolidate() {
        if (textMode > 1) {
            this.showText("Consolidating root list", 1);
        }
        int length = this.maxRank() + 1;
        if (textMode > 1) {
            this.showText("Creating rank array with size " + length, 2);
        }
        FibNode[] A = new FibNode[length];
        this.count += length;
        this.array = new ArrayObj(length);
        this.addItem(this.array);
        FibNode B = this.min;
        FibNode last = this.min.getLeftSibling();
        while (B != last) {
            FibNode next = B.getRightSibling();
            this.enter(B, A);
            B = next;
            if (B.getKey() >= this.accessmin()) continue;
            this.updateMin(B);
        }
        this.enter(B, A);
        this.pause(pauseLength);
        this.array.hide();
        this.deleteItem(this.array);
        int j = 0;
        while (j < length) {
            if (A[j] != null) {
                A[j].line.hide();
                this.deleteItem(A[j].line);
                A[j].line = new LineObj();
                A[j].line.hide();
                this.transferItem(A[j].line);
            }
            ++j;
        }
        Jedas.updateDisplay();
    }

    private void enter(FibNode B, FibNode[] A) {
        if (textMode > 1) {
            this.showText("Entering node with rank " + B.getRank(), 2);
        }
        this.drawLine(B);
        if (A[B.getRank()] == null) {
            if (textMode > 2) {
                this.showText("Entered node " + B.getKey() + " in array", 2);
            }
            A[B.getRank()] = B;
        } else {
            if (textMode > 2) {
                this.showText("Array position occupied", 2);
            }
            int index = B.getRank();
            B = this.link(B, A[B.getRank()]);
            this.animate();
            A[index] = null;
            this.enter(B, A);
        }
    }

    private FibNode link(FibNode B, FibNode C) {
        if (textMode > 1) {
            this.showText("Linking nodes " + B.getKey() + " and " + C.getKey(), 2);
        }
        B.line.setColor(conflict);
        C.line.setColor(conflict);
        B.focus();
        C.focus();
        this.animate();
        this.removeLines(B, C);
        if (C.getKey() < B.getKey()) {
            FibNode temp = C;
            C = B;
            B = temp;
        }
        if (C.isMarked() && textMode > 1) {
            this.showText("Un-marking node " + C.getKey(), 2);
        }
        C.unmark();
        B.addChild(C);
        ++this.count;
        return B;
    }

    public void decreasekey(FibNode N, int k) {
        this.resetCount();
        if (k < N.getKey() && k > 0) {
            if (textMode > 0) {
                this.showText("decreasekey(" + N.getKey() + ", " + k + ")", 0);
            }
            N.focus();
            this.animate();
            N.setKey(k);
            Jedas.updateDisplay();
        }
        FibNode temp = N;
        if (N.isRoot() || k >= N.getParentNode().getKey()) {
            ++this.count;
        } else {
            FibNode parent;
            do {
                parent = N.getParentNode();
                if (temp.getKey() < this.accessmin() && N != temp) {
                    this.updateMin(temp);
                }
                this.animate();
                if (textMode > 1) {
                    this.showText("Cutting node " + N.getKey(), 1);
                }
                N.cut(this.min);
                ++this.potential;
                if (N.isMarked()) {
                    this.potential -= 2;
                }
                ++this.count;
            } while ((N = parent).isMarked() && !N.isRoot());
            if (!N.isRoot()) {
                if (textMode > 1) {
                    this.showText("Marking node " + N.getKey(), 2);
                }
                N.mark();
                this.potential += 2;
            }
            this.animate();
        }
        if (temp.getKey() < this.accessmin()) {
            this.updateMin(temp);
        }
    }

    public int delete(FibNode node) {
        this.resetCount();
        if (node == this.min) {
            return this.deletemin();
        }
        if (textMode > 0) {
            this.showText("delete( " + node.getKey() + ")", 0);
        }
        node.focus();
        this.animate();
        if (!node.isRoot()) {
            FibNode parent;
            FibNode temp = node;
            do {
                parent = temp.getParentNode();
                this.animate();
                if (textMode > 1) {
                    this.showText("Cutting node " + temp.getKey(), 1);
                }
                temp.cut(this.min);
                ++this.count;
                ++this.potential;
                if (!temp.isMarked()) continue;
                this.potential -= 2;
            } while ((temp = parent).isMarked() && !temp.isRoot());
            if (!temp.isRoot()) {
                if (textMode > 1) {
                    this.showText("Marking node " + temp.getKey(), 2);
                }
                temp.mark();
            }
        } else {
            ++this.count;
        }
        this.animate();
        this.remove(node);
        return node.getKey();
    }

    public int getHeapSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }

    public boolean getKeyColorMode() {
        return keyColorMode;
    }

    public void setKeyColorMode(boolean b) {
        keyColorMode = b;
    }

    public void setTextMode(int mode) {
        textMode = mode;
    }

    public int maxRank() {
        if (this.isEmpty()) {
            return 0;
        }
        return (int)(1.4404 * Math.log(this.size) / Math.log(2.0));
    }

    private void updateMin(FibNode newMinNode) {
        if (textMode > 2) {
            this.showText("Setting minimum pointer to " + newMinNode.getKey(), 2);
        }
        if (newMinNode != null && this.min != null) {
            this.scheduler.start();
            this.transferItem(this.minPointer);
            DPair source = this.min.getRootPos();
            source.set(1, pointerY);
            DPair target = newMinNode.getRootPos();
            target.set(1, pointerY);
            Path p = new Path();
            p.createDistance(source, target, pointerSpeed);
            Trans t = new Trans((Item)this.minPointer, p, 2);
            this.scheduler.add(t);
        } else if (newMinNode == null) {
            this.transferItem(this.minPointer);
            this.minPointer.setPos(initialPointerPos1);
        }
        this.min = newMinNode;
        this.scheduler.start();
        if (this.min != null) {
            System.out.println(this.minPointer.getParent() + "  " + this.minPointer.getPos());
            this.min.addPointer(this.minPointer);
            System.out.println(this.minPointer.getParent() + "  " + this.minPointer.getPos());
        }
    }

    private void drawLine(FibNode node) {
        Vector<DPair> vector = new Vector<DPair>();
        DPair[] geometry = new DPair[]{node.getRootPos(), new DPair(node.getRootPos().get(0), nodePosY - 0.05 - 0.01 * (double)node.getRank()), new DPair(this.array.getPosition(node.getRank()).get(0), nodePosY - 0.05 - 0.01 * (double)node.getRank()), this.array.getPosition(node.getRank())};
        Path[] p = new Path[4];
        int i = 0;
        while (i < 4) {
            vector.addElement(node.getRootPos());
            p[i] = new Path();
            p[i].createDistance((DPair)vector.elementAt(i), geometry[i], ENTRYTIME);
            ++i;
        }
        node.line = new PlineObj(vector, Color.gray, 2);
        this.transferItem(node.line);
        this.lowerItem(node.line);
        node.line.show();
        Trans t = new Trans((Item)node.line, p, 7);
        this.scheduler.add(t);
        this.scheduler.start();
    }

    private void removeLines(FibNode node1, FibNode node2) {
        node1.line.hide();
        this.deleteItem(node1.line);
        node1.line = new LineObj();
        node1.line.hide();
        this.transferItem(node1.line);
        node2.line.hide();
        this.deleteItem(node2.line);
        node2.line = new LineObj();
        this.transferItem(node2.line);
        node2.line.hide();
    }

    private void animate() {
        this.scheduler.start();
    }

    private void pause(long time) {
        Path p = new Path();
        p.createNull(time, 1);
        Trans pause = new Trans((Item)this.rootList, p, 5);
        this.scheduler.add(pause);
        this.scheduler.start();
    }

    private void showText(String text, int level) {
        if (level == 0) {
            text = "Current operation:  " + text;
        }
        this.message[level].setText(text);
        this.message[level].setVisible(true);
    }
}

