/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees.fheap;

import jedas.CompObj;
import jedas.DPair;
import jedas.DTriple;
import jedas.Item;
import jedas.LineObj;
import jedas.Path;
import jedas.PlineObj;
import jedas.Scheduler;
import jedas.Trans;
import jedas.trees.NodeItem;
import jedas.trees.fheap.FibNodeObj;

public class FibNode
extends CompObj {
    private FibNodeObj nodeObj;
    PlineObj line;
    private transient Scheduler scheduler;
    DPair fPos;
    private DPair[] geometry;
    private int orientation;
    private static double amplitude;
    private FibNode left;
    private FibNode right;
    private FibNode parent;
    private FibNode child;
    private int key;
    private int rank;
    private boolean mark;
    static DTriple unmarkColor;
    static DTriple appearColor;
    static DTriple flashColor;
    static DTriple markColor;
    static DTriple drawColor;
    static long FLASHTIME;
    static long MOVETIME;
    static long MARKTIME;
    static double DISTANCE;
    static double NODESIZE;
    static boolean keycolor;
    static int flashNum;

    public FibNode(int key, Scheduler scheduler) {
        this.key = key;
        this.left = this.right = this;
        this.scheduler = scheduler;
        this.nodeObj = new FibNodeObj(new DPair(0.0, 0.0), "" + key);
        this.line = new LineObj();
        this.line.hide();
        this.addItem(this.nodeObj);
        this.fPos = (DPair)this.getPos().clone();
        this.geometry = new DPair[2];
        this.hide();
    }

    private FibNode() {
        this.key = 0;
        this.left = this.right = this;
    }

    public FibNode getParentNode() {
        if (this.isRoot()) {
            return null;
        }
        return this.parent;
    }

    public FibNode getChildNode() {
        return this.child;
    }

    public FibNode getSibling() {
        if (this.right == this) {
            return null;
        }
        return this.right;
    }

    public FibNode getRightSibling() {
        return this.right;
    }

    public FibNode getLeftSibling() {
        return this.left;
    }

    public int getRank() {
        return this.rank;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int k) {
        this.key = k;
        DTriple oldcolor = this.getUnmarkColor();
        this.nodeObj.setCenterLabel(k + "");
        if (!this.isMarked()) {
            Path p = new Path();
            p.createDistance(oldcolor, this.getUnmarkColor(), MARKTIME);
            Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
            this.scheduler.add(t);
        }
    }

    public boolean getColorMode() {
        return keycolor;
    }

    public void setColorMode(boolean b) {
        keycolor = b;
    }

    public boolean isRoot() {
        return this.parent == null || this.parent.child == null;
    }

    public boolean hasChildren() {
        return this.rank > 0;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public void mark() {
        if (!this.mark) {
            this.mark = true;
            Path p = new Path();
            p.createDistance(this.getUnmarkColor(), markColor, MARKTIME);
            Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
            this.scheduler.add(t);
        }
    }

    public void unmark() {
        if (this.mark) {
            this.mark = false;
            Path p = new Path();
            p.createDistance(markColor, this.getUnmarkColor(), MARKTIME);
            Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
            this.scheduler.add(t);
        }
    }

    public void focus() {
        this.flash(flashNum);
    }

    public void appear() {
        this.show();
        Path sizePath = new Path();
        sizePath.createDistance(new DPair(0.0, 0.0), new DPair(NODESIZE, NODESIZE), MARKTIME);
        Trans sizeTrans = new Trans((Item)this.nodeObj.oval, sizePath, 4);
        Path colorPath = new Path();
        colorPath.createDistance(appearColor, this.getUnmarkColor(), MOVETIME);
        Trans colorTrans = new Trans((Item)this.nodeObj.oval, colorPath, 6);
        Path movePath = new Path();
        movePath.createDistance(new DPair(0.0, 0.0), new DPair(-NODESIZE / 2.0, -NODESIZE / 2.0), MARKTIME);
        Trans moveTrans = new Trans((Item)this.nodeObj.oval, movePath, 2);
        Path textcolor = new Path();
        textcolor.createDistance(unmarkColor, drawColor, MARKTIME);
        Trans colorTrans2 = new Trans((Item)this.nodeObj.centerLabel, textcolor, 8);
        this.scheduler.add(moveTrans);
        this.scheduler.add(sizeTrans);
        this.scheduler.add(colorTrans);
        this.scheduler.add(colorTrans2);
    }

    public void disappear() {
        Path sizePath = new Path();
        sizePath.createDistance(new DPair(NODESIZE, NODESIZE), new DPair(0.0, 0.0), MARKTIME);
        Trans sizeTrans = new Trans((Item)this.nodeObj.oval, sizePath, 4);
        Path colorPath = new Path();
        DTriple color = unmarkColor;
        if (this.isMarked()) {
            color = markColor;
        }
        colorPath.createDistance(color, appearColor, MOVETIME);
        Trans colorTrans = new Trans((Item)this.nodeObj.oval, colorPath, 6);
        Path movePath = new Path();
        movePath.createDistance(new DPair(-NODESIZE / 2.0, -NODESIZE / 2.0), new DPair(0.0, 0.0), MARKTIME);
        Trans moveTrans = new Trans((Item)this.nodeObj.oval, movePath, 2);
        Path textcolor = new Path();
        textcolor.createDistance(drawColor, unmarkColor, MARKTIME);
        Trans colorTrans2 = new Trans((Item)this.nodeObj.centerLabel, textcolor, 8);
        this.scheduler.add(moveTrans);
        this.scheduler.add(sizeTrans);
        this.scheduler.add(colorTrans);
        this.scheduler.add(colorTrans2);
    }

    public void addChild(FibNode newChild) {
        int dist = newChild.getTreeWidth();
        if (!this.hasChildren()) {
            FibNode moveNode = newChild.right;
            while (!moveNode.isLeftmost()) {
                moveNode.pullLeft(dist);
                moveNode = moveNode.right;
            }
        } else if (this.isLeftOf(newChild)) {
            FibNode moveNode = this.right;
            while (moveNode != newChild) {
                moveNode.pushRight(dist);
                moveNode = moveNode.right;
            }
        } else {
            FibNode moveNode = newChild.right;
            while (moveNode != this.right) {
                moveNode.pullLeft(dist);
                moveNode = moveNode.right;
            }
        }
        newChild.separate(false);
        newChild.parent = this;
        this.transferItem(newChild);
        DPair trans = new DPair(newChild.getPos().get(0) - this.getPos().get(0), 0.0);
        newChild.setPos(trans);
        newChild.fPos = trans;
        if (this.hasChildren()) {
            this.child.left.join(newChild, false);
        } else {
            this.child = newChild;
            this.child.fPos = new DPair(0.0, DISTANCE);
            Path p = new Path();
            this.orientation = this.child.getPos().get(0) < this.child.fPos.get(0) ? 0 : (this.child.getPos().get(0) == this.child.fPos.get(0) ? 0 : 0);
            amplitude = 0.1;
            p.createMotion(this.child.getPos(), this.child.fPos, this.orientation, amplitude, MOVETIME);
            Trans t = new Trans((Item)this.child, p, 2);
            this.scheduler.add(t);
            this.transferItem(newChild.line);
            this.geometry[0] = newChild.getPos();
            this.geometry[1] = new DPair(0.0, 0.0);
            newChild.line.setGeometry(this.geometry);
            newChild.line.show();
            this.lowerItem(newChild.line);
        }
        ++this.rank;
        this.centerNode();
    }

    /*
     * Unable to fully structure code
     */
    public void cut(FibNode target) {
        block2: {
            block3: {
                if (this.isRoot()) break block2;
                isOnlyChild = this.parent.rank == 1 && this.getTreeWidth() == 1;
                temp = this.getRoot();
                this.separate(isOnlyChild == false);
                this.line.hide();
                this.transferItem(this.line);
                if (isOnlyChild) break block3;
                if (!temp.isLeftOf(target)) ** GOTO lbl16
                while (temp.isLeftOf(target)) {
                    temp = temp.right;
                    temp.pullLeft(this.getTreeWidth());
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    temp.pushRight(this.getTreeWidth());
                    temp = temp.left;
lbl16:
                    // 2 sources

                    ** while (target.isLeftOf((FibNode)temp))
                }
            }
            target.join(this, isOnlyChild);
        }
    }

    private void separate(boolean thereIsGap) {
        if (!this.isRoot()) {
            --this.parent.rank;
            if (!this.parent.hasChildren()) {
                this.parent.child = null;
                this.parent.centerNode();
            } else if (this.parent.child == this) {
                this.parent.child = this.right;
            }
        }
        if (thereIsGap) {
            this.closeGap();
        }
        this.left.right = this.right;
        this.right.left = this.left;
        this.left = this;
        this.right = this;
        if (!this.isRoot()) {
            this.parent.centerNode();
        }
        this.parent = null;
    }

    public void join(FibNode other, boolean spaceNeeded) {
        if (spaceNeeded) {
            this.makeRoomFor(other);
        }
        this.moveHere(other);
        this.right.left = other.left;
        other.left.right = this.right;
        this.right = other;
        other.left = this;
        if (!this.isRoot() && this.getParent() != null) {
            this.getParent().transferItem(other.line);
            this.geometry[0] = other.getRootPos();
            this.geometry[1] = ((FibNode)this.getParent()).nodeObj.getPos();
            other.line.setGeometry(this.geometry);
            other.line.show();
            this.getParent().lowerItem(other.line);
        } else if (this.getParent() == null) {
            System.out.println("Error! -- No parent found!");
            System.exit(0);
        }
    }

    public void delete() {
        if (this.isRoot()) {
            this.line.hide();
            this.transferItem(this.line);
            this.liftUp();
            this.scheduler.start();
            if (this.hasChildren()) {
                if (this.left != this) {
                    this.left.right = this.child;
                    this.right.left = this.child.left;
                    this.child.left.right = this.right;
                    this.child.left = this.left;
                    this.left = this.right = this;
                }
                this.transferChildren();
            } else {
                this.separate(true);
            }
            this.child = null;
            this.disappear();
        }
    }

    public DPair getRootPos() {
        double x = this.getPos().get(0);
        double y = this.getPos().get(1);
        return new DPair(x += this.nodeObj.getPos().get(0), y += this.nodeObj.getPos().get(1));
    }

    public void addPointer(LineObj item) {
        this.nodeObj.transferItem(item);
        item.setPos(new DPair(0.0, -0.08));
    }

    public int getTreeWidth() {
        int width = 1;
        if (this.child != null) {
            FibNode temp = this.child.right;
            width = this.child.getTreeWidth();
            while (temp != this.child) {
                width += temp.getTreeWidth();
                temp = temp.right;
            }
        }
        return width;
    }

    private int getListWidth() {
        int width = 0;
        FibNode temp = this;
        do {
            width += temp.getTreeWidth();
            temp = temp.right;
        } while (temp.right != this);
        return width;
    }

    public NodeItem getNodeItem() {
        return this.nodeObj;
    }

    private FibNode[] getChildlist() {
        if (!this.hasChildren()) {
            return null;
        }
        FibNode[] childlist = new FibNode[this.rank];
        FibNode temp = this.child;
        int i = 0;
        while (i < this.rank) {
            childlist[i] = temp;
            temp = temp.right;
            ++i;
        }
        return childlist;
    }

    public int getTreeDepth() {
        if (this.child == null) {
            return 1;
        }
        int depth = 0;
        FibNode temp = this.child;
        do {
            if (temp.getTreeDepth() <= depth) continue;
            depth = temp.getTreeDepth();
        } while ((temp = temp.right) != this.child);
        return depth + 1;
    }

    public int getTreeSize() {
        int size = 1;
        if (this.hasChildren()) {
            FibNode temp = this.child;
            do {
                size += temp.getTreeSize();
            } while ((temp = temp.right) != this.child);
        }
        return size;
    }

    public int getDepth() {
        int depth = 1;
        FibNode temp = this;
        while (!temp.isRoot()) {
            ++depth;
            temp = temp.parent;
        }
        return depth;
    }

    public FibNode getRoot() {
        FibNode temp = this;
        while (!temp.isRoot()) {
            temp = temp.parent;
        }
        return temp;
    }

    public void makeRoomFor(FibNode inserted) {
        FibNode toMove = this;
        while (!toMove.isRoot()) {
            toMove = toMove.parent;
        }
        toMove = toMove.right;
        while (!toMove.isLeftmost()) {
            toMove.pushRight(inserted.getListWidth());
            toMove = toMove.right;
        }
    }

    private void closeGap() {
        int dist = this.getTreeWidth();
        FibNode temp = this;
        do {
            temp = temp.right;
            while (!temp.isLeftmost()) {
                temp.pullLeft(dist);
                temp = temp.right;
            }
            if (temp.isRoot()) continue;
            temp = temp.parent;
        } while (!temp.isRoot());
    }

    private void pushRight(int dist) {
        this.fPos = new DPair(this.getPos().get(0) + (double)dist * DISTANCE, this.getPos().get(1));
        Path p = new Path();
        p.createDistance(this.getPos(), this.fPos, MOVETIME);
        Trans t = new Trans((Item)this, p, 2);
        this.scheduler.add(t);
        if (this.isRoot() && this.line.isVisible()) {
            DPair[] geometry = new DPair[]{this.getCenterPos(), new DPair(this.getCenterPos().get(0), this.fPos.get(1) - 0.05 - 0.01 * (double)this.getRank()), this.line.getGeometry()[2], this.line.getGeometry()[3]};
            Path[] pl = new Path[4];
            int i = 0;
            while (i < 4) {
                pl[i] = new Path();
                pl[i].createDistance(this.line.getGeometry()[i], geometry[i], MOVETIME);
                ++i;
            }
            Trans tl = new Trans((Item)this.line, pl, 7);
            this.scheduler.add(tl);
        }
    }

    private void pullLeft(int dist) {
        this.fPos = new DPair(this.getPos().get(0) - (double)dist * DISTANCE, this.getPos().get(1));
        Path p = new Path();
        p.createDistance(this.getPos(), this.fPos, MOVETIME);
        Trans t = new Trans((Item)this, p, 2);
        this.scheduler.add(t);
        if (this.isRoot() && this.line.isVisible()) {
            DPair[] geometry = new DPair[]{this.getCenterPos(), new DPair(this.getCenterPos().get(0), this.fPos.get(1) - 0.05 - 0.01 * (double)this.getRank()), this.line.getGeometry()[2], this.line.getGeometry()[3]};
            Path[] pl = new Path[4];
            int i = 0;
            while (i < 4) {
                pl[i] = new Path();
                pl[i].createDistance(this.line.getGeometry()[i], geometry[i], MOVETIME);
                ++i;
            }
            Trans tl = new Trans((Item)this.line, pl, 7);
            this.scheduler.add(tl);
        }
    }

    private void liftUp() {
        this.fPos = new DPair(this.getPos().get(0), this.getPos().get(1) - DISTANCE);
        Path p = new Path();
        p.createDistance(this.getPos(), this.fPos, MOVETIME);
        Trans t = new Trans((Item)this, p, 2);
        this.scheduler.add(t);
    }

    private Trans lineTrans(int dist) {
        Path p = new Path();
        p.createDistance(this.line.getPos(), new DPair(this.line.getPos().get(0) + (double)dist * DISTANCE, this.line.getPos().get(1)), MOVETIME);
        return new Trans((Item)this.line, p, 2);
    }

    private void moveHere(FibNode node) {
        if (this.getParent() != node.getParent()) {
            this.transPos(node);
        }
        node.fPos = new DPair(this.fPos.get(0) + DISTANCE * (double)this.getTreeWidth(), this.fPos.get(1));
        Path p = new Path();
        this.orientation = Math.abs(node.getPos().get(0) - node.fPos.get(0)) < DPair.epsilon ? 0 : (node.getPos().get(0) < node.fPos.get(0) ? 0 : 0);
        amplitude = 0.3;
        p.createMotion(node.getPos(), node.fPos, this.orientation, amplitude, MOVETIME);
        Trans t = new Trans((Item)node, p, 2);
        this.scheduler.add(t);
    }

    private boolean isLeftmost() {
        return this.getPos().get(0) <= this.left.getPos().get(0);
    }

    private void transPos(FibNode node) {
        node.fPos = (DPair)node.getPos().clone();
        CompObj commonParent = (CompObj)node.getParent();
        while (commonParent != this.getParent() && commonParent.getParent() != null) {
            node.fPos.set(0, node.fPos.get(0) + commonParent.getPos().get(0));
            node.fPos.set(1, node.fPos.get(1) + commonParent.getPos().get(1));
            commonParent = (CompObj)commonParent.getParent();
        }
        if (commonParent != this.getParent()) {
            System.out.println("Error occurred while transposing.");
            System.exit(0);
        }
        commonParent.transferItem(node);
        node.setPos(node.fPos);
    }

    private void transferChildren() {
        if (this.hasChildren()) {
            FibNode temp = this.child;
            do {
                this.transPos(temp);
                temp.line.hide();
            } while ((temp = temp.right) != this.child);
        }
    }

    private void centerNode() {
        if (this.rank > 0) {
            FibNode temp = this.getChildlist()[this.rank / 2];
            DPair centerPos = (DPair)this.nodeObj.getPos().clone();
            double p1 = temp.getCenterPos().get(0);
            if (this.rank % 2 == 0) {
                p1 = (p1 + temp.left.getCenterPos().get(0)) / 2.0;
            }
            centerPos.set(0, p1);
            Path p = new Path();
            p.createDistance(this.nodeObj.getPos(), centerPos, MOVETIME);
            Trans t = new Trans((Item)this.nodeObj, p, 2);
            this.scheduler.add(t);
            temp = this.child;
            do {
                temp.adjustLine(centerPos);
            } while ((temp = temp.right) != this.child);
        } else if (Math.abs(this.nodeObj.getPos().get(0)) > DPair.epsilon) {
            Path p = new Path();
            p.createDistance(this.nodeObj.getPos(), new DPair(0.0, 0.0), MOVETIME);
            Trans t = new Trans((Item)this.nodeObj, p, 2);
            this.scheduler.add(t);
        }
        if (!this.isRoot()) {
            this.parent.centerNode();
        }
    }

    private void adjustLine(DPair pos) {
        this.geometry[0] = this.getCenterPos();
        this.geometry[1] = pos;
        Path[] p = new Path[]{new Path(), new Path()};
        int orientation = Math.abs(this.line.getGeometry()[0].get(0) - this.geometry[1].get(0)) < DPair.epsilon ? 0 : (this.line.getGeometry()[0].get(0) < this.geometry[1].get(0) ? 0 : 0);
        p[0].createDistance(this.line.getGeometry()[0], this.geometry[0], MOVETIME);
        p[1].createMotion(this.line.getGeometry()[1], this.geometry[1], orientation, amplitude, MOVETIME);
        Trans t = new Trans((Item)this.line, p, 7);
        this.scheduler.add(t);
    }

    private DPair getCenterPos() {
        DPair centerPos = (DPair)this.fPos.clone();
        if (this.rank > 0) {
            FibNode temp = this.getChildlist()[this.rank / 2];
            double p1 = temp.getCenterPos().get(0);
            if (this.rank % 2 == 0) {
                p1 = (p1 + temp.left.getCenterPos().get(0)) / 2.0;
            }
            centerPos.set(0, centerPos.get(0) + p1);
        }
        return centerPos;
    }

    private DPair adjustCoord(Item item) {
        CompObj par;
        boolean found = false;
        double x = item.getPos().get(0);
        double y = item.getPos().get(1);
        if (item.getParent() != null) {
            par = (CompObj)item.getParent();
        } else {
            System.out.println("Error -- item has no parent!");
            par = this;
            System.exit(0);
        }
        while (par.getParent() != null) {
            if (par != this) {
                par = (CompObj)par.getParent();
                x += par.getPos().get(0);
                y += par.getPos().get(1);
                continue;
            }
            found = true;
        }
        if (!found) {
            par = (CompObj)this.getParent();
            double myX = this.fPos.get(0);
            double myY = this.fPos.get(1);
            while (par.getParent() != null) {
                par = (CompObj)par.getParent();
                myX += par.getPos().get(0);
                myY += par.getPos().get(1);
            }
            x -= myX;
            y -= myY;
        }
        return new DPair(x, y);
    }

    private boolean isLeftOf(FibNode other) {
        return this.getPos().get(0) < other.getPos().get(0);
    }

    private void flash(int times) {
        DTriple currentColor = this.getUnmarkColor();
        if (this.isMarked()) {
            currentColor = markColor;
        }
        Path p = new Path();
        int i = 0;
        while (i < times) {
            p.createDistance(currentColor, flashColor, FLASHTIME);
            p.createDistance(flashColor, currentColor, FLASHTIME);
            ++i;
        }
        Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
        this.scheduler.add(t);
    }

    private DTriple getUnmarkColor() {
        if (!keycolor) {
            return new DTriple(1.0, 1.0, 1.0);
        }
        return new DTriple(0.5 + (100.0 - (double)this.key) / 200.0, 0.5 + (100.0 - (double)this.key) / 200.0, 1.0);
    }

    static {
        unmarkColor = new DTriple(1.0, 1.0, 1.0);
        appearColor = new DTriple(0.0, 0.0, 1.0);
        flashColor = new DTriple(1.0, 0.0, 0.0);
        markColor = new DTriple(1.0, 0.7, 0.7);
        drawColor = new DTriple(0.0, 0.0, 0.0);
        FLASHTIME = 220L;
        MOVETIME = 600L;
        MARKTIME = 300L;
        DISTANCE = 0.1;
        NODESIZE = 0.06;
        keycolor = true;
        flashNum = 1;
    }
}

