/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;

public class DisplayBar
extends Panel {
    private int maxValue;
    private int value;
    private boolean showText;
    private Color barColor;
    private boolean percent;
    private String suffix;
    private Color textColor;
    private double[] addDisp;
    private Color[] addDispColor;

    public DisplayBar(int maxValue, int value) {
        this(maxValue, value, true, Color.blue);
    }

    public DisplayBar(int maxValue, int value, boolean showText, Color barColor) {
        this(maxValue, value, showText, barColor, false, null);
    }

    public DisplayBar(int maxValue, int value, boolean showText, Color barColor, boolean percent, String suffix) {
        this.maxValue = maxValue;
        this.value = value;
        this.showText = showText;
        this.barColor = barColor;
        this.percent = percent;
        this.suffix = suffix == null ? "" : suffix;
        this.textColor = Color.white;
        this.addDisp = null;
        this.addDispColor = null;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setValue(int value) {
        this.value = value;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void setShowText(boolean b) {
        this.showText = b;
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void setBarColor(Color barColor) {
        this.barColor = barColor;
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.repaint();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setShowPercent(boolean b) {
        this.percent = b;
    }

    public boolean getShowPercent() {
        return this.percent;
    }

    public void setTextSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getTextSuffix() {
        return this.suffix;
    }

    public void setAdditionalDisplay(double[] values, Color[] colors) {
        this.addDisp = values;
        this.addDispColor = colors;
    }

    public void paint(Graphics g) {
        int xs = this.getSize().width - 1;
        int ys = this.getSize().height - 1;
        g.setColor(Color.lightGray);
        g.draw3DRect(0, 0, xs, ys, true);
        g.draw3DRect(2, 2, xs - 4, ys - 4, false);
        g.setColor(this.barColor);
        int ds = (int)((1.0 * (double)xs - 8.0) * (1.0 * (double)this.value / (double)this.maxValue));
        g.fillRect(4, 4, ds, ys - 8);
        if (this.addDisp != null) {
            int i = 0;
            while (i < this.addDisp.length) {
                int dsAdd = (int)((1.0 * (double)xs - 8.0) * (this.addDisp[i] / (double)this.maxValue)) - 1;
                if (this.addDispColor == null) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(this.addDispColor[i]);
                }
                g.fillRect(4 + dsAdd, 4, 2, ys - 8);
                ++i;
            }
        }
        if (this.showText) {
            g.setColor(this.textColor);
            if (!this.percent) {
                g.drawString("" + this.value + this.suffix, xs / 2 - 7, ys / 2 + 6);
            } else {
                int pc = (int)(100.0 * (double)this.value / (double)this.maxValue);
                g.drawString("" + pc + this.suffix, xs / 2 - 7, ys / 2 + 6);
            }
        }
    }
}

