/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.applet.Applet;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jedas.Jedas;

public class ImageLoader {
    private ZipFile archive = null;

    public static String checkPath(String path) {
        if (path.length() > 0 && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public void getArchive() {
        String archivename = "jedas201.jar";
        this.archive = null;
        String classPath = System.getProperty("java.class.path");
        String ps = System.getProperty("path.separator");
        StringTokenizer tok = new StringTokenizer(classPath, ps);
        while (tok.hasMoreTokens()) {
            String curPath = tok.nextToken().trim();
            if (curPath.endsWith(archivename)) {
                try {
                    this.archive = new ZipFile(curPath);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.archive != null) continue;
            try {
                curPath = ImageLoader.checkPath(curPath);
                this.archive = new ZipFile(curPath + archivename);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.archive == null) {
            try {
                this.archive = new ZipFile(archivename);
            }
            catch (IOException e) {
                this.archive = null;
            }
        }
        if (this.archive == null) {
            System.err.println("getArchive: Could not find jedas201.jar");
        }
    }

    public Image getImage(String fname, Toolkit toolkit) {
        Image image = null;
        if (!Jedas.isApplet()) {
            if (this.archive == null) {
                this.getArchive();
            }
            try {
                ZipEntry ze = this.archive.getEntry(fname);
                if (ze == null) {
                    System.err.println("getImage: Cannot find " + fname + " in " + "jedas201.jar");
                }
                InputStream istr = this.archive.getInputStream(ze);
                BufferedInputStream bis = new BufferedInputStream(istr);
                int size = (int)ze.getSize();
                byte[] imagedata = new byte[size];
                int ln = 0;
                int sizeRead = 0;
                while (sizeRead < size && (ln = bis.read(imagedata, sizeRead, size - sizeRead)) != -1) {
                    sizeRead += ln;
                }
                bis.close();
                image = toolkit.createImage(imagedata);
            }
            catch (IOException e) {
                System.err.println("getImage: Could not load image " + fname + " from " + "jedas201.jar");
            }
        } else {
            Applet applet = Jedas.getApplet();
            URL codebase = Jedas.getCodeBase();
            System.err.println("ImageLoader::AppletMode, loading image...");
            image = applet.getImage(codebase, fname);
        }
        return image;
    }
}

