/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Vector;
import jedas.Jedas;
import jedas.utils.ToolButton;

public class Toolbar
extends Panel {
    protected Vector toolButtons;
    protected ToolButton selected;
    protected int cols = 1;
    protected final int dist = 3;
    private int tag = 0;

    public int getTag() {
        return this.tag;
    }

    public Toolbar(int x, int y, int cols, int tag) {
        this.setBounds(x, y, 0, 0);
        this.cols = cols;
        this.tag = tag;
        if (cols == 0) {
            cols = 100;
        }
        this.toolButtons = new Vector();
        this.setLayout(null);
        this.setBackground(Jedas.DEFAULT_BGCOLOR);
    }

    public void addElement(ToolButton toolButton) {
        this.add(toolButton);
        this.toolButtons.addElement(toolButton);
        int w = toolButton.getPreferredSize().width;
        int h = toolButton.getPreferredSize().height;
        int n = this.toolButtons.size();
        if (n == 1) {
            this.select(toolButton);
        }
        int currentXPos = (n - 1) % this.cols * (w + 3) + 3;
        int currentYPos = (n - 1) / this.cols * (h + 3) + 3;
        toolButton.setBounds(currentXPos, currentYPos, w, h);
        this.setBounds(this.getBounds().x, this.getBounds().y, (w + 3) * this.cols + 6, (h + 3) * (n / this.cols) + 6);
    }

    public void select(ToolButton toolButton) {
        if (this.selected != null) {
            this.selected.deselect();
        }
        this.selected = toolButton;
        if (this.selected != null) {
            this.selected.select();
        }
    }

    public ToolButton getSelected() {
        return this.selected;
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.draw3DRect(0, 0, this.getSize().width - 2, this.getSize().height - 2, true);
    }
}

