/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jedas.CompPanel;
import jedas.DPair;
import jedas.Jedas;
import jedas.Scheduler;
import jedas.Trans;
import jedas.TransStub;
import jedas.ZoomScrollListener;
import jedas.ZoomScrollObj;

public class ZoomSetPanel
extends Panel
implements ZoomScrollListener {
    public static int COMPONENT_SIZE = 12;
    CompPanel compPanel;
    private Scrollbar scrollX;
    private Scrollbar scrollY;
    private Scrollbar zoom;
    private ZoomScrollObj zso = null;
    private boolean ignoreEvents = false;
    public static boolean ANIM_RESET = true;
    public static int TIME = 1000;
    private UpdateThread updateThread;

    public ZoomSetPanel(CompPanel compPanel) {
        this.compPanel = compPanel;
        this.updateThread = new UpdateThread();
        this.updateThread.start();
        this.initGUI();
        if (!System.getProperty("os.name").equalsIgnoreCase("solaris")) {
            compPanel.addZoomScrollListener(this);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        Panel south = new Panel();
        south.setLayout(new BorderLayout());
        Button b = new Button(){

            public Dimension getPreferredSize() {
                return new Dimension(COMPONENT_SIZE, COMPONENT_SIZE);
            }
        };
        b.addActionListener(new ZoomResetListener());
        south.add((Component)b, "East");
        ZoomScrollAdapter zsl = new ZoomScrollAdapter();
        this.scrollX = new Scrollbar(0, 0, 50, -200, 200){

            public Dimension getPreferredSize() {
                return new Dimension(COMPONENT_SIZE, COMPONENT_SIZE);
            }
        };
        this.scrollX.addAdjustmentListener(zsl);
        south.add((Component)this.scrollX, "Center");
        this.scrollY = new Scrollbar(1, 0, 50, -200, 200){

            public Dimension getPreferredSize() {
                return new Dimension(COMPONENT_SIZE, COMPONENT_SIZE);
            }
        };
        this.scrollY.addAdjustmentListener(zsl);
        this.add((Component)this.scrollY, "East");
        this.add((Component)south, "South");
        this.add((Component)this.compPanel.getDrawPanel(), "Center");
        this.zoom = new Scrollbar(1, 100, 50, 25, 400){

            public Dimension getPreferredSize() {
                return new Dimension(COMPONENT_SIZE, COMPONENT_SIZE);
            }
        };
        this.zoom.addAdjustmentListener(zsl);
        this.add((Component)this.zoom, "West");
    }

    protected void checkUpdate() {
        if (Jedas.getScheduler() != null) {
            if (!Jedas.getScheduler().isRunning()) {
                this.updateThread.requestUpdate();
            }
        } else {
            this.updateThread.requestUpdate();
        }
    }

    public void zoomChanged(double newZoom) {
        if (!this.ignoreEvents) {
            double intZ = newZoom * 100.0;
            if (intZ > 400.0) {
                intZ = 400.0;
            }
            if (intZ < 25.0) {
                intZ = 25.0;
            }
            this.zoom.setValue((int)intZ);
        }
    }

    public void hotSpotChanged(DPair newHotSpot) {
        if (!this.ignoreEvents) {
            double sX = (newHotSpot.value[0] - 0.5) * 100.0;
            if (sX > 200.0) {
                sX = 200.0;
            }
            if (sX < -200.0) {
                sX = -200.0;
            }
            this.scrollX.setValue((int)sX);
            double sY = (newHotSpot.value[1] - 0.5) * 100.0;
            if (sY > 200.0) {
                sY = 200.0;
            }
            if (sY < -200.0) {
                sY = -200.0;
            }
            this.scrollY.setValue((int)sY);
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean newRequest = false;

        private UpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (!this.newRequest) {
                    UpdateThread updateThread = this;
                    synchronized (updateThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                this.newRequest = false;
                Jedas.updateDisplay();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestUpdate() {
            this.newRequest = true;
            UpdateThread updateThread = this;
            synchronized (updateThread) {
                this.notify();
            }
        }
    }

    private class ZoomResetListener
    implements ActionListener {
        private ZoomResetListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Scheduler s = Jedas.getScheduler();
            if (s != null && s.isAcceptingTransitions() && ANIM_RESET) {
                if (ZoomSetPanel.this.zso == null) {
                    ZoomSetPanel.this.zso = new ZoomScrollObj(ZoomSetPanel.this.compPanel);
                }
                TransStub[] t = new Trans[]{ZoomSetPanel.this.zso.createZoom(ZoomSetPanel.this.compPanel.getZoom(), 1.0, TIME), ZoomSetPanel.this.zso.createCameraDistance(ZoomSetPanel.this.compPanel.getHotSpot(), new DPair(0.5, 0.5), TIME)};
                s.add(t);
            } else {
                ZoomSetPanel.this.compPanel.setHotSpot(new DPair(0.5, 0.5));
                ZoomSetPanel.this.compPanel.setZoom(1.0);
                ZoomSetPanel.this.checkUpdate();
            }
        }
    }

    private class ZoomScrollAdapter
    implements AdjustmentListener {
        private ZoomScrollAdapter() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            double newValue = (double)e.getValue() / 100.0;
            ZoomSetPanel.this.ignoreEvents = true;
            if (e.getSource() == ZoomSetPanel.this.scrollX) {
                DPair hs = ZoomSetPanel.this.compPanel.getHotSpot();
                hs.value[0] = 0.5 + newValue;
                ZoomSetPanel.this.compPanel.setHotSpot(hs);
                ZoomSetPanel.this.checkUpdate();
            } else if (e.getSource() == ZoomSetPanel.this.scrollY) {
                DPair hs = ZoomSetPanel.this.compPanel.getHotSpot();
                hs.value[1] = 0.5 + newValue;
                ZoomSetPanel.this.compPanel.setHotSpot(hs);
                ZoomSetPanel.this.checkUpdate();
            } else {
                ZoomSetPanel.this.compPanel.setZoom(newValue);
                ZoomSetPanel.this.checkUpdate();
            }
            ZoomSetPanel.this.ignoreEvents = false;
        }
    }
}

