/*
 * Decompiled with CFR 0.152.
 */
package work;

import generation.AutoGenerator;
import help.HelpFrame;
import help.HelpTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jedas.Jedas;
import mauda.AboutFrame;
import mauda.Difficulties;
import mauda.ExerciseMode;
import mauda.ExerciseUpdateEvent;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.OperationRecorder;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.SimpleFeedback;
import mauda.feedback.select.DifficultySelector;
import mauda.feedback.select.FeedbackSelector;
import mauda.feedback.select.ModeSelector;
import mauda.feedback.select.PlugInSelector;
import mauda.feedback.types.DemandFeedback;
import mauda.feedback.types.ErrorFlagging;
import mauda.feedback.types.FaultFeedback;
import mauda.feedback.types.ImmediateFeedbackAndErrorCorrection;
import mauda.feedback.types.NoTutor;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.utils.FileLocation;
import mauda.utils.PreviewPanel;
import mauda.utils.Prop;
import mauda.utils.XMLFilter;

public class MenuToolBarListener
implements ActionListener {
    private FeedbackExercise exercise;
    private Vector editTabs;
    private JFileChooser fileChooser;
    private PreviewPanel previewPanel = new PreviewPanel();
    private PlugInSelector plugInSelector;
    private DifficultySelector difficultySelector;
    private ModeSelector modeSelector;
    private FeedbackSelector feedbackSelector;

    public MenuToolBarListener(FeedbackExercise exercise) {
        this.exercise = exercise;
        this.plugInSelector = new PlugInSelector(exercise.getPlugInHandler());
        this.difficultySelector = new DifficultySelector();
        this.modeSelector = new ModeSelector();
        this.feedbackSelector = new FeedbackSelector();
        this.fileChooser = new JFileChooser(FileLocation.unworkedPath);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.addChoosableFileFilter(new XMLFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setAccessory(this.previewPanel);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                    File f = (File)e.getNewValue();
                    if (f == null) {
                        return;
                    }
                    String s = f.getPath();
                    String suffix = null;
                    int i = s.lastIndexOf(46);
                    if (i > 0 && i < s.length() - 1) {
                        suffix = s.substring(i + 1).toLowerCase();
                    }
                    if (suffix != null && suffix.equals("xml")) {
                        MenuToolBarListener.this.previewPanel.configure(f);
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        if (s == "NewFile") {
            MetaData.setDisplayMode(1);
            this.fileChooser.setCurrentDirectory(new File(FileLocation.unworkedPath));
            this.openFile();
            MetaData.setDisplayMode(2);
            this.exercise.setFilename(this.exercise.getDefaultFilename());
        } else if (s == "NewAutoFile") {
            this.openAutoGeneratorFile();
        } else if (s == "OpenFile") {
            MetaData.setDisplayMode(2);
            this.fileChooser.setCurrentDirectory(new File(FileLocation.inProcessPath));
            this.openFile();
        } else if (s == "SaveFile") {
            if (!this.exerciseLoaded()) {
                return;
            }
            SimpleFeedback actFeedback = this.exercise.getFeedback();
            if (actFeedback.exerciseFinished()) {
                return;
            }
            this.saveFile(this.exercise.getFilename());
        } else if (s == "SaveAsFile") {
            if (!this.exerciseLoaded()) {
                return;
            }
            SimpleFeedback actFeedback = this.exercise.getFeedback();
            if (actFeedback.exerciseFinished()) {
                return;
            }
            this.fileChooser.setCurrentDirectory(new File(FileLocation.inProcessPath));
            this.saveAsFile();
        } else if (s == "Meta") {
            if (!this.exerciseLoaded()) {
                return;
            }
            boolean mod = this.exercise.getMetaData().inputDialog();
            if (mod) {
                this.exercise.setModified(true);
            }
        } else if (s == "Exit") {
            if (this.dialogDiscardActiveExercise()) {
                System.exit(0);
            }
        } else if (s == "ReloadKB") {
            this.exercise.getFeedback().getFeedbackGenerator().loadKB();
        } else if (s == "SwitchFeedback") {
            if (!this.exerciseLoaded()) {
                return;
            }
            SimpleFeedback actFeedback = this.exercise.getFeedback();
            if (actFeedback.exerciseFinished()) {
                return;
            }
            if (actFeedback instanceof FaultFeedback) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "No Feedback-Switching for Fault-Mode-Exercises possible");
                return;
            }
            int actFeedbackType = this.feedbackSelector.getFeedbackType();
            if (actFeedbackType == -1) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "No exercise loaded!\n\n=> No Feedback-Type change possible!");
                return;
            }
            int feedbackType = this.showFeedbackSelector();
            SimpleFeedback feedback = this.createFeedback(feedbackType);
            this.exercise.setFeedback(feedback);
            actFeedback.switchTo(feedback, true);
        } else if (s == "Undo") {
            SimpleFeedback actFeedback = this.exercise.getFeedback();
            if (actFeedback.getFeedbackTypeID() == 4) {
                return;
            }
            if (actFeedback.exerciseFinished()) {
                return;
            }
            this.exercise.undo();
        } else if (s == "Redo") {
            SimpleFeedback actFeedback = this.exercise.getFeedback();
            if (actFeedback.getFeedbackTypeID() == 4) {
                return;
            }
            if (actFeedback.exerciseFinished()) {
                return;
            }
            this.exercise.redo();
        } else if (s == "ShowAbout") {
            AboutFrame.createAndShowGUI();
        } else if (s == "ShowHelp") {
            HelpTree.setView((int)2);
            HelpFrame.createAndShowGUI();
        }
    }

    private boolean exerciseLoaded() {
        if (this.exercise.getFeedback().getTodoOperationQueue() == null) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Please load a exercise!");
            return false;
        }
        return true;
    }

    private boolean newFile() {
        if (!this.dialogDiscardActiveExercise()) {
            return false;
        }
        this.exercise.reset();
        Jedas.updateDisplay();
        this.exercise.setDefaultFilename();
        this.updateFilenameLabel();
        return true;
    }

    private void openAutoGeneratorFile() {
        if (!this.dialogDiscardActiveExercise()) {
            return;
        }
        JPanel p = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gbl);
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridwidth = 4;
        JLabel label = new JLabel("Please specify what kind of exercise you want to generate!");
        p.add(label);
        gbl.setConstraints(label, c);
        c.gridwidth = 1;
        c.gridy = 1;
        p.add(this.plugInSelector);
        gbl.setConstraints(this.plugInSelector, c);
        c.gridx = 1;
        p.add(this.difficultySelector);
        gbl.setConstraints(this.difficultySelector, c);
        c.gridx = 2;
        p.add(this.modeSelector);
        gbl.setConstraints(this.modeSelector, c);
        c.gridx = 3;
        p.add(this.feedbackSelector);
        gbl.setConstraints(this.feedbackSelector, c);
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), p, "Select Properties", 2);
        if (result != 0) {
            return;
        }
        String type = this.plugInSelector.getPlugInName();
        String diff = Difficulties.getString(this.difficultySelector.getDifficulty());
        String mode = ExerciseMode.getString(this.modeSelector.getMode());
        int feedbackType = this.feedbackSelector.getFeedbackType();
        AutoGenerator ag = new AutoGenerator(type, diff, mode, false);
        HashMap hm = ag.getExercise();
        boolean ok = this.exercise.loadConfig(hm);
        if (!ok) {
            return;
        }
        this.exercise.reset();
        this.exercise.removeExerciseUpdateListener(this.exercise.getFeedback());
        this.exercise.loadConfig(hm);
        this.openExercise(hm, feedbackType);
    }

    private void openFile() {
        File file;
        if (!this.dialogDiscardActiveExercise()) {
            return;
        }
        int state = this.fileChooser.showOpenDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()).isFile()) {
            this.exercise.reset();
            this.exercise.removeExerciseUpdateListener(this.exercise.getFeedback());
            this.openFile(file);
        }
    }

    private void openFile(File file) {
        Object opVector = null;
        this.exercise.setFilename(file.getAbsolutePath());
        HashMap hm = this.exercise.load(this.exercise.getFilename());
        boolean ok = this.openExercise(hm, -1);
    }

    private boolean openExercise(HashMap hm, int feedbackType) {
        if (hm == null) {
            return false;
        }
        String editorState = this.exercise.getMetaData().getEditorState();
        if (!editorState.equals("unworked")) {
            if (editorState.equals("in process")) {
                this.exercise.loadWork(hm);
                return true;
            }
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load a completed exercise.");
            return true;
        }
        this.exercise.load(hm);
        OperationRecorder or = this.exercise.getOperationRecorder();
        Vector initOps = or.getInitOperationQueue().toVector();
        Vector todoOps = or.getTodoOperationQueue().toVector();
        Enumeration en = todoOps.elements();
        while (en.hasMoreElements()) {
            Operation o;
            SimpleOperation so = (SimpleOperation)en.nextElement();
            if (!(so instanceof Operation) || !(o = (Operation)so).isExecuted()) continue;
            o.setExecution(false);
        }
        or.clear();
        or.addOperations(initOps);
        or.goInTodoMode();
        or.addOperations(todoOps);
        MetaData metaData = this.exercise.getMetaData();
        int mode = metaData.getMode();
        SimpleFeedback feedback = null;
        if (mode == 0) {
            if (feedbackType == -1) {
                feedbackType = this.showFeedbackSelector();
            }
            feedback = this.createFeedback(feedbackType);
            feedback.setInitOperationQueue(or.getInitOperationQueue());
            feedback.setTodoOperationQueue(or.getTodoOperationQueue());
        } else if (mode == 1) {
            feedback = new FaultFeedback(this.exercise);
            feedback.setInitOperationQueue(or.getInitOperationQueue());
            feedback.setTodoOperationQueue(or.getTodoOperationQueue());
        } else {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Unknown mode!");
            return false;
        }
        metaData.setEditorName("<Please enter your name!>");
        metaData.actualizeEditorDate();
        metaData.setEditorFeedback(FeedbackSelector.getFeedbackTypeNameFromID(feedback.getFeedbackTypeID()));
        metaData.setEditorState("in process");
        this.exercise.addExerciseUpdateListener(feedback);
        this.exercise.setFeedback(feedback);
        feedback.displayLoadingMessage();
        Vector exOps = new Vector();
        exOps.add(new ExerciseUpdateEvent(this.exercise, 5));
        exOps.addAll((Vector)or.getInitOperations().clone());
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, -1);
        eue.setMessage("GO_IN_TODO-MODE");
        exOps.add(eue);
        exOps.add(new ExerciseUpdateEvent(this.exercise, 2));
        exOps.add(new ExerciseUpdateEvent(this.exercise, 6));
        exOps.add(new ExerciseUpdateEvent(this.exercise, 4));
        exOps = this.exercise.addFullLoadedMessage(exOps);
        this.exercise.getUndoRedo().clear();
        this.exercise.setDSObject(this.exercise.getUndoRedo().getDSObject());
        or.clear();
        this.exercise.commit(exOps);
        return true;
    }

    protected int showFeedbackSelector() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 10));
        JLabel label = new JLabel("Please select a Feedback-Type ...");
        p.add((Component)label, "North");
        p.add((Component)this.feedbackSelector, "Center");
        JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), p);
        return this.feedbackSelector.getFeedbackType();
    }

    private SimpleFeedback createFeedback(int feedbackType) {
        SimpleFeedback feedback = null;
        switch (feedbackType) {
            case 0: {
                feedback = new ImmediateFeedbackAndErrorCorrection(this.exercise);
                break;
            }
            case 1: {
                feedback = new ErrorFlagging(this.exercise);
                break;
            }
            case 2: {
                feedback = new DemandFeedback(this.exercise);
                break;
            }
            case 3: {
                feedback = new NoTutor(this.exercise);
            }
        }
        return feedback;
    }

    private void saveFile(String fname) {
        if (fname.equals(this.exercise.getDefaultFilename())) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "DialogChooseSaveAs"));
            return;
        }
        this.exercise.getMetaData().inputDialog();
        this.exercise.saveWork(fname);
        this.exercise.setFilename(fname);
        this.updateFilenameLabel();
    }

    private void saveAsFile() {
        File file;
        int state = this.fileChooser.showSaveDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()) != null) {
            String fname = file.getAbsolutePath();
            if (file.exists() && !this.dialogExistsOverwrite(fname)) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "FileNotSaved"));
                return;
            }
            if (!fname.toLowerCase().endsWith(".xml")) {
                fname = String.valueOf(fname) + ".xml";
            }
            this.exercise.getMetaData().inputDialog();
            this.exercise.saveWork(fname);
            this.exercise.setFilename(fname);
            this.updateFilenameLabel();
        }
    }

    private void updateFilenameLabel() {
    }

    private boolean dialogExistsOverwrite(String filename) {
        String s = Prop.get(this, "DialogExistsOverwrite");
        s = s.replaceAll("FILENAME", filename);
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "DialogExistsOverwriteTitle"), 1, 2);
        return result == 0;
    }

    private boolean dialogDiscardActiveExercise() {
        if (!this.exercise.isModified()) {
            return true;
        }
        String s = Prop.get(this, "DialogDiscardActiveExercise");
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "DialogDiscardActiveExerciseTitle"), 1, 2);
        return result == 0;
    }
}

