/*
 * Decompiled with CFR 0.152.
 */
package work;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.ModifiedDetector;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackGenerator;
import mauda.feedback.SimpleFeedback;
import mauda.feedback.types.NoTutor;
import mauda.utils.FileLocation;
import mauda.utils.MyWindowListener;
import work.ActionCommands;
import work.MenuToolBarListener;
import work.TopToolBar;
import work.WorkMenu;

public class WorkEditor
extends JFrame
implements ExerciseUpdateListener {
    private String frameTitle = "MA&DA WorkEditor V1.00";

    public static void main(String[] args) {
        new WorkEditor();
    }

    public WorkEditor() {
        MAUDA.setApplicationMainFrame(this);
        ActionCommands.showReloadKBButton = false;
        FileLocation.config();
        this.setDefaultCloseOperation(0);
        FeedbackExercise exercise = new FeedbackExercise("FibHeap");
        exercise.addExerciseUpdateListener(this);
        exercise.setInteractiveMode(3);
        exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));
        this.addWindowListener(new MyWindowListener(exercise));
        Container contentPane = this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        SimpleFeedback.feedbackGenerator = new FeedbackGenerator(exercise);
        NoTutor feedback = new NoTutor(exercise);
        exercise.setFeedback(feedback);
        MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
        mainPanel.add((Component)new TopToolBar(menuToolBarListener), "North");
        this.setMenuBar(new WorkMenu(menuToolBarListener));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setRightComponent(exercise.getFeedbackPanel());
        splitPane.setLeftComponent(exercise.jedasPanel);
        splitPane.setOneTouchExpandable(true);
        exercise.getFeedbackPanel().setMinimumSize(new Dimension(240, 50));
        exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));
        mainPanel.add((Component)splitPane, "Center");
        contentPane.add((Component)mainPanel, "Center");
        exercise.jedasPanel.setMessage("Please load an exercise...");
        this.setBounds(0, 0, 800, 550);
        this.setTitle(this.frameTitle);
        this.setVisible(true);
        splitPane.setDividerLocation(540);
        MetaData.setDisplayMode(2);
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() != 1) {
            return;
        }
        String filename = e.getExercise().getFilename();
        filename = filename.replace('\\', '/');
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        this.setTitle(String.valueOf(filename) + " - " + this.frameTitle);
    }
}

