/*
 * Decompiled with CFR 0.152.
 */
package generation;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import mauda.Difficulties;
import mauda.utils.Prop;

public class GeneratorMenu
extends MenuBar {
    private EventListener actionListener;
    private Menu switchTo = new Menu(Prop.get(this, "SwitchTo"));
    private Menu file = new Menu(Prop.get(this, "File"));
    private Menu edit = new Menu(Prop.get(this, "Edit"));
    private Menu mode = new Menu(Prop.get(this, "Mode"));
    private Menu diff = new Menu(Prop.get(this, "Difficulty"));
    private Menu info = new Menu(Prop.get(this, "Information"));

    public GeneratorMenu(EventListener al) {
        this.actionListener = al;
        this.add(this.switchTo);
        this.addMI(this.file, "NewFile");
        this.addMI(this.file, "OpenFile");
        this.addMI(this.file, "SaveFile");
        this.addMI(this.file, "SaveAsFile");
        this.addMI(this.file, "Meta");
        this.addMI(this.file, "Automatic");
        this.file.addSeparator();
        this.addMI(this.file, "Exit");
        this.add(this.file);
        this.addMI(this.edit, "Undo");
        this.addMI(this.edit, "Redo");
        this.edit.addSeparator();
        this.addCMI(this.edit, "SubOperationEdit");
        this.add(this.edit);
        this.addMI(this.mode, "NormalMode");
        this.addMI(this.mode, "FaultMode");
        this.add(this.mode);
        this.addMIDifficulty(this.diff, "Difficulty-0", 0);
        this.addMIDifficulty(this.diff, "Difficulty-1", 1);
        this.addMIDifficulty(this.diff, "Difficulty-2", 2);
        this.add(this.diff);
        this.addMI(this.info, "ShowAbout");
        this.addMI(this.info, "ShowHelp");
        this.add(this.info);
    }

    private void addMI(Menu m, String text) {
        String label = Prop.get(this, text);
        MenuItem mi = new MenuItem(label);
        mi.addActionListener((ActionListener)this.actionListener);
        mi.setActionCommand(text);
        m.add(mi);
    }

    private void addMIDifficulty(Menu m, String ac, int d) {
        String label = Difficulties.getGUIString(d);
        MenuItem mi = new MenuItem(label);
        mi.addActionListener((ActionListener)this.actionListener);
        mi.setActionCommand(ac);
        m.add(mi);
    }

    private void addCMI(Menu m, String text) {
        String label = Prop.get(this, text);
        CheckboxMenuItem cmi = new CheckboxMenuItem(label);
        cmi.addItemListener((ItemListener)this.actionListener);
        cmi.setActionCommand(text);
        m.add(cmi);
    }

    protected void addPlugIn(String plugInID, String plugInString) {
        MenuItem mi = new MenuItem(plugInString);
        mi.addActionListener((ActionListener)this.actionListener);
        mi.setActionCommand("PLUGIN: " + plugInID);
        this.switchTo.add(mi);
    }
}

