/*
 * Decompiled with CFR 0.152.
 */
package generation;

import generation.EditTab;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jedas.Jedas;
import mauda.MAUDA;
import mauda.SimpleExercise;
import mauda.XMLFileAccess;
import mauda.generation.GenExercise;
import mauda.plugin.OperationExecuter;
import mauda.plugin.Ratings;
import mauda.utils.Prop;

public class RatingTab
extends EditTab
implements ListSelectionListener {
    protected String ratingFilename = "rating.xml";
    private JList list;
    private Vector idVector;
    protected static final String tabName = "Rating";
    protected static final String load = "Load";
    protected static final String save = "Save";
    protected static final String change = "Change";
    protected static final String changeMessageTitle = "ChangeMessageTitle";

    public RatingTab(GenExercise exercise) {
        super(exercise);
        this.setTabName(tabName);
        this.updateSettings();
        this.idVector = new Vector();
        this.list = new JList(new Vector());
        this.list.addListSelectionListener(this);
        this.setTopPanel(new JScrollPane(this.list));
        this.createButton(load);
        this.createButton(save);
        this.createButton(change);
    }

    protected void doUpdate() {
        this.updateLists();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        OperationExecuter oe = SimpleExercise.getOperationExecuter();
        Ratings ratings = oe.getRatings();
        String s = e.getActionCommand();
        if (s == change) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            String key = (String)this.idVector.elementAt(index);
            int value = (Integer)ratings.get(key);
            JPanel inputPanel = new JPanel();
            JLabel keyLabel = new JLabel(key);
            inputPanel.add(keyLabel);
            JTextField valueTextField = new JTextField(String.valueOf(value), 3);
            inputPanel.add(valueTextField);
            int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), inputPanel, Prop.get(this, "RatingChangeMessageTitle"), 2);
            if (result == 0) {
                int newValue = Integer.parseInt(valueTextField.getText());
                ratings.put(key, new Integer(newValue));
                this.update();
            }
        } else if (s == load) {
            if (this.dialog("LOAD " + this.dataFilename)) {
                this.loadConfig(this.dataFilename);
                this.update();
            }
        } else if (s == save && this.dialog("SAVE " + this.dataFilename)) {
            Vector<Vector> savevev = new Vector<Vector>();
            savevev.add(ratings.save());
            boolean result = XMLFileAccess.save(this.dataFilename, savevev);
            if (!result) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '" + this.dataFilename + "' !\n\n" + "--> File not saved!");
            }
        }
    }

    protected void loadConfig(String filename) {
        Vector v = XMLFileAccess.load(this.dataFilename);
        OperationExecuter oe = SimpleExercise.getOperationExecuter();
        Ratings ratings = oe.getRatings();
        if (v == null) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load '" + filename + "'!");
            return;
        }
        ratings.load((Vector)v.firstElement());
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    protected void updateLists() {
        OperationExecuter oe = SimpleExercise.getOperationExecuter();
        Ratings ratings = oe.getRatings();
        int size = ratings.size();
        String[] sarr = new String[size];
        Iterator it = ratings.keySet().iterator();
        int c = 0;
        while (it.hasNext()) {
            sarr[c] = (String)it.next();
            ++c;
        }
        Arrays.sort(sarr, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        Vector<String> listData = new Vector<String>();
        int i = 0;
        while (i < sarr.length) {
            String key = sarr[i];
            int value = (Integer)ratings.get(key);
            listData.add(String.valueOf(key) + " = " + value);
            this.idVector.add(key);
            ++i;
        }
        this.list.setListData(listData);
        Jedas.updateDisplay();
    }

    protected void updateSettings() {
        super.updateSettings();
        this.setDataFilename(this.ratingFilename);
    }
}

