/*
 * Decompiled with CFR 0.152.
 */
package evaluation;

import evaluation.EvalEditorMenu;
import evaluation.MenuToolBarListener;
import evaluation.TopToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import jedas.Jedas;
import jedas.annotate.AnnotationFrame;
import jedas.io.Recorder;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.ModifiedDetector;
import mauda.evaluation.EvalExercise;
import mauda.jedasnew.RecordFrame;
import mauda.utils.FileLocation;
import mauda.utils.MyWindowListener;

public class EvalEditor
extends JFrame
implements ExerciseUpdateListener {
    private AnnotationFrame annotationFrame;
    private RecordFrame recordFrame;
    private String frameTitle = "MA&DA EvalEditor V1.00";

    public static void main(String[] args) {
        new EvalEditor();
    }

    public EvalEditor() {
        MAUDA.setApplicationMainFrame(this);
        FileLocation.config();
        this.setDefaultCloseOperation(0);
        EvalExercise exercise = new EvalExercise("FibHeap");
        exercise.addExerciseUpdateListener(this);
        exercise.setInteractiveMode(3);
        exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));
        this.addWindowListener(new MyWindowListener(exercise));
        Container contentPane = this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
        mainPanel.add((Component)new TopToolBar(menuToolBarListener), "North");
        this.setMenuBar(new EvalEditorMenu(menuToolBarListener));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JSplitPane sp = new JSplitPane(0);
        sp.setBottomComponent(exercise.getCommentView().getPanel());
        sp.setTopComponent(exercise.getTreeOperationView().getPanel());
        sp.setOneTouchExpandable(true);
        sp.setDividerLocation(350);
        rightPanel.add((Component)sp, "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setRightComponent(rightPanel);
        splitPane.setLeftComponent(exercise.jedasPanel);
        splitPane.setOneTouchExpandable(true);
        rightPanel.setMinimumSize(new Dimension(240, 50));
        exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));
        mainPanel.add((Component)splitPane, "Center");
        contentPane.add((Component)mainPanel, "Center");
        this.setBounds(0, 0, 800, 550);
        this.setTitle(this.frameTitle);
        splitPane.setDividerLocation(540);
        MetaData.setDisplayMode(2);
        Jedas.setApplicationMainFrame(this);
        this.annotationFrame = new AnnotationFrame(Exercise.scheduler, Exercise.compPanel);
        this.recordFrame = new RecordFrame();
        this.recordFrame.setExercise(exercise);
        this.annotationFrame.setLocation(new Point(0, 0));
        this.recordFrame.setLocation(new Point(0, this.annotationFrame.getHeight()));
        this.setLocation(new Point(this.annotationFrame.getWidth(), 0));
        final EvalEditor mf = this;
        this.addWindowStateListener(new WindowAdapter(){
            private int oldState = 0;

            public void windowStateChanged(WindowEvent e) {
                int state = mf.getState();
                if (state != this.oldState) {
                    this.oldState = state;
                    EvalEditor.this.annotationFrame.setState(state);
                    EvalEditor.this.recordFrame.setState(state);
                    mf.toFront();
                    mf.requestFocus();
                }
            }
        });
        exercise.jedasPanel.setMessage("Please load an exercise...");
        this.setVisible(true);
        Recorder recorder = Jedas.getRecorder();
        Recorder.setFileName(FileLocation.jedasRecordingFilename);
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() != 1) {
            return;
        }
        String filename = e.getExercise().getFilename();
        filename = filename.replace('\\', '/');
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        this.setTitle(String.valueOf(filename) + " - " + this.frameTitle);
    }
}

